/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gcr.sonar;

import io.jenkins.plugins.gcr.models.Coverage;
import io.jenkins.plugins.gcr.sonar.SonarException;
import io.jenkins.plugins.gcr.sonar.models.SonarProject;
import io.jenkins.plugins.gcr.sonar.parsers.SonarCoverageParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class SonarClient {
    private static final String METRIC_KEY = "line_coverage,branch_coverage,coverage";
    private HttpClient httpClient;
    private String sonarHost;
    private int sonarPort;

    public SonarClient() {
        this((HttpClient)HttpClientBuilder.create().build(), "localhost");
    }

    public SonarClient(HttpClient client) {
        this(client, "localhost");
    }

    public SonarClient(HttpClient client, String sonarHost) {
        this(client, sonarHost, 9000);
    }

    public SonarClient(HttpClient client, String sonarHost, int sonarPort) {
        this.sonarHost = sonarHost;
        this.sonarPort = sonarPort;
        this.httpClient = client;
    }

    public List<SonarProject> listProjects() throws IOException {
        String url = this.fullUrl("api/components/search?qualifiers=TRK");
        HttpGet request = new HttpGet(url);
        ResponseHandler responseHandler = httpResponse -> {
            String responseText = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            JSONObject jsonObject = JSONObject.fromObject((Object)responseText);
            JSONArray projectArray = jsonObject.getJSONArray("components");
            ArrayList projects = new ArrayList();
            projectArray.forEach(item -> {
                JSONObject obj = (JSONObject)item;
                SonarProject project = new SonarProject(obj.getString("name"), obj.getString("key"));
                projects.add(project);
            });
            return projects;
        };
        List projects = (List)this.httpClient.execute((HttpUriRequest)request, responseHandler);
        return projects;
    }

    public Coverage getCoverageForProject(String projectKey) throws SonarException {
        String url = this.fullUrl(String.format("api/measures/component?component=%s&metricKeys=%s", projectKey, METRIC_KEY));
        HttpGet request = new HttpGet(url);
        ResponseHandler responseHandler = httpResponse -> {
            String responseText = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            JSONObject jsonResponse = JSONObject.fromObject((Object)responseText);
            SonarCoverageParser parser = new SonarCoverageParser();
            return parser.parse(jsonResponse);
        };
        try {
            return (Coverage)this.httpClient.execute((HttpUriRequest)request, responseHandler);
        }
        catch (IOException ex) {
            String message = String.format("Failed to retrieve coverage from sonar project '%s'", projectKey);
            throw new SonarException(message, ex);
        }
    }

    private String fullUrl(String path) {
        return String.format("http://%s:%s/%s", this.sonarHost, this.sonarPort, path);
    }
}

