/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gcr.github;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.jenkins.plugins.gcr.github.GithubClientException;
import io.jenkins.plugins.gcr.github.GithubPayload;
import io.jenkins.plugins.gcr.github.GithubResponse;
import io.jenkins.plugins.gcr.models.PluginEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;

public class GithubClient {
    private PluginEnvironment environment;
    private String accessToken;
    private String githubUrl;
    private HttpClient httpClient;

    public GithubClient(PluginEnvironment environment, String githubUrl, String accessToken) {
        this(environment, githubUrl, accessToken, (HttpClient)HttpClientBuilder.create().build());
    }

    public GithubClient(PluginEnvironment environment, String githubUrl, String accessToken, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.environment = environment;
        this.accessToken = accessToken;
        this.githubUrl = githubUrl;
    }

    private String fetchGitHashFromGithub(String repo, String pullid) throws GithubClientException {
        String path = String.format("/repos/%s/pulls/%s", repo, pullid);
        URI uri = this.buildUri(path);
        HttpGet getRequest = new HttpGet(uri);
        ResponseHandler responseHandler = response -> {
            InputStream stream = response.getEntity().getContent();
            String string = IOUtils.toString((InputStream)stream, (String)"utf-8");
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                try {
                    JsonObject obj = new JsonParser().parse(string).getAsJsonObject();
                    JsonObject head = obj.getAsJsonObject("head");
                    JsonPrimitive sha = head.getAsJsonPrimitive("sha");
                    String shaString = sha.getAsString();
                    return new GithubResponse(true, shaString);
                }
                catch (Exception e) {
                    String message = String.format("Not able to find .head.sha when accessing %s into: %s %s", uri, e.toString(), string);
                    return new GithubResponse(false, message);
                }
            }
            String body = IOUtils.toString((InputStream)response.getEntity().getContent());
            String message = String.format("[%d] %s", status, body);
            return new GithubResponse(false, message);
        };
        try {
            GithubResponse result = (GithubResponse)this.httpClient.execute((HttpUriRequest)getRequest, responseHandler);
            if (!result.isSuccess()) {
                String message = String.format("Bad HTTP result for url %s. Error message: %s", getRequest.getURI().toString(), result.getMessage());
                throw new GithubClientException(message);
            }
            return result.getMessage();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new GithubClientException("IOException during request");
        }
    }

    public void sendCommitStatus(GithubPayload githubPayload) throws GithubClientException {
        String githash = this.environment.getGitHash();
        if (githash == null) {
            githash = this.fetchGitHashFromGithub(this.environment.getPullRequestRepository(), this.environment.getPullId());
        }
        String path = String.format("/repos/%s/statuses/%s", this.environment.getPullRequestRepository(), githash);
        URI uri = this.buildUri(path);
        HttpPost postRequest = new HttpPost(uri);
        try {
            StringEntity entity = new StringEntity(githubPayload.toJSONString());
            postRequest.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException ex) {
            throw new GithubClientException("Issue with encoding of github payload", ex);
        }
        ResponseHandler responseHandler = response -> {
            InputStream stream = response.getEntity().getContent();
            String string = IOUtils.toString((InputStream)stream);
            System.out.println(string);
            int status = response.getStatusLine().getStatusCode();
            if (status == 201) {
                return new GithubResponse(true, "");
            }
            String body = IOUtils.toString((InputStream)response.getEntity().getContent());
            String message = String.format("[%d] %s", status, body);
            return new GithubResponse(false, message);
        };
        try {
            GithubResponse result = (GithubResponse)this.httpClient.execute((HttpUriRequest)postRequest, responseHandler);
            if (!result.isSuccess()) {
                String message = String.format("Bad HTTP result for url %s. Error message:  ", postRequest.getURI().toString());
                throw new GithubClientException(message);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new GithubClientException("IOException during request");
        }
    }

    private URI buildUri(String path) throws GithubClientException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme("https");
        if (this.isCustomUrlValid()) {
            builder.setHost(this.cleanedHost());
        } else {
            builder.setHost("api.github.com");
        }
        if (this.isCustomUrlValid()) {
            path = "/api/v3".concat(path);
        }
        builder.setPath(path);
        builder.setParameter("access_token", this.accessToken);
        try {
            return builder.build();
        }
        catch (URISyntaxException ex) {
            throw new GithubClientException("URI builder syntax was malformed", ex);
        }
    }

    private boolean isCustomUrlValid() {
        return this.githubUrl != null && this.githubUrl.startsWith("https://");
    }

    private String cleanedHost() {
        if (this.githubUrl.startsWith("https://")) {
            return this.githubUrl.replaceFirst("https://", "");
        }
        return this.githubUrl;
    }
}

