/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gcr;

import hudson.model.Action;
import io.jenkins.plugins.gcr.models.Coverage;
import io.jenkins.plugins.gcr.models.CoverageRateType;

public class CoverageReportAction
implements Action {
    private Coverage coverage;
    private Coverage expectedCoverage;
    private CoverageRateType coverageType;

    public CoverageReportAction(Coverage coverage, Coverage expectedCoverage, CoverageRateType coverageType) {
        this.coverage = coverage;
        this.expectedCoverage = expectedCoverage;
        this.coverageType = coverageType;
    }

    private double toChosenCoverageValue(Coverage coverage) {
        switch (this.coverageType) {
            case LINE: {
                return coverage.getLineRate();
            }
            case BRANCH: {
                return coverage.getBranchRate();
            }
            case OVERALL: {
                return coverage.getOverallRate();
            }
        }
        return 0.0;
    }

    private String toRateFragment(Coverage coverage) {
        return String.format("%.2f%%", this.toChosenCoverageValue(coverage) * 100.0);
    }

    private String toRateDifferenceFragment(double expectedRate, double actualRate) {
        if (this.isAcceptableCoverage()) {
            double difference = actualRate - expectedRate;
            return String.format("+%.2f%%", difference * 100.0);
        }
        double difference = expectedRate - actualRate;
        return String.format("-%.2f%%", difference * 100.0);
    }

    public String getStatusDescription() {
        String template = "Coverage of %s is %s expected %s.";
        String fragment = this.isAcceptableCoverage() ? "greater than or equal to" : "lower than";
        String actualRate = this.toRateFragment(this.coverage);
        String expectedRate = this.toRateFragment(this.expectedCoverage);
        return String.format("Coverage of %s is %s expected %s.", actualRate, fragment, expectedRate);
    }

    public String getStatusName() {
        return this.isAcceptableCoverage() ? "success" : "failure";
    }

    public boolean isAcceptableCoverage() {
        return this.toChosenCoverageValue(this.coverage) >= this.toChosenCoverageValue(this.expectedCoverage);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }
}

