/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.util;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.scm.SCM;
import java.io.IOException;
import org.jenkinsci.plugins.gitclient.GitClient;

public class GitRepositoryValidator {
    @VisibleForTesting
    public static final String INFO_SHALLOW_CLONE = "Skipping issues blame since Git has been configured with shallow clone";
    private static final String HEAD = "HEAD";
    private final SCM scm;
    private final Run<?, ?> build;
    private final FilePath workTree;
    private final TaskListener listener;
    private final FilteredLog logger;

    public GitRepositoryValidator(SCM scm, Run<?, ?> build, FilePath workTree, TaskListener listener, FilteredLog logger) {
        this.scm = scm;
        this.build = build;
        this.workTree = workTree;
        this.listener = listener;
        this.logger = logger;
    }

    public boolean isGitRepository() {
        if (this.scm instanceof GitSCM) {
            return this.isValidGitRoot((GitSCM)this.scm);
        }
        this.logger.logInfo("SCM '%s' is not of type GitSCM", new Object[]{this.scm.getType()});
        return false;
    }

    private boolean isValidGitRoot(GitSCM git) {
        if (this.isShallow(git)) {
            this.logger.logInfo(INFO_SHALLOW_CLONE);
            return false;
        }
        try {
            GitClient gitClient = this.createClient();
            if (gitClient.revParse(this.getHead()) != null) {
                return true;
            }
        }
        catch (GitException | InterruptedException throwable) {
            // empty catch block
        }
        this.logger.logInfo("Exception while creating a GitClient instance for work tree '%s'", new Object[]{this.workTree});
        return false;
    }

    private boolean isShallow(GitSCM git) {
        CloneOption option = (CloneOption)git.getExtensions().get(CloneOption.class);
        if (option != null) {
            return option.isShallow();
        }
        return false;
    }

    public GitClient createClient() {
        try {
            EnvVars environment = this.build.getEnvironment(this.listener);
            return ((GitSCM)this.scm).createClient(this.listener, environment, this.build, this.workTree);
        }
        catch (IOException | InterruptedException e) {
            throw new GitException((Throwable)e);
        }
    }

    public String getHead() {
        try {
            EnvVars environment = this.build.getEnvironment(this.listener);
            return (String)environment.getOrDefault((Object)"GIT_COMMIT", (Object)HEAD);
        }
        catch (IOException | InterruptedException exception) {
            return HEAD;
        }
    }

    public String getId() {
        return this.scm.getKey();
    }

    public SCM getScm() {
        return this.scm;
    }
}

