/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.reference;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import io.jenkins.plugins.forensics.git.reference.Messages;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

class GitReferenceJobModelValidation {
    private final JenkinsFacade jenkins;

    GitReferenceJobModelValidation() {
        this(new JenkinsFacade());
    }

    @VisibleForTesting
    GitReferenceJobModelValidation(JenkinsFacade jenkins) {
        this.jenkins = jenkins;
    }

    public ComboBoxModel getAllJobs() {
        ComboBoxModel model = new ComboBoxModel((Collection)this.jenkins.getAllJobNames());
        model.add(0, (Object)"-");
        return model;
    }

    public FormValidation validateJob(String referenceJobName) {
        if ("-".equals(referenceJobName) || StringUtils.isBlank((CharSequence)referenceJobName) || this.jenkins.getJob(referenceJobName).isPresent()) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.FieldValidator_Error_ReferenceJobDoesNotExist());
    }
}

