/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.reference;

import edu.hm.hafner.util.FilteredLog;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.forensics.git.reference.BuildCommits;
import io.jenkins.plugins.forensics.git.util.AbstractRepositoryCallback;
import io.jenkins.plugins.forensics.git.util.GitCommitTextDecorator;
import io.jenkins.plugins.forensics.git.util.RemoteResultWrapper;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

class GitCommitsCollector
extends AbstractRepositoryCallback<RemoteResultWrapper<BuildCommits>> {
    private static final long serialVersionUID = -5980402198857923793L;
    private static final GitCommitTextDecorator DECORATOR = new GitCommitTextDecorator();
    private static final int MAX_COMMITS = 200;
    private final String latestRecordedCommit;

    GitCommitsCollector(String latestRecordedCommit) {
        this.latestRecordedCommit = latestRecordedCommit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RemoteResultWrapper<BuildCommits> invoke(Repository repository, VirtualChannel channel) throws IOException {
        try (Git git = new Git(repository);){
            BuildCommits commits = new BuildCommits(this.latestRecordedCommit);
            RemoteResultWrapper<BuildCommits> result = new RemoteResultWrapper<BuildCommits>(commits, "Errors while collecting commits");
            this.findHeadCommit(repository, commits, result);
            for (RevCommit commit : git.log().add((AnyObjectId)commits.getHead()).call()) {
                String commitId = commit.getName();
                if (commitId.equals(this.latestRecordedCommit) || commits.size() >= 200) {
                    RemoteResultWrapper<BuildCommits> remoteResultWrapper = result;
                    return remoteResultWrapper;
                }
                commits.add(commitId);
            }
            Object object = result;
            return object;
        }
        catch (GitAPIException e) {
            throw new IOException("Unable to record commits of git repository.", e);
        }
    }

    private void findHeadCommit(Repository repository, BuildCommits commits, FilteredLog logger) throws IOException {
        RevCommit head = this.getHead(repository);
        RevCommit[] parents = head.getParents();
        if (parents.length < 1) {
            logger.logInfo("-> No parent commits found - detected the first commit in the branch");
            logger.logInfo("-> Using head commit '%s' as starting point", new Object[]{DECORATOR.asText((ObjectId)head)});
            commits.setHead(head);
        } else if (parents.length == 1) {
            logger.logInfo("-> Single parent commit found - branch is already descendant of target branch head");
            logger.logInfo("-> Using head commit '%s' as starting point", new Object[]{DECORATOR.asText((ObjectId)head)});
            commits.setHead(head);
        } else {
            logger.logInfo("-> Multiple parent commits found - storing latest commit of local merge '%s'", new Object[]{DECORATOR.asText((ObjectId)head)});
            logger.logInfo("-> Using parent commit '%s' of local merge as starting point", new Object[]{DECORATOR.asText((ObjectId)parents[0])});
            logger.logInfo("-> Storing target branch head '%s' (second parent of local merge) ", new Object[]{DECORATOR.asText((ObjectId)parents[1])});
            commits.setHead(parents[0]);
            commits.setTarget(parents[1]);
            commits.setMerge((ObjectId)head);
        }
    }

    private RevCommit getHead(Repository repository) throws IOException {
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            throw new IOException("No HEAD commit found in " + repository);
        }
        return new RevWalk(repository).parseCommit((AnyObjectId)head);
    }
}

