/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.delta;

import edu.hm.hafner.util.FilteredLog;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.forensics.delta.Change;
import io.jenkins.plugins.forensics.delta.ChangeEditType;
import io.jenkins.plugins.forensics.delta.Delta;
import io.jenkins.plugins.forensics.delta.FileChanges;
import io.jenkins.plugins.forensics.delta.FileEditType;
import io.jenkins.plugins.forensics.git.delta.GitDelta;
import io.jenkins.plugins.forensics.git.util.AbstractRepositoryCallback;
import io.jenkins.plugins.forensics.git.util.RemoteResultWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class DeltaRepositoryCallback
extends AbstractRepositoryCallback<RemoteResultWrapper<Delta>> {
    private static final long serialVersionUID = -4561284338216569043L;
    static final String ERROR_MESSAGE_UNKNOWN_FILE_EDIT_TYPE = "Detected unknown file edit type '%s'";
    static final String ERROR_MESSAGE_UNKNOWN_CHANGE_TYPE = "Detected unknown change type '%s'";
    private final String currentCommitId;
    private final String referenceCommitId;

    public DeltaRepositoryCallback(String currentCommitId, String referenceCommitId) {
        this.currentCommitId = currentCommitId;
        this.referenceCommitId = referenceCommitId;
    }

    public RemoteResultWrapper<Delta> invoke(Repository repository, VirtualChannel channel) throws IOException {
        return this.calculateDelta(repository);
    }

    private RemoteResultWrapper<Delta> calculateDelta(Repository repository) throws IOException {
        try (RevWalk walk = new RevWalk(repository);){
            RemoteResultWrapper<Delta> remoteResultWrapper;
            RevCommit currentCommit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)this.currentCommitId));
            RevCommit referenceCommit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)this.referenceCommitId));
            ByteArrayOutputStream diffStream = new ByteArrayOutputStream();
            FilteredLog log = new FilteredLog("Errors from Git Delta:");
            log.logInfo("-> Start scanning for differences between commits...");
            try (DiffFormatter diffFormatter = new DiffFormatter((OutputStream)diffStream);){
                diffFormatter.setDiffComparator(RawTextComparator.WS_IGNORE_ALL);
                diffFormatter.setRepository(repository);
                diffFormatter.setDetectRenames(true);
                List diffEntries = diffFormatter.scan((AnyObjectId)referenceCommit, (AnyObjectId)currentCommit);
                HashMap<String, FileChanges> fileChangesMap = new HashMap<String, FileChanges>();
                log.logInfo("-> %d files contain changes", new Object[]{diffEntries.size()});
                for (DiffEntry diffEntry : diffEntries) {
                    FileEditType fileEditType = this.getFileEditType(diffEntry.getChangeType());
                    FileChanges fileChanges = this.createFileChanges(fileEditType, diffEntry, diffFormatter, repository);
                    String fileId = this.getFileId(diffEntry, fileEditType);
                    fileChangesMap.put(fileId, fileChanges);
                }
                log.logInfo("-> Creating the Git diff file");
                String diffFile = diffStream.toString(StandardCharsets.UTF_8);
                GitDelta delta = new GitDelta(this.currentCommitId, this.referenceCommitId, fileChangesMap, diffFile);
                RemoteResultWrapper<Delta> wrapper = new RemoteResultWrapper<Delta>(delta, "Errors from Git Delta:");
                log.logInfo("-> Git code delta successfully calculated");
                wrapper.merge(log);
                remoteResultWrapper = wrapper;
            }
            return remoteResultWrapper;
        }
    }

    private String getFileId(DiffEntry diffEntry, FileEditType fileEditType) {
        if (FileEditType.DELETE.equals((Object)fileEditType)) {
            return diffEntry.getOldId().name();
        }
        return diffEntry.getNewId().name();
    }

    private FileChanges createFileChanges(FileEditType fileEditType, DiffEntry diffEntry, DiffFormatter diffFormatter, Repository repository) throws IOException {
        String filePath;
        String oldFilePath;
        String fileContent;
        if (fileEditType.equals((Object)FileEditType.DELETE)) {
            fileContent = this.getFileContent(diffEntry.getOldId().toObjectId(), repository);
            oldFilePath = diffEntry.getOldPath();
            filePath = "";
        } else {
            oldFilePath = fileEditType.equals((Object)FileEditType.ADD) ? "" : diffEntry.getOldPath();
            fileContent = this.getFileContent(diffEntry.getNewId().toObjectId(), repository);
            filePath = diffEntry.getNewPath();
        }
        diffFormatter.format(diffEntry);
        FileChanges fileChanges = new FileChanges(filePath, oldFilePath, fileContent, fileEditType, new HashMap());
        for (Edit edit : diffFormatter.toFileHeader(diffEntry).toEditList()) {
            this.createChange(edit).ifPresent(arg_0 -> ((FileChanges)fileChanges).addChange(arg_0));
        }
        return fileChanges;
    }

    private String getFileContent(ObjectId fileId, Repository repository) throws IOException {
        try (ObjectDatabase objectDatabase = repository.getObjectDatabase();){
            ObjectLoader objectLoader = objectDatabase.open((AnyObjectId)fileId);
            String string = new String(objectLoader.getCachedBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    private FileEditType getFileEditType(DiffEntry.ChangeType type) {
        switch (type) {
            case ADD: {
                return FileEditType.ADD;
            }
            case DELETE: {
                return FileEditType.DELETE;
            }
            case MODIFY: {
                return FileEditType.MODIFY;
            }
            case RENAME: {
                return FileEditType.RENAME;
            }
            case COPY: {
                return FileEditType.COPY;
            }
        }
        throw new IllegalArgumentException(String.format(ERROR_MESSAGE_UNKNOWN_FILE_EDIT_TYPE, type));
    }

    private ChangeEditType getChangeEditType(Edit.Type type) {
        switch (type) {
            case INSERT: {
                return ChangeEditType.INSERT;
            }
            case DELETE: {
                return ChangeEditType.DELETE;
            }
            case REPLACE: {
                return ChangeEditType.REPLACE;
            }
            case EMPTY: {
                return ChangeEditType.EMPTY;
            }
        }
        throw new IllegalArgumentException(String.format(ERROR_MESSAGE_UNKNOWN_CHANGE_TYPE, type));
    }

    private Optional<Change> createChange(Edit edit) {
        ChangeEditType changeEditType = this.getChangeEditType(edit.getType());
        if (changeEditType.equals((Object)ChangeEditType.DELETE)) {
            return Optional.of(new Change(changeEditType, edit.getBeginA() + 1, edit.getEndA(), edit.getBeginB(), edit.getEndB()));
        }
        if (changeEditType.equals((Object)ChangeEditType.INSERT)) {
            return Optional.of(new Change(changeEditType, edit.getBeginA(), edit.getEndA(), edit.getBeginB() + 1, edit.getEndB()));
        }
        if (changeEditType.equals((Object)ChangeEditType.REPLACE)) {
            return Optional.of(new Change(changeEditType, edit.getBeginA() + 1, edit.getEndA(), edit.getBeginB() + 1, edit.getEndB()));
        }
        return Optional.empty();
    }
}

