/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.reference;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import io.jenkins.plugins.forensics.git.reference.GitCommitsRecord;
import io.jenkins.plugins.forensics.git.reference.GitReferenceJobModelValidation;
import io.jenkins.plugins.forensics.git.reference.Messages;
import io.jenkins.plugins.forensics.reference.ReferenceRecorder;
import io.jenkins.plugins.forensics.reference.SimpleReferenceRecorder;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Optional;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class GitReferenceRecorder
extends ReferenceRecorder {
    private int maxCommits = 100;
    private boolean skipUnknownCommits = false;

    @DataBoundConstructor
    public GitReferenceRecorder() {
        this(new JenkinsFacade());
    }

    @VisibleForTesting
    GitReferenceRecorder(JenkinsFacade jenkins) {
        super(jenkins);
    }

    @DataBoundSetter
    public void setMaxCommits(int maxCommits) {
        this.maxCommits = maxCommits;
    }

    public int getMaxCommits() {
        return this.maxCommits;
    }

    @DataBoundSetter
    public void setSkipUnknownCommits(boolean skipUnknownCommits) {
        this.skipUnknownCommits = skipUnknownCommits;
    }

    public boolean isSkipUnknownCommits() {
        return this.skipUnknownCommits;
    }

    protected Optional<Run<?, ?>> find(Run<?, ?> owner, Run<?, ?> lastCompletedBuildOfReferenceJob, FilteredLog log) {
        Optional<GitCommitsRecord> referenceCommit = GitCommitsRecord.findRecordForScm(lastCompletedBuildOfReferenceJob, this.getScm());
        if (referenceCommit.isPresent()) {
            GitCommitsRecord commitsRecord;
            Optional<Run<?, ?>> referencePoint;
            Optional<GitCommitsRecord> thisCommit = GitCommitsRecord.findRecordForScm(owner, this.getScm());
            if (thisCommit.isPresent() && (referencePoint = (commitsRecord = thisCommit.get()).getReferencePoint(referenceCommit.get(), this.getMaxCommits(), this.isSkipUnknownCommits(), log)).isPresent()) {
                log.logInfo("-> found build '%s' in reference job with matching commits", new Object[]{referencePoint.get().getDisplayName()});
                return referencePoint;
            }
        } else {
            log.logInfo("-> selected build '%s' of reference job does not yet contain a `GitCommitsRecord`", new Object[]{lastCompletedBuildOfReferenceJob.getDisplayName()});
        }
        Optional targetBranchHead = this.findTargetBranchHead(owner.getParent());
        if (targetBranchHead.isPresent()) {
            log.logInfo("-> falling back to latest build '%s' since a pull or merge request has been detected", new Object[]{lastCompletedBuildOfReferenceJob.getDisplayName()});
            return Optional.of(lastCompletedBuildOfReferenceJob);
        }
        log.logInfo("-> no reference build found", new Object[0]);
        return Optional.empty();
    }

    @SuppressFBWarnings(value={"BC"})
    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"discoverGitReferenceBuild"})
    public static class Descriptor
    extends SimpleReferenceRecorder.SimpleReferenceRecorderDescriptor {
        private final JenkinsFacade jenkins;
        private final GitReferenceJobModelValidation model;

        public Descriptor() {
            this(new JenkinsFacade(), new GitReferenceJobModelValidation());
        }

        @VisibleForTesting
        Descriptor(JenkinsFacade jenkins, GitReferenceJobModelValidation model) {
            this.jenkins = jenkins;
            this.model = model;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Recorder_DisplayName();
        }

        @POST
        public ComboBoxModel doFillReferenceJobItems(@AncestorInPath AbstractProject<?, ?> project) {
            if (this.jenkins.hasPermission(Item.CONFIGURE, project)) {
                return this.model.getAllJobs();
            }
            return new ComboBoxModel();
        }

        @POST
        public FormValidation doCheckReferenceJob(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String referenceJob) {
            if (!this.jenkins.hasPermission(Item.CONFIGURE, project)) {
                return FormValidation.ok();
            }
            return this.model.validateJob(referenceJob);
        }
    }
}

