/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.reference;

import io.jenkins.plugins.forensics.git.reference.GitCommitsRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

class BuildCommits
implements Serializable {
    private static final long serialVersionUID = -580006422072874429L;
    private final String previousBuildCommit;
    private final List<String> commits = new ArrayList<String>();
    private ObjectId head = ObjectId.zeroId();
    private ObjectId target = ObjectId.zeroId();
    private ObjectId merge = ObjectId.zeroId();

    BuildCommits(String previousBuildCommit) {
        this.previousBuildCommit = previousBuildCommit;
    }

    void setHead(RevCommit head) {
        this.head = head;
    }

    ObjectId getHead() {
        return this.head;
    }

    void setTarget(RevCommit target) {
        this.target = target;
    }

    ObjectId getTarget() {
        return this.target;
    }

    public ObjectId getMerge() {
        return this.merge;
    }

    public void setMerge(ObjectId merge) {
        this.merge = merge;
    }

    public boolean hasMerge() {
        return !this.merge.equals((AnyObjectId)ObjectId.zeroId());
    }

    List<String> getCommits() {
        return this.commits;
    }

    int size() {
        return this.commits.size();
    }

    void add(String commitId) {
        this.commits.add(commitId);
    }

    boolean isEmpty() {
        return this.commits.isEmpty();
    }

    GitCommitsRecord.RecordingType getRecordingType() {
        if (StringUtils.isBlank((CharSequence)this.previousBuildCommit)) {
            return GitCommitsRecord.RecordingType.START;
        }
        return GitCommitsRecord.RecordingType.INCREMENTAL;
    }

    String getLatestCommit() {
        if (this.commits.isEmpty()) {
            return this.previousBuildCommit;
        }
        return this.commits.get(0);
    }

    String getMergeOrLatestCommit() {
        if (this.getMerge().equals((AnyObjectId)ObjectId.zeroId())) {
            return this.getLatestCommit();
        }
        return this.getMerge().name();
    }
}

