/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.miner;

import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.forensics.git.miner.RepositoryStatisticsCallback;
import io.jenkins.plugins.forensics.git.util.RemoteResultWrapper;
import io.jenkins.plugins.forensics.miner.CommitDiffItem;
import io.jenkins.plugins.forensics.miner.CommitStatistics;
import io.jenkins.plugins.forensics.miner.RepositoryMiner;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

@SuppressFBWarnings(value={"SE"}, justification="GitClient implementation is Serializable")
public class GitRepositoryMiner
extends RepositoryMiner {
    private static final long serialVersionUID = 1157958118716013983L;
    private final GitClient gitClient;

    GitRepositoryMiner(GitClient gitClient) {
        this.gitClient = gitClient;
    }

    public RepositoryStatistics mine(RepositoryStatistics previous, FilteredLog logger) throws InterruptedException {
        try {
            long nano = System.nanoTime();
            logger.logInfo("Analyzing the commit log of the Git repository '%s'", new Object[]{this.gitClient.getWorkTree()});
            RemoteResultWrapper wrapped = (RemoteResultWrapper)((Object)this.gitClient.withRepository((RepositoryCallback)new RepositoryStatisticsCallback(previous.getLatestCommitId())));
            logger.merge((FilteredLog)wrapped);
            List commits = (List)wrapped.getResult();
            logger.logInfo("-> Created report in %d seconds", new Object[]{1L + (System.nanoTime() - nano) / 1000000000L});
            CommitStatistics.logCommits((List)commits, (FilteredLog)logger);
            String latestCommitId = commits.isEmpty() ? previous.getLatestCommitId() : ((CommitDiffItem)commits.get(0)).getId();
            RepositoryStatistics current = new RepositoryStatistics(latestCommitId);
            current.addAll(previous);
            Collections.reverse(commits);
            current.addAll(commits);
            return current;
        }
        catch (IOException exception) {
            logger.logException((Exception)exception, "Exception occurred while mining the Git repository using GitClient", new Object[0]);
            return new RepositoryStatistics();
        }
    }
}

