/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.miner;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.TreeStringBuilder;
import io.jenkins.plugins.forensics.git.miner.CommitAnalyzer;
import io.jenkins.plugins.forensics.miner.CommitDiffItem;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.util.io.DisabledOutputStream;

public class DiffsCollector {
    List<CommitDiffItem> getDiffsForCommit(Repository repository, Git git, CommitDiffItem fromCommit, AbstractTreeIterator toTree, TreeStringBuilder fileNameBuilder, FilteredLog logger) {
        ArrayList<CommitDiffItem> commits = new ArrayList<CommitDiffItem>();
        try (DiffFormatter formatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);){
            formatter.setRepository(repository);
            List diffEntries = git.diff().setNewTree(CommitAnalyzer.createTreeIteratorFor(fromCommit.getId(), repository, logger)).setOldTree(toTree).call();
            RenameDetector renames = new RenameDetector(repository);
            renames.addAll((Collection)diffEntries);
            for (DiffEntry entry : renames.compute()) {
                CommitDiffItem commit = new CommitDiffItem(fromCommit);
                commit.setNewPath(fileNameBuilder.intern(entry.getNewPath()));
                if (this.isDeleteOrRename(entry)) {
                    commit.setOldPath(fileNameBuilder.intern(entry.getOldPath()));
                }
                for (Edit edit : formatter.toFileHeader(entry).toEditList()) {
                    commit.addLines(edit.getLengthB());
                    commit.deleteLines(edit.getLengthA());
                }
                commits.add(commit);
            }
        }
        catch (IOException | GitAPIException exception) {
            logger.logException((Exception)exception, "Can't compute diffs for commit " + fromCommit, new Object[0]);
        }
        return commits;
    }

    private boolean isDeleteOrRename(DiffEntry entry) {
        return entry.getChangeType() == DiffEntry.ChangeType.RENAME || entry.getChangeType() == DiffEntry.ChangeType.DELETE;
    }
}

