/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.delta;

import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import io.jenkins.plugins.forensics.delta.DeltaCalculator;
import io.jenkins.plugins.forensics.delta.model.Delta;
import io.jenkins.plugins.forensics.git.delta.DeltaRepositoryCallback;
import io.jenkins.plugins.forensics.git.reference.GitCommitsRecord;
import io.jenkins.plugins.forensics.git.util.RemoteResultWrapper;
import java.io.IOException;
import java.util.Optional;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

@SuppressFBWarnings(value={"SE"}, justification="GitClient implementation is Serializable")
public class GitDeltaCalculator
extends DeltaCalculator {
    static final String DELTA_ERROR = "Computing delta information failed with an exception:";
    static final String EMPTY_COMMIT_ERROR = "Calculating the Git code delta is not possible due to an unknown commit ID";
    private static final long serialVersionUID = -7303579046266608368L;
    private final GitClient git;

    public GitDeltaCalculator(GitClient git) {
        this.git = git;
    }

    public Optional<Delta> calculateDelta(Run<?, ?> build, Run<?, ?> referenceBuild, String scmKeyFilter, FilteredLog log) {
        Optional<GitCommitsRecord> buildCommits = GitCommitsRecord.findRecordForScm(build, scmKeyFilter);
        Optional<GitCommitsRecord> referenceCommits = GitCommitsRecord.findRecordForScm(referenceBuild, scmKeyFilter);
        if (buildCommits.isPresent() && referenceCommits.isPresent()) {
            String currentCommit = this.getLatestCommit(build.getFullDisplayName(), buildCommits.get(), log);
            String referenceCommit = this.getLatestCommit(referenceBuild.getFullDisplayName(), referenceCommits.get(), log);
            if (!currentCommit.isEmpty() && !referenceCommit.isEmpty()) {
                log.logInfo("-> Invoking Git delta calculator for determining the made changes between the commits with the IDs '%s' and '%s'", new Object[]{currentCommit, referenceCommit});
                try {
                    RemoteResultWrapper wrapped = (RemoteResultWrapper)((Object)this.git.withRepository((RepositoryCallback)new DeltaRepositoryCallback(currentCommit, referenceCommit)));
                    wrapped.getInfoMessages().forEach(x$0 -> log.logInfo(x$0, new Object[0]));
                    return Optional.of((Delta)wrapped.getResult());
                }
                catch (IOException | InterruptedException exception) {
                    log.logException(exception, DELTA_ERROR, new Object[0]);
                    return Optional.empty();
                }
            }
        }
        log.logError(EMPTY_COMMIT_ERROR, new Object[0]);
        return Optional.empty();
    }

    private String getLatestCommit(String buildName, GitCommitsRecord record, FilteredLog log) {
        String latestCommitId = record.getLatestCommit();
        log.logInfo("-> Using commit '%s' as latest commit for build '%s'", new Object[]{latestCommitId, buildName});
        return latestCommitId;
    }
}

