/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.blame;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.git.GitException;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.forensics.blame.Blamer;
import io.jenkins.plugins.forensics.blame.Blames;
import io.jenkins.plugins.forensics.blame.FileBlame;
import io.jenkins.plugins.forensics.blame.FileLocations;
import io.jenkins.plugins.forensics.git.util.AbstractRepositoryCallback;
import io.jenkins.plugins.forensics.git.util.RemoteResultWrapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

@SuppressFBWarnings(value={"SE"}, justification="GitClient implementation is Serializable")
class GitBlamer
extends Blamer {
    private static final long serialVersionUID = -619059996626444900L;
    static final String NO_HEAD_ERROR = "Could not retrieve HEAD commit, aborting";
    static final String BLAME_ERROR = "Computing blame information failed with an exception:";
    private final GitClient git;
    private final String gitCommit;

    GitBlamer(GitClient git, String gitCommit) {
        this.git = git;
        this.gitCommit = gitCommit;
    }

    public Blames blame(FileLocations locations, FilteredLog log) {
        Blames blames = new Blames();
        try {
            log.logInfo("Invoking Git blamer to create author and commit information for %d affected files", new Object[]{locations.size()});
            log.logInfo("-> GIT_COMMIT env = '%s'", new Object[]{this.gitCommit});
            ObjectId headCommit = this.git.revParse(this.gitCommit);
            if (headCommit == null) {
                log.logError(NO_HEAD_ERROR, new Object[0]);
                return blames;
            }
            long nano = System.nanoTime();
            RemoteResultWrapper wrapped = (RemoteResultWrapper)((Object)this.git.withRepository((RepositoryCallback)new BlameCallback(locations, blames, headCommit)));
            wrapped.getInfoMessages().forEach(x$0 -> log.logInfo(x$0, new Object[0]));
            log.logInfo("Blaming of authors took %d seconds", new Object[]{1L + (System.nanoTime() - nano) / 1000000000L});
            return (Blames)wrapped.getResult();
        }
        catch (IOException exception) {
            log.logException((Exception)exception, BLAME_ERROR, new Object[0]);
        }
        catch (GitException exception) {
            log.logException((Exception)((Object)exception), NO_HEAD_ERROR, new Object[0]);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return blames;
    }

    static class BlameCallback
    extends AbstractRepositoryCallback<RemoteResultWrapper<Blames>> {
        private static final long serialVersionUID = 8794666938104738260L;
        private static final int WHOLE_FILE = 0;
        private final ObjectId headCommit;
        private final FileLocations locations;
        private final Blames blames;

        BlameCallback(FileLocations locations, Blames blames, ObjectId headCommit) {
            this.locations = locations;
            this.blames = blames;
            this.headCommit = headCommit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteResultWrapper<Blames> invoke(Repository repository, VirtualChannel channel) throws InterruptedException {
            try {
                RemoteResultWrapper<Blames> log = new RemoteResultWrapper<Blames>(this.blames, "Errors while running Git blame:");
                log.logInfo("-> Git commit ID = '%s'", new Object[]{this.headCommit.getName()});
                log.logInfo("-> Git working tree = '%s'", new Object[]{BlameCallback.getWorkTree(repository)});
                BlameRunner blameRunner = new BlameRunner(repository, this.headCommit);
                LastCommitRunner lastCommitRunner = new LastCommitRunner(repository);
                FileBlame.FileBlameBuilder builder = new FileBlame.FileBlameBuilder();
                for (String file : this.locations.getFiles()) {
                    this.run(builder, file, blameRunner, lastCommitRunner, log);
                    if (!Thread.interrupted()) continue;
                    String message = "Blaming has been interrupted while computing blame information";
                    log.logInfo(message, new Object[0]);
                    throw new InterruptedException(message);
                }
                log.logInfo("-> blamed authors of issues in %d files", new Object[]{this.blames.size()});
                Object object = log;
                return object;
            }
            finally {
                repository.close();
            }
        }

        @VisibleForTesting
        void run(FileBlame.FileBlameBuilder builder, String relativePath, BlameRunner blameRunner, LastCommitRunner lastCommitRunner, FilteredLog log) {
            try {
                BlameResult blame = blameRunner.run(relativePath);
                if (blame == null) {
                    log.logError("- no blame results for file '%s'", new Object[]{relativePath});
                } else {
                    Iterator iterator = this.locations.getLines(relativePath).iterator();
                    while (iterator.hasNext()) {
                        int line = (Integer)iterator.next();
                        FileBlame fileBlame = builder.build(relativePath);
                        if (line <= 0) {
                            this.fillWithLastCommit(relativePath, fileBlame, lastCommitRunner);
                        } else if (line <= blame.getResultContents().size()) {
                            this.fillWithBlameResult(relativePath, fileBlame, blame, line, log);
                        }
                        this.blames.add(fileBlame);
                    }
                }
            }
            catch (GitAPIException | JGitInternalException exception) {
                log.logException((Exception)exception, "- error running git blame on '%s' with revision '%s'", new Object[]{relativePath, this.headCommit});
            }
            log.logSummary();
        }

        private void fillWithBlameResult(String fileName, FileBlame fileBlame, BlameResult blame, int line, FilteredLog log) {
            int lineIndex = line - 1;
            PersonIdent who = blame.getSourceAuthor(lineIndex);
            if (who == null) {
                who = blame.getSourceCommitter(lineIndex);
            }
            if (who == null) {
                log.logError("- no author or committer information found for line %d in file %s", new Object[]{lineIndex, fileName});
            } else {
                fileBlame.setName(line, who.getName());
                fileBlame.setEmail(line, who.getEmailAddress());
            }
            RevCommit commit = blame.getSourceCommit(lineIndex);
            if (commit == null) {
                log.logError("- no commit ID and time found for line %d in file %s", new Object[]{lineIndex, fileName});
            } else {
                fileBlame.setCommit(line, commit.getName());
                fileBlame.setTime(line, commit.getCommitTime());
            }
        }

        private void fillWithLastCommit(String relativePath, FileBlame fileBlame, LastCommitRunner lastCommitRunner) throws GitAPIException {
            Optional<RevCommit> commit = lastCommitRunner.run(relativePath);
            if (commit.isPresent()) {
                RevCommit revCommit = commit.get();
                fileBlame.setCommit(0, revCommit.getName());
                PersonIdent who = revCommit.getAuthorIdent();
                if (who == null) {
                    who = revCommit.getCommitterIdent();
                }
                if (who != null) {
                    fileBlame.setName(0, who.getName());
                    fileBlame.setEmail(0, who.getEmailAddress());
                }
            }
        }
    }

    static class LastCommitRunner {
        private final Repository repo;

        LastCommitRunner(Repository repo) {
            this.repo = repo;
        }

        Optional<RevCommit> run(String fileName) throws GitAPIException {
            try (Git git = new Git(this.repo);){
                Iterable commits = git.log().addPath(fileName).call();
                Optional<RevCommit> optional = StreamSupport.stream(commits.spliterator(), false).findFirst();
                return optional;
            }
        }
    }

    static class BlameRunner {
        private final Repository repo;
        private final ObjectId headCommit;

        BlameRunner(Repository repo, ObjectId headCommit) {
            this.repo = repo;
            this.headCommit = headCommit;
        }

        @CheckForNull
        BlameResult run(String fileName) throws GitAPIException {
            BlameCommand blame = new BlameCommand(this.repo);
            blame.setFilePath(fileName);
            blame.setStartCommit((AnyObjectId)this.headCommit);
            return blame.call();
        }
    }
}

