/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.reference;

import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import io.jenkins.plugins.forensics.reference.Messages;
import io.jenkins.plugins.forensics.reference.ReferenceBuild;
import io.jenkins.plugins.forensics.reference.ReferenceJobModelValidation;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.LogHandler;
import java.util.List;
import java.util.Optional;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SimpleReferenceRecorder
extends Recorder
implements SimpleBuildStep {
    public static final String NO_REFERENCE_JOB = "-";
    private final JenkinsFacade jenkins;
    private String referenceJob = "";

    @DataBoundConstructor
    public SimpleReferenceRecorder() {
        this(new JenkinsFacade());
    }

    protected SimpleReferenceRecorder(JenkinsFacade jenkins) {
        this.jenkins = jenkins;
    }

    @DataBoundSetter
    public void setReferenceJob(String referenceJob) {
        if (NO_REFERENCE_JOB.equals(referenceJob)) {
            this.referenceJob = "";
        }
        this.referenceJob = StringUtils.strip((String)referenceJob);
    }

    public String getReferenceJob() {
        if (StringUtils.isBlank((CharSequence)this.referenceJob)) {
            return NO_REFERENCE_JOB;
        }
        return this.referenceJob;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public SimpleReferenceRecorderDescriptor getDescriptor() {
        return (SimpleReferenceRecorderDescriptor)super.getDescriptor();
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) {
        FilteredLog log = new FilteredLog("Errors while computing the reference build:");
        run.addAction((Action)this.findReferenceBuild(run, log));
        LogHandler logHandler = new LogHandler(listener, "ReferenceFinder");
        logHandler.log(log);
    }

    protected ReferenceBuild findReferenceBuild(Run<?, ?> run, FilteredLog log) {
        Optional<Job<?, ?>> actualReferenceJob = this.resolveReferenceJob(log);
        if (actualReferenceJob.isPresent()) {
            Job<?, ?> reference = actualReferenceJob.get();
            Run lastCompletedBuild = reference.getLastCompletedBuild();
            if (lastCompletedBuild == null) {
                log.logInfo("No completed build found");
            } else {
                log.logInfo("Found reference build '%s' for target branch", new Object[]{lastCompletedBuild.getDisplayName()});
                return new ReferenceBuild(run, (List<String>)log.getInfoMessages(), lastCompletedBuild);
            }
        }
        log.logError("You need to define a valid reference job using the 'referenceJob' property", new Object[0]);
        return this.createEmptyReferenceBuild(run, log.getInfoMessages());
    }

    protected ReferenceBuild createEmptyReferenceBuild(Run<?, ?> run, List<String> messages) {
        return new ReferenceBuild(run, messages);
    }

    protected Optional<Job<?, ?>> resolveReferenceJob(FilteredLog log) {
        String jobName = this.getReferenceJob();
        if (this.isValidJobName(jobName)) {
            log.logInfo("Configured reference job: '%s'", new Object[]{jobName});
            return this.findJob(jobName, log);
        }
        return Optional.empty();
    }

    protected Optional<Job<?, ?>> findJob(String jobName, FilteredLog log) {
        Optional job = this.jenkins.getJob(jobName);
        if (!job.isPresent()) {
            log.logInfo("There is no such job - maybe the job has been renamed or deleted?");
        }
        return job;
    }

    private boolean isValidJobName(String name) {
        return StringUtils.isNotBlank((CharSequence)name) && !NO_REFERENCE_JOB.equals(name);
    }

    @Extension
    @Symbol(value={"discoverReferenceBuild"})
    public static class SimpleReferenceRecorderDescriptor
    extends BuildStepDescriptor<Publisher> {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();
        private final ReferenceJobModelValidation model = new ReferenceJobModelValidation();

        @NonNull
        public String getDisplayName() {
            return Messages.Recorder_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @POST
        public ComboBoxModel doFillReferenceJobItems(@AncestorInPath AbstractProject<?, ?> project) {
            if (JENKINS.hasPermission(Item.CONFIGURE, project)) {
                return this.model.getAllJobs();
            }
            return new ComboBoxModel();
        }

        @POST
        public FormValidation doCheckReferenceJob(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String referenceJob) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, project)) {
                return FormValidation.ok();
            }
            return this.model.validateJob(referenceJob);
        }
    }
}

