/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.util.FilteredLog;
import hudson.model.Run;
import io.jenkins.plugins.forensics.miner.ForensicsBuildAction;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import io.jenkins.plugins.util.BuildAction;
import java.util.List;
import java.util.Set;

public class MinerService {
    static final String NO_MINER_ERROR = "Repository miner is not configured, skipping repository mining";

    public RepositoryStatistics queryStatisticsFor(String scm, Run<?, ?> build, Set<String> files, FilteredLog logger) {
        RepositoryStatistics selected = new RepositoryStatistics();
        List actions = build.getActions(ForensicsBuildAction.class);
        if (actions.isEmpty()) {
            logger.logInfo(NO_MINER_ERROR);
            return selected;
        }
        RepositoryStatistics everything = actions.stream().filter(a -> a.getScmKey().contains(scm)).findAny().map(BuildAction::getResult).orElse(new RepositoryStatistics());
        logger.logInfo("Extracting repository forensics for %d affected files (files in repository: %d)", new Object[]{files.size(), everything.size()});
        for (String file : files) {
            if (everything.contains(file)) {
                selected.add(everything.get(file));
                continue;
            }
            logger.logError("No statistics found for file '%s'", new Object[]{file});
        }
        logger.logInfo("-> %d affected files processed", new Object[]{selected.size()});
        return selected;
    }
}

