/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import edu.hm.hafner.echarts.Palette;
import io.jenkins.plugins.forensics.miner.FilesCountSeriesBuilder;
import io.jenkins.plugins.forensics.miner.ForensicsBuildAction;
import io.jenkins.plugins.forensics.miner.Messages;

class FilesCountTrendChart {
    FilesCountTrendChart() {
    }

    public LinesChartModel create(Iterable<? extends BuildResult<ForensicsBuildAction>> results, ChartModelConfiguration configuration) {
        FilesCountSeriesBuilder builder = new FilesCountSeriesBuilder();
        LinesDataSet dataSet = builder.createDataSet(configuration, results);
        LinesChartModel model = new LinesChartModel(dataSet);
        LineSeries series = new LineSeries(Messages.TrendChart_Files_Legend_Label(), Palette.BLUE.getNormal(), LineSeries.StackedMode.SEPARATE_LINES, LineSeries.FilledMode.FILLED);
        if (dataSet.getDomainAxisSize() > 0) {
            series.addAll(dataSet.getSeries("total"));
            model.addSeries(new LineSeries[]{series});
        }
        return model;
    }
}

