/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import edu.hm.hafner.echarts.Palette;
import io.jenkins.plugins.forensics.miner.CodeMetricSeriesBuilder;
import io.jenkins.plugins.forensics.miner.ForensicsBuildAction;

class CodeMetricTrendChart {
    CodeMetricTrendChart() {
    }

    LinesChartModel create(Iterable<? extends BuildResult<ForensicsBuildAction>> results, ChartModelConfiguration configuration) {
        CodeMetricSeriesBuilder builder = new CodeMetricSeriesBuilder();
        LinesDataSet dataSet = builder.createDataSet(configuration, results);
        LinesChartModel model = new LinesChartModel(dataSet);
        Palette[] colors = new Palette[]{Palette.BLUE, Palette.ORANGE};
        int index = 0;
        for (String name : dataSet.getDataSetIds()) {
            int colorIndex = index++ % colors.length;
            LineSeries series = new LineSeries(name, colors[colorIndex].getNormal(), LineSeries.StackedMode.SEPARATE_LINES, LineSeries.FilledMode.LINES);
            series.addAll(dataSet.getSeries(name));
            model.addSeries(new LineSeries[]{series});
        }
        return model;
    }
}

