/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.blame;

import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.TreeString;
import edu.hm.hafner.util.TreeStringBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FileBlame
implements Iterable<Integer>,
Serializable {
    private static final long serialVersionUID = 7L;
    static final String EMPTY = "-";
    static final int EMPTY_INTEGER = 0;
    private final TreeString fileName;
    @CheckForNull
    private Map<Integer, LineBlame> blamesByLine = new HashMap<Integer, LineBlame>();
    @Deprecated
    private final transient Set<Integer> lines = new HashSet<Integer>();
    @Deprecated
    private final transient Map<Integer, String> commitByLine = new HashMap<Integer, String>();
    @Deprecated
    private final transient Map<Integer, String> nameByLine = new HashMap<Integer, String>();
    @Deprecated
    private final transient Map<Integer, String> emailByLine = new HashMap<Integer, String>();
    @Deprecated
    @CheckForNull
    private transient Map<Integer, Integer> timeByLine = new HashMap<Integer, Integer>();

    private FileBlame(TreeString fileName) {
        this.fileName = fileName;
    }

    protected Object readResolve() {
        if (this.timeByLine == null) {
            this.timeByLine = new HashMap<Integer, Integer>();
        }
        if (this.blamesByLine == null) {
            this.blamesByLine = new HashMap<Integer, LineBlame>();
            for (Integer line : this.lines) {
                LineBlame lineBlame = new LineBlame();
                lineBlame.setName(this.nameByLine.get(line));
                lineBlame.setEmail(this.emailByLine.get(line));
                lineBlame.setCommit(this.commitByLine.get(line));
                lineBlame.setAddedAt(this.timeByLine.getOrDefault(line, 0));
                this.blamesByLine.put(line, lineBlame);
            }
        }
        return this;
    }

    public String getFileName() {
        return this.fileName.toString();
    }

    public Set<Integer> getLines() {
        return this.getBlamesByLine().keySet();
    }

    private Map<Integer, LineBlame> getBlamesByLine() {
        return Objects.requireNonNull(this.blamesByLine);
    }

    @Override
    @NonNull
    public Iterator<Integer> iterator() {
        return this.getLines().iterator();
    }

    private LineBlame getBlamesFor(int lineNumber) {
        return this.getBlamesByLine().computeIfAbsent(lineNumber, k -> new LineBlame());
    }

    public void setCommit(int lineNumber, String id) {
        this.getBlamesFor(lineNumber).setCommit(id);
    }

    public String getCommit(int line) {
        return this.getBlamesFor(line).getCommit();
    }

    public void setName(int lineNumber, String name) {
        this.getBlamesFor(lineNumber).setName(name);
    }

    public String getName(int line) {
        return this.getBlamesFor(line).getName();
    }

    public void setEmail(int lineNumber, String emailAddress) {
        this.getBlamesFor(lineNumber).setEmail(emailAddress);
    }

    public String getEmail(int line) {
        return this.getBlamesFor(line).getEmail();
    }

    public void setTime(int lineNumber, int time) {
        this.getBlamesFor(lineNumber).setAddedAt(time);
    }

    public int getTime(int line) {
        return this.getBlamesFor(line).getAddedAt();
    }

    public void merge(FileBlame other) {
        if (other.getFileName().equals(this.getFileName())) {
            for (Integer otherLine : other) {
                if (this.getBlamesByLine().containsKey(otherLine)) continue;
                this.getBlamesByLine().put(otherLine, other.getBlamesFor(otherLine));
            }
        } else {
            throw new IllegalArgumentException(String.format("File names must match! This instance: %s, other instance: %s", this.getFileName(), other.getFileName()));
        }
    }

    public String toString() {
        return this.fileName + " - " + this.lines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBlame integers = (FileBlame)o;
        return this.fileName.equals((Object)integers.fileName) && Objects.equals(this.blamesByLine, integers.blamesByLine);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.blamesByLine);
    }

    private static class LineBlame
    implements Serializable {
        private static final long serialVersionUID = 7L;
        private String name = "-";
        private String email = "-";
        private String commit = "-";
        private int addedAt = 0;

        private LineBlame() {
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name.intern();
        }

        public String getEmail() {
            return this.email;
        }

        void setEmail(String email) {
            this.email = email.intern();
        }

        public String getCommit() {
            return this.commit;
        }

        void setCommit(String commit) {
            this.commit = commit.intern();
        }

        public int getAddedAt() {
            return this.addedAt;
        }

        void setAddedAt(int addedAt) {
            this.addedAt = addedAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineBlame lineBlame = (LineBlame)o;
            return this.addedAt == lineBlame.addedAt && this.name.equals(lineBlame.name) && this.email.equals(lineBlame.email) && this.commit.equals(lineBlame.commit);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.email, this.commit, this.addedAt);
        }
    }

    public static class FileBlameBuilder {
        private final TreeStringBuilder builder = new TreeStringBuilder();
        private final PathUtil pathUtil = new PathUtil();

        public FileBlame build(String fileName) {
            return new FileBlame(this.builder.intern(this.pathUtil.getAbsolutePath(fileName)));
        }
    }
}

