/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.file_parameters;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildWrapperDescriptor;
import io.jenkins.plugins.file_parameters.AbstractFileParameterValue;
import java.io.IOException;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class FileParameterWrapper
extends SimpleBuildWrapper {
    public final String name;
    private boolean allowNoFile;

    @DataBoundConstructor
    public FileParameterWrapper(String name) {
        this.name = name;
    }

    public boolean isAllowNoFile() {
        return this.allowNoFile;
    }

    @DataBoundSetter
    public void setAllowNoFile(boolean allowNoFile) {
        this.allowNoFile = allowNoFile;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        ParametersAction pa = (ParametersAction)build.getAction(ParametersAction.class);
        if (pa == null) {
            throw new AbortException("No parameters");
        }
        ParameterValue pv = pa.getParameter(this.name);
        if (pv == null && !this.allowNoFile) {
            throw new AbortException("No parameter named " + this.name);
        }
        if (!(pv instanceof AbstractFileParameterValue) && !this.allowNoFile) {
            throw new AbortException("Unsupported parameter type");
        }
        if (pv == null && this.allowNoFile) {
            listener.getLogger().println("Skip file parameter as there is no parameter with name: '" + this.name + "'");
            return;
        }
        FilePath tempDir = WorkspaceList.tempDir((FilePath)workspace);
        if (tempDir == null) {
            throw new AbortException("Missing workspace or could not make temp dir");
        }
        tempDir.mkdirs();
        FilePath f = ((AbstractFileParameterValue)pv).createTempFile(build, tempDir, initialEnvironment, launcher, listener);
        context.env(this.name, f.getRemote());
        context.setDisposer((SimpleBuildWrapper.Disposer)new Delete(f.getRemote()));
    }

    @Symbol(value={"withFileParameter"})
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Bind file parameter";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }

    private static class Delete
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 1L;
        private final String file;

        Delete(String file) {
            this.file = file;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            workspace.child(this.file).delete();
        }
    }
}

