/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.file_parameters;

import hudson.Extension;
import io.jenkins.plugins.file_parameters.AbstractFileParameterDefinition;
import io.jenkins.plugins.file_parameters.AbstractFileParameterValue;
import io.jenkins.plugins.file_parameters.Base64FileParameterValue;
import java.io.IOException;
import java.io.InputStream;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public final class Base64FileParameterDefinition
extends AbstractFileParameterDefinition {
    @DataBoundConstructor
    public Base64FileParameterDefinition(String name) {
        super(name);
    }

    @Override
    protected Class<? extends AbstractFileParameterValue> valueType() {
        return Base64FileParameterValue.class;
    }

    @Override
    protected AbstractFileParameterValue createValue(String name, InputStream src) throws IOException {
        return new Base64FileParameterValue(name, src);
    }

    @Symbol(value={"base64File"})
    @Extension
    public static final class DescriptorImpl
    extends AbstractFileParameterDefinition.AbstractFileParameterDefinitionDescriptor {
        public String getDisplayName() {
            return "Base64 File Parameter";
        }
    }
}

