/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.rest.v30.client;

import com.embotics.vlm.rest.v30.client.ClientUtils;
import com.embotics.vlm.rest.v30.client.model.Comment;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import com.embotics.vlm.rest.v30.client.model.WorkflowTargetType;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class WorkflowsClient {
    private static final String WORKFLOW_DEFINITIONS_PATH = "workflow-definitions";
    private static final String TASKS_PATH = "tasks";
    private static final String WORKFLOWS_PATH = "workflows";
    private static final String WORKFLOW_COMMENTS_PATH = "comments";
    private static final String WORKFLOW_DEFINITION_NAME = "name";
    private static final String WORKFLOW_DEFINITION_TYPE = "type";
    private static final String WORKFLOW_DEFINITION_ID = "id";
    private static final String WORKFLOW_DEFINITION_TARGET_TYPE = "target_type";
    private static final String WORKFLOW_DEFINITION_RUN = "run";
    private static final String WORKFLOW_DEFINITION_RUN_ASYNC = "async";
    private static final String WORKFLOW_DEFINITION_TYPE_COMMAND = "COMMAND";
    private static final String WORKFLOW_DEFINITION_RUN_REQUEST_BODY_FORMAT_WITH_TARGET = "{\"target_name\":\"%s\",\"target_type\":\"%s\"}";
    private static final String WORKFLOW_DEFINITION_RUN_REQUEST_BODY_FORMAT = "{\"target_name\":null,\"target_type\":\"%s\"}";
    private static final String TASK_RELATED_OBJECTS = "related_objects";
    private static final String TASK_ID = "id";
    private static final String TASK_STATE = "state";
    private static final String TASK_STATE_COMPLETE = "COMPLETE";
    private static final String TASK_STATE_FAILED = "FAILED";
    private static final String TASK_STATE_CANCELLED = "CANCELLED";
    private static final String TASK_STATE_CANCEL_REQUESTED = "CANCEL_REQUESTED";
    private static final String WORKFLOW_STATUS = "status";
    private static final String WORKFLOW_STATUS_COMPLETED = "COMPLETED";
    private static final String WORKFLOW_STATUS_REJECTED = "REJECTED";
    private static final String WORKFLOW_STATUS_ERROR = "ERROR";
    private static final String MANAGED_OBJECT_TYPE = "type";
    private static final String MANAGED_OBJECT_TYPE_WORKFLOW = "WORKFLOW";
    private static final String MANAGED_OBJECT_ID = "id";
    private final WebResource webResource;

    public WorkflowsClient(WebResource webResource) {
        this.webResource = webResource;
    }

    public Long getWorkflowDefinition(String workflowName) throws JSONException, VCommanderException {
        if (StringUtils.isBlank((String)workflowName)) {
            throw new VCommanderException("No workflowName provided.");
        }
        String typeFilter = ClientUtils.buildFilter("type", ClientUtils.RestFilterOperator.eq, WORKFLOW_DEFINITION_TYPE_COMMAND);
        String nameFilter = ClientUtils.buildFilter(WORKFLOW_DEFINITION_NAME, ClientUtils.RestFilterOperator.eq, ClientUtils.encapsulateInQuots(workflowName));
        String filter = ClientUtils.buildFilter(typeFilter, ClientUtils.RestFilterOperator.and, nameFilter);
        ClientResponse workflowDefinitionsResponse = (ClientResponse)this.webResource.path(WORKFLOW_DEFINITIONS_PATH).queryParam("filter", filter).accept(new String[]{"application/json"}).get(ClientResponse.class);
        ClientUtils.checkResponse(workflowDefinitionsResponse, ClientResponse.Status.OK.getStatusCode());
        String workflowDefinitionsStr = (String)workflowDefinitionsResponse.getEntity(String.class);
        JSONObject workflowDefinitionsJSON = new JSONObject(workflowDefinitionsStr);
        JSONArray workflowDefinitions = workflowDefinitionsJSON.getJSONArray("items");
        if (workflowDefinitions.length() == 0) {
            throw new VCommanderException("Command Workflow Definition not found.");
        }
        JSONObject workflowDefinition = (JSONObject)workflowDefinitions.get(0);
        return workflowDefinition.getLong("id");
    }

    public String getWorkflowDefinitionTargetType(Long workflowDefinitionId) throws JSONException, VCommanderException {
        if (workflowDefinitionId == null) {
            throw new VCommanderException("No workflowDefinitionId provided.");
        }
        ClientResponse workflowDefinitionResponse = (ClientResponse)this.webResource.path(WORKFLOW_DEFINITIONS_PATH).path(workflowDefinitionId.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        ClientUtils.checkResponse(workflowDefinitionResponse, ClientResponse.Status.OK.getStatusCode());
        String workflowDefinitionStr = (String)workflowDefinitionResponse.getEntity(String.class);
        JSONObject workflowDefinitionJSON = new JSONObject(workflowDefinitionStr);
        return workflowDefinitionJSON.getString(WORKFLOW_DEFINITION_TARGET_TYPE);
    }

    public String runCommandWorkflow(Long workflowId, String targetType, String targetName) throws JSONException, VCommanderException {
        if (StringUtils.isBlank((String)targetType)) {
            throw new VCommanderException("No targetType provided.");
        }
        if (WorkflowTargetType.NO_INVENTORY_TARGET.name().equals(targetType)) {
            if (StringUtils.isNotBlank((String)targetName)) {
                throw new VCommanderException("When targetType is NO_INVENTORY_TARGET, then targetName must be null: " + targetName);
            }
        } else if (StringUtils.isBlank((String)targetName)) {
            throw new VCommanderException("No targetName provided.");
        }
        if (workflowId == null) {
            throw new VCommanderException("No workflowId provided.");
        }
        String requestBody = WorkflowTargetType.NO_INVENTORY_TARGET.name().equals(targetType) ? String.format(WORKFLOW_DEFINITION_RUN_REQUEST_BODY_FORMAT, targetType) : String.format(WORKFLOW_DEFINITION_RUN_REQUEST_BODY_FORMAT_WITH_TARGET, targetName, targetType);
        ClientResponse runCommandResponse = (ClientResponse)this.webResource.path(WORKFLOW_DEFINITIONS_PATH).path(workflowId.toString()).path(WORKFLOW_DEFINITION_RUN).queryParam(WORKFLOW_DEFINITION_RUN_ASYNC, "true").type("application/json").post(ClientResponse.class, (Object)requestBody);
        ClientUtils.checkResponse(runCommandResponse, ClientResponse.Status.ACCEPTED.getStatusCode());
        JSONObject task = new JSONObject((String)runCommandResponse.getEntity(String.class));
        return task.getString("id");
    }

    public Long waitForWorkflowToBeCompleted(String taskId, long timeout, long polling, PrintStream logger) throws JSONException, InterruptedException, VCommanderException {
        if (StringUtils.isBlank((String)taskId)) {
            throw new VCommanderException("No taskId provided.");
        }
        Long workflowId = null;
        String workflowStatus = null;
        long startTime = System.currentTimeMillis();
        HashSet<String> loggedComments = new HashSet<String>();
        do {
            if (workflowId == null) {
                workflowId = this.checkWorkflowTaskIfStartedAndWait(taskId, startTime, timeout, polling, logger);
                continue;
            }
            workflowStatus = this.checkWorkflowIfCompletedAndWait(workflowId, loggedComments, startTime, timeout, polling, logger);
        } while (!WORKFLOW_STATUS_COMPLETED.equals(workflowStatus));
        return workflowId;
    }

    private Long checkWorkflowTaskIfStartedAndWait(String taskId, long startTimeInMillis, long timeoutInMinutes, long pollingInSeconds, PrintStream logger) throws VCommanderException, JSONException, InterruptedException {
        String taskState;
        ClientUtils.log(logger, "\tLooking up task with ID: " + taskId);
        JSONObject task = this.getTask(taskId, logger);
        switch (taskState = this.getTaskState(task)) {
            case "FAILED": {
                throw new VCommanderException("Task failed.");
            }
            case "CANCEL_REQUESTED": 
            case "CANCELLED": {
                throw new VCommanderException("Task cancelled.");
            }
        }
        Long workflowId = this.getWorkflowIdFromTask(task);
        if (workflowId != null) {
            ClientUtils.log(logger, "Task was started and has the related workflow ID: " + workflowId);
        } else {
            if (TASK_STATE_COMPLETE.equals(taskState)) {
                throw new VCommanderException("Task finished but doesn't have the workflow ID.");
            }
            long currentTimeInMillis = System.currentTimeMillis();
            if (startTimeInMillis + timeoutInMinutes * 60000L <= currentTimeInMillis) {
                throw new VCommanderException("Task doesn't have the workflow ID, and timeout reached: " + timeoutInMinutes + " minutes");
            }
            long toWait = Math.min(pollingInSeconds * 1000L, startTimeInMillis + timeoutInMinutes * 60000L - currentTimeInMillis);
            ClientUtils.log(logger, "Task doesn't have the related workflow ID. Wait " + toWait / 1000L + " seconds ...");
            Thread.sleep(toWait);
        }
        return workflowId;
    }

    private String checkWorkflowIfCompletedAndWait(Long workflowId, Set<String> loggedComments, long startTimeInMillis, long timeoutInMinutes, long pollingInSeconds, PrintStream logger) throws VCommanderException, JSONException, InterruptedException {
        ClientUtils.log(logger, "Looking up workflow with ID: " + workflowId);
        JSONObject workflowJSON = this.getWorkflow(workflowId, logger);
        String workflowStatus = this.getWorkflowStatus(workflowJSON);
        if (logger != null) {
            List<Comment> comments = this.getWorkflowComments(workflowId, logger);
            for (Comment comment : comments) {
                String commentStr = comment.toString();
                if (loggedComments.contains(commentStr)) continue;
                logger.println();
                logger.println("Comment: ");
                logger.println(commentStr);
                logger.println();
                loggedComments.add(commentStr);
            }
        }
        switch (workflowStatus) {
            case "COMPLETED": {
                break;
            }
            case "ERROR": {
                throw new VCommanderException("Workflow failed.");
            }
            case "REJECTED": {
                throw new VCommanderException("Workflow rejected.");
            }
            default: {
                long currentTimeInMillis = System.currentTimeMillis();
                if (startTimeInMillis + timeoutInMinutes * 60000L <= currentTimeInMillis) {
                    throw new VCommanderException("Workflow did not completed in the given timeout: " + timeoutInMinutes + " minutes");
                }
                long toWait = Math.min(pollingInSeconds * 1000L, startTimeInMillis + timeoutInMinutes * 60000L - currentTimeInMillis);
                ClientUtils.log(logger, "Workflow status is: " + workflowStatus + ". Wait " + toWait / 1000L + " seconds ...");
                Thread.sleep(toWait);
            }
        }
        return workflowStatus;
    }

    private List<Comment> getWorkflowComments(Long workflowId, PrintStream logger) {
        try {
            ClientResponse commentsResponse = (ClientResponse)this.webResource.path(WORKFLOWS_PATH).path(workflowId.toString()).path(WORKFLOW_COMMENTS_PATH).accept(new String[]{"application/json"}).get(ClientResponse.class);
            return ClientUtils.getComments(commentsResponse);
        }
        catch (Exception e) {
            ClientUtils.log(logger, "\tError while looking up workflow comments for workflow with ID: " + workflowId + " Message: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    private JSONObject getTask(String taskId, PrintStream logger) {
        try {
            ClientResponse requestResponse = (ClientResponse)this.webResource.path(TASKS_PATH).path(taskId).accept(new String[]{"application/json"}).get(ClientResponse.class);
            ClientUtils.checkResponse(requestResponse, ClientResponse.Status.OK.getStatusCode());
            String requestStr = (String)requestResponse.getEntity(String.class);
            return new JSONObject(requestStr);
        }
        catch (Exception e) {
            ClientUtils.log(logger, "\tError while looking up task with ID: " + taskId + " Message: " + e.getMessage());
            return null;
        }
    }

    private String getTaskState(JSONObject task) throws JSONException {
        if (task != null) {
            return task.getString(TASK_STATE);
        }
        return "";
    }

    private Long getWorkflowIdFromTask(JSONObject task) throws JSONException {
        if (task != null && !task.isNull(TASK_RELATED_OBJECTS)) {
            JSONArray relatedObjects = task.getJSONArray(TASK_RELATED_OBJECTS);
            for (int i = 0; i < relatedObjects.length(); ++i) {
                JSONObject relatedObject = (JSONObject)relatedObjects.get(i);
                if (!MANAGED_OBJECT_TYPE_WORKFLOW.equals(relatedObject.getString("type"))) continue;
                return relatedObject.getLong("id");
            }
        }
        return null;
    }

    private String getWorkflowStatus(JSONObject workflow) throws JSONException {
        if (workflow != null) {
            return workflow.getString(WORKFLOW_STATUS);
        }
        return "";
    }

    private JSONObject getWorkflow(Long workflowId, PrintStream logger) {
        try {
            ClientResponse requestResponse = (ClientResponse)this.webResource.path(WORKFLOWS_PATH).path(workflowId.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
            ClientUtils.checkResponse(requestResponse, ClientResponse.Status.OK.getStatusCode());
            String requestStr = (String)requestResponse.getEntity(String.class);
            return new JSONObject(requestStr);
        }
        catch (Exception e) {
            ClientUtils.log(logger, "\tError while looking up workflow with ID: " + workflowId + " Message: " + e.getMessage());
            return null;
        }
    }
}

