/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.rest.v30.client;

import com.embotics.vlm.rest.v30.client.ClientHelper;
import com.embotics.vlm.rest.v30.client.ServiceRequestsClient;
import com.embotics.vlm.rest.v30.client.SessionsClient;
import com.embotics.vlm.rest.v30.client.WorkflowsClient;
import com.embotics.vlm.rest.v30.client.model.DeployedComponentInfo;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;

public class VCommanderClient {
    private static final String BASIC_AUTH_ENCODING = "UTF-8";
    private static final String BASIC_AUTH_HEATHER_KEY = "Authorization";
    private static final String BASIC_AUTH_HEATHER_VALUE_PREFIX = "Basic ";
    private static final String ROOT_SERVICE_PATH = "rest/v3";
    private String baseURL;
    private WebResource webResource;
    private Client client;
    private String userName;
    private String orgName;
    private SessionsClient sessionsClient;
    private ServiceRequestsClient serviceRequestsClient;
    private WorkflowsClient workflowsClient;

    public VCommanderClient(String uri, final String userName, final String password, final String orgName) {
        this.baseURL = uri;
        this.userName = userName;
        this.orgName = orgName;
        String baseURL = uri;
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        this.client = ClientHelper.createClient();
        this.client.addFilter(new ClientFilter(){

            public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
                StringBuilder builder = new StringBuilder();
                builder.append(userName);
                if (StringUtils.isNotBlank((String)orgName)) {
                    builder.append(";");
                    builder.append(orgName);
                }
                builder.append(":");
                builder.append(password);
                String authentication = builder.toString();
                byte[] base64Encoded = Base64.encodeBase64((byte[])authentication.getBytes(Charset.forName(VCommanderClient.BASIC_AUTH_ENCODING)));
                String base64String = new String(base64Encoded, Charset.forName(VCommanderClient.BASIC_AUTH_ENCODING));
                cr.getHeaders().add((Object)VCommanderClient.BASIC_AUTH_HEATHER_KEY, (Object)(VCommanderClient.BASIC_AUTH_HEATHER_VALUE_PREFIX + base64String));
                return this.getNext().handle(cr);
            }
        });
        this.webResource = this.client.resource(baseURL).path(ROOT_SERVICE_PATH);
        this.sessionsClient = new SessionsClient(this.webResource, userName, password, orgName);
        this.serviceRequestsClient = new ServiceRequestsClient(this.webResource);
        this.workflowsClient = new WorkflowsClient(this.webResource);
    }

    protected VCommanderClient() {
    }

    public void close() {
        this.client.destroy();
    }

    public String getClientInfo() {
        String orgInfo = StringUtils.isNotBlank((String)this.orgName) ? String.format(" - in organization: %s", this.orgName) : "";
        return String.format("Configured Commander is at: %s - with userName: %s%s", this.baseURL, this.userName, orgInfo);
    }

    public String getSecurityToken() throws JSONException, VCommanderException {
        return this.sessionsClient.getSecurityToken();
    }

    public Long getPublishedService(String serviceName) throws JSONException, VCommanderException {
        return this.serviceRequestsClient.getPublishedService(serviceName);
    }

    public String getPublishedServiceNameByPayload(String payload) throws JSONException, VCommanderException {
        return this.serviceRequestsClient.getPublishedServiceNameByPayload(payload);
    }

    public String getServiceRequestPayload(Long serviceID) throws JSONException, VCommanderException {
        return this.serviceRequestsClient.getServiceRequestPayload(serviceID);
    }

    public Long requestService(String payload) throws JSONException, VCommanderException {
        return this.serviceRequestsClient.requestService(payload);
    }

    public List<DeployedComponentInfo> waitForServiceRequestToBeCompleted(Long requestId, long timeout, long polling, PrintStream logger) throws JSONException, InterruptedException, VCommanderException {
        return this.serviceRequestsClient.waitForServiceRequestToBeCompleted(requestId, timeout, polling, logger);
    }

    public Long getWorkflowDefinition(String workflowName) throws JSONException, VCommanderException {
        return this.workflowsClient.getWorkflowDefinition(workflowName);
    }

    public String getWorkflowDefinitionTargetType(Long workflowDefinitionId) throws JSONException, VCommanderException {
        return this.workflowsClient.getWorkflowDefinitionTargetType(workflowDefinitionId);
    }

    public String runCommandWorkflow(Long workflowId, String targetType, String targetName) throws JSONException, VCommanderException {
        return this.workflowsClient.runCommandWorkflow(workflowId, targetType, targetName);
    }

    public Long waitForWorkflowToBeCompleted(String taskId, long timeout, long polling, PrintStream logger) throws JSONException, InterruptedException, VCommanderException {
        return this.workflowsClient.waitForWorkflowToBeCompleted(taskId, timeout, polling, logger);
    }
}

