/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.rest.v30.client;

import com.embotics.vlm.rest.v30.client.ClientUtils;
import com.embotics.vlm.rest.v30.client.model.Comment;
import com.embotics.vlm.rest.v30.client.model.DeployedComponentInfo;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ServiceRequestsClient {
    private static final String SERVICES_PATH = "services";
    private static final String SERVICE_REQUESTS_PATH = "service-requests";
    private static final String SERVICE_REQUEST_COMMENTS_PATH = "comments";
    private static final String PUBLISHED_SERVICE_NAME = "name";
    private static final String PUBLISHED_SERVICE_FORM = "request-form";
    private static final String PUBLISHED_SERVICE_ID = "id";
    private static final String PUBLISHED_SERVICE_FORM_SERVICE_ID = "service_id";
    private static final String REQUESTED_SERVICE_SUMMARY = "summary";
    private static final String REQUESTED_SERVICE_ID = "id";
    private static final String REQUESTED_SERVICE_STATE = "state";
    private static final String REQUESTED_SERVICE_SERVICES = "services";
    private static final String REQUESTED_SERVICE_SERVICE_COMPONENTS = "components";
    private static final String REQUESTED_SERVICE_SERVICE_COMPONENT_SUMMARY = "summary";
    private static final String REQUESTED_SERVICE_SERVICE_COMPONENT_DEPLOYED_OBJECT = "deployed_object";
    private static final String REQUESTED_SERVICE_SERVICE_COMPONENT_DEPLOYED_OBJECT_NAME = "name";
    private static final String REQUESTED_SERVICE_SERVICE_COMPONENT_DEPLOYED_OBJECT_TYPE = "type";
    private static final String REQUESTED_SERVICE_STATE_COMPLETED = "COMPLETED";
    private static final String REQUESTED_SERVICE_STATE_REJECTED = "REJECTED";
    private static final String REQUESTED_SERVICE_STATE_FAILED = "FAILED";
    private final WebResource webResource;

    public ServiceRequestsClient(WebResource webResource) {
        this.webResource = webResource;
    }

    public Long getPublishedService(String serviceName) throws JSONException, VCommanderException {
        if (StringUtils.isBlank((String)serviceName)) {
            throw new VCommanderException("No serviceName provided.");
        }
        String filter = ClientUtils.buildFilter("name", ClientUtils.RestFilterOperator.eq, ClientUtils.encapsulateInQuots(serviceName));
        ClientResponse servicesResponse = (ClientResponse)this.webResource.path("services").queryParam("filter", filter).accept(new String[]{"application/json"}).get(ClientResponse.class);
        ClientUtils.checkResponse(servicesResponse, ClientResponse.Status.OK.getStatusCode());
        String servicesStr = (String)servicesResponse.getEntity(String.class);
        JSONObject servicesJSON = new JSONObject(servicesStr);
        JSONArray services = servicesJSON.getJSONArray("items");
        if (services.length() == 0) {
            throw new VCommanderException("Service not found.");
        }
        if (services.length() > 1) {
            throw new VCommanderException("More than 1 Service found with name: " + serviceName);
        }
        JSONObject publishedService = (JSONObject)services.get(0);
        return publishedService.getLong("id");
    }

    public String getPublishedServiceNameByPayload(String payload) throws JSONException, VCommanderException {
        if (StringUtils.isBlank((String)payload)) {
            throw new VCommanderException("No payload provided.");
        }
        JSONObject payloadJSON = new JSONObject(payload);
        if (payloadJSON.isNull(PUBLISHED_SERVICE_FORM_SERVICE_ID)) {
            throw new VCommanderException("Payload is missing the 'service_id' element");
        }
        Long publishedServiceId = payloadJSON.getLong(PUBLISHED_SERVICE_FORM_SERVICE_ID);
        String filter = ClientUtils.buildFilter("id", ClientUtils.RestFilterOperator.eq, publishedServiceId.toString());
        ClientResponse servicesResponse = (ClientResponse)this.webResource.path("services").queryParam("filter", filter).accept(new String[]{"application/json"}).get(ClientResponse.class);
        ClientUtils.checkResponse(servicesResponse, ClientResponse.Status.OK.getStatusCode());
        String servicesStr = (String)servicesResponse.getEntity(String.class);
        JSONObject servicesJSON = new JSONObject(servicesStr);
        JSONArray servicesListJSON = servicesJSON.getJSONArray("items");
        if (servicesListJSON.length() > 0) {
            JSONObject serviceJSON = (JSONObject)servicesListJSON.get(0);
            return serviceJSON.getString("name");
        }
        throw new VCommanderException("Published service not found with ID: " + publishedServiceId);
    }

    public String getServiceRequestPayload(Long serviceID) throws JSONException, VCommanderException {
        if (serviceID == null) {
            throw new VCommanderException("No serviceID provided.");
        }
        ClientResponse publishedServicePayloadResponse = (ClientResponse)this.webResource.path("services").path(serviceID.toString()).path(PUBLISHED_SERVICE_FORM).accept(new String[]{"application/json"}).get(ClientResponse.class);
        ClientUtils.checkResponse(publishedServicePayloadResponse, ClientResponse.Status.OK.getStatusCode());
        String publishedServicePayloadStr = (String)publishedServicePayloadResponse.getEntity(String.class);
        JSONObject publishedServicePayloadJSON = new JSONObject(publishedServicePayloadStr);
        return publishedServicePayloadJSON.toString(2);
    }

    public Long requestService(String payload) throws JSONException, VCommanderException {
        if (StringUtils.isBlank((String)payload)) {
            throw new VCommanderException("No payload provided.");
        }
        JSONObject newRequestJSON = new JSONObject(payload);
        if (newRequestJSON.isNull(PUBLISHED_SERVICE_FORM_SERVICE_ID)) {
            throw new VCommanderException("Payload is missing the 'service_id' element");
        }
        ClientResponse newRequestResponse = (ClientResponse)this.webResource.path(SERVICE_REQUESTS_PATH).type("application/json").post(ClientResponse.class, (Object)newRequestJSON.toString());
        ClientUtils.checkResponse(newRequestResponse, ClientResponse.Status.CREATED.getStatusCode());
        String requestStr = (String)newRequestResponse.getEntity(String.class);
        JSONObject requestJSON = new JSONObject(requestStr);
        JSONObject summary = requestJSON.getJSONObject("summary");
        return summary.getLong("id");
    }

    public List<DeployedComponentInfo> waitForServiceRequestToBeCompleted(Long requestId, long timeout, long polling, PrintStream logger) throws JSONException, InterruptedException, VCommanderException {
        JSONObject requestJSON;
        String requestState;
        if (requestId == null) {
            throw new VCommanderException("No requestId provided.");
        }
        long startTime = System.currentTimeMillis();
        HashSet<String> loggedComments = new HashSet<String>();
        while (!REQUESTED_SERVICE_STATE_COMPLETED.equals(requestState = this.getRequestState(requestJSON = this.checkServiceRequestIfCompletedAndWait(requestId, loggedComments, startTime, timeout, polling, logger)))) {
        }
        ArrayList<DeployedComponentInfo> deployedComponents = new ArrayList<DeployedComponentInfo>();
        JSONArray services = requestJSON.getJSONArray("services");
        for (int i = 0; i < services.length(); ++i) {
            JSONObject service = services.getJSONObject(i);
            JSONArray components = service.getJSONArray(REQUESTED_SERVICE_SERVICE_COMPONENTS);
            for (int j = 0; j < components.length(); ++j) {
                JSONObject component = (JSONObject)components.get(j);
                JSONObject componentSummary = component.getJSONObject("summary");
                if (componentSummary.isNull(REQUESTED_SERVICE_SERVICE_COMPONENT_DEPLOYED_OBJECT)) continue;
                JSONObject deployedComponent = componentSummary.getJSONObject(REQUESTED_SERVICE_SERVICE_COMPONENT_DEPLOYED_OBJECT);
                deployedComponents.add(new DeployedComponentInfo(i + 1, j + 1, deployedComponent.getString(REQUESTED_SERVICE_SERVICE_COMPONENT_DEPLOYED_OBJECT_TYPE), deployedComponent.getString("name")));
            }
        }
        return deployedComponents;
    }

    private JSONObject checkServiceRequestIfCompletedAndWait(Long requestId, Set<String> loggedComments, long startTimeInMillis, long timeoutInMinutes, long pollingInSeconds, PrintStream logger) throws VCommanderException, JSONException, InterruptedException {
        ClientUtils.log(logger, "Looking up service request with ID: " + requestId);
        JSONObject requestJSON = this.getRequest(requestId, logger);
        String requestState = this.getRequestState(requestJSON);
        if (logger != null) {
            List<Comment> comments = this.getRequestComments(requestId, logger);
            for (Comment requestComment : comments) {
                String commentStr = requestComment.toString();
                if (loggedComments.contains(commentStr)) continue;
                logger.println();
                logger.println("Request Comment: ");
                logger.println(commentStr);
                logger.println();
                loggedComments.add(commentStr);
            }
        }
        switch (requestState) {
            case "COMPLETED": {
                break;
            }
            case "FAILED": {
                throw new VCommanderException("Service request failed");
            }
            case "REJECTED": {
                throw new VCommanderException("Service request rejected");
            }
            default: {
                long currentTimeInMillis = System.currentTimeMillis();
                if (startTimeInMillis + timeoutInMinutes * 60000L <= currentTimeInMillis) {
                    throw new VCommanderException("Service request did not completed in the given timeout: " + timeoutInMinutes + " minutes");
                }
                long toWait = Math.min(pollingInSeconds * 1000L, startTimeInMillis + timeoutInMinutes * 60000L - currentTimeInMillis);
                ClientUtils.log(logger, "Service request state is: " + requestState + ". Wait " + toWait / 1000L + " seconds ...");
                Thread.sleep(toWait);
            }
        }
        return requestJSON;
    }

    private JSONObject getRequest(Long requestId, PrintStream logger) {
        try {
            ClientResponse requestResponse = (ClientResponse)this.webResource.path(SERVICE_REQUESTS_PATH).path(requestId.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
            ClientUtils.checkResponse(requestResponse, ClientResponse.Status.OK.getStatusCode());
            String requestStr = (String)requestResponse.getEntity(String.class);
            return new JSONObject(requestStr);
        }
        catch (Exception e) {
            ClientUtils.log(logger, "\tError while looking up request with ID: " + requestId + " Message: " + e.getMessage());
            return null;
        }
    }

    private String getRequestState(JSONObject request) throws JSONException {
        if (request != null) {
            JSONObject summary = request.getJSONObject("summary");
            return summary.getString(REQUESTED_SERVICE_STATE);
        }
        return "";
    }

    private List<Comment> getRequestComments(Long requestId, PrintStream logger) {
        try {
            ClientResponse commentsResponse = (ClientResponse)this.webResource.path(SERVICE_REQUESTS_PATH).path(requestId.toString()).path(SERVICE_REQUEST_COMMENTS_PATH).accept(new String[]{"application/json"}).get(ClientResponse.class);
            return ClientUtils.getComments(commentsResponse);
        }
        catch (Exception e) {
            ClientUtils.log(logger, "\tError while looking up workflow comments for request with ID: " + requestId + " Message: " + e.getMessage());
            return Collections.emptyList();
        }
    }
}

