/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.plugin.actions;

import com.embotics.vlm.plugin.Messages;
import com.embotics.vlm.plugin.VCommanderAction;
import com.embotics.vlm.plugin.VCommanderConfig;
import com.embotics.vlm.plugin.actions.AbstractVCommanderAction;
import com.embotics.vlm.plugin.actions.PluginUtils;
import com.embotics.vlm.plugin.actions.VCommanderRunWorkflowAction;
import com.embotics.vlm.rest.v30.client.VCommanderClient;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class VCommanderWaitForRunWorkflowAction
extends AbstractVCommanderAction {
    private final String taskId;
    @Extension(ordinal=155.0)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VCommanderWaitForRunWorkflowAction(String taskId, Long timeout, Long polling) {
        super(true, timeout, polling);
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Run<?, ?> run, TaskListener listener) throws InterruptedException, IOException {
        String taskIdStr = this.taskId;
        if (taskIdStr != null) {
            taskIdStr = Util.replaceMacro((String)taskIdStr, (Map)run.getEnvironment(listener));
        }
        if (StringUtils.isBlank((String)taskIdStr)) {
            throw new VCommanderException("Error in build step configuration. TaskId is not specified.");
        }
        listener.getLogger().println(client.getClientInfo());
        try (VCommanderClient client = VCommanderConfig.getVCommanderClient();){
            VCommanderRunWorkflowAction.waitForWorkflowToBeCompleted(client, taskIdStr, this.getTimeout(), this.getPolling(), run, listener);
        }
    }

    public Descriptor<VCommanderAction> getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends AbstractVCommanderAction.AbstractVCommanderActionDescriptor {
        public String getDisplayName() {
            return Messages.VCommanderWaitForRunWorkflowAction_DisplayName();
        }

        public String getDefaultTaskId() {
            return "$VCOMMANDER_WORKFLOW_TASK_ID";
        }

        public FormValidation doCheckTaskId(@QueryParameter String taskId) throws IOException, ServletException {
            if (PluginUtils.isNumericOrVariable(taskId)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.VCommanderWaitForRunWorkflowAction_errors_taskId());
        }
    }
}

