/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class LinesDataSet {
    private final Map<String, List<Integer>> dataSetSeries = new HashMap<String, List<Integer>>();
    private final List<String> domainAxisLabels = new ArrayList<String>();
    private final List<Integer> buildNumbers = new ArrayList<Integer>();

    public int getDomainAxisSize() {
        return this.domainAxisLabels.size();
    }

    public List<String> getDomainAxisLabels() {
        return this.domainAxisLabels;
    }

    public Set<String> getDataSetIds() {
        return this.dataSetSeries.keySet();
    }

    boolean hasSeries(String dataSetId) {
        return this.dataSetSeries.containsKey(dataSetId);
    }

    public boolean isEmpty() {
        return this.domainAxisLabels.isEmpty();
    }

    public List<Integer> getSeries(String dataSetId) {
        if (!this.hasSeries(dataSetId)) {
            throw new NoSuchElementException("No dataset '%s' registered".formatted(dataSetId));
        }
        return this.getSeriesFromMap(dataSetId);
    }

    public void add(String domainAxisLabel, Map<String, Integer> dataSetValues) {
        this.domainAxisLabels.add(domainAxisLabel);
        for (Map.Entry<String, Integer> dataPoints : dataSetValues.entrySet()) {
            this.dataSetSeries.putIfAbsent(dataPoints.getKey(), new ArrayList());
            this.getSeriesFromMap(dataPoints.getKey()).add(Objects.requireNonNull(dataPoints.getValue()));
        }
    }

    public void add(String domainAxisLabel, Map<String, Integer> dataSetValues, int buildNumber) {
        this.add(domainAxisLabel, dataSetValues);
        if (this.buildNumbers.contains(buildNumber)) {
            throw new IllegalStateException("Build number already registered: " + buildNumber);
        }
        this.buildNumbers.add(buildNumber);
    }

    private List<Integer> getSeriesFromMap(String key) {
        return Objects.requireNonNull(this.dataSetSeries.get(key));
    }

    public List<Integer> getBuildNumbers() {
        return this.buildNumbers;
    }
}

