/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatables;

import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.datatables.TableConfiguration;
import java.util.List;
import java.util.stream.Collectors;

public abstract class TableModel {
    public abstract String getId();

    public abstract List<TableColumn> getColumns();

    public String getColumnsDefinition() {
        return this.getColumns().stream().map(TableColumn::getDefinition).collect(Collectors.joining(",", "[", "]"));
    }

    public abstract List<Object> getRows();

    public TableConfiguration getTableConfiguration() {
        return new TableConfiguration();
    }

    public String getTableConfigurationDefinition() {
        return this.getTableConfiguration().getConfiguration();
    }

    public static class DetailedColumnDefinition {
        private final String display;
        private final String sort;

        public DetailedColumnDefinition(String display, String sort) {
            this.display = display;
            this.sort = sort;
        }

        public String getDisplay() {
            return this.display;
        }

        public String getSort() {
            return this.sort;
        }
    }
}

