/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatables;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.Map;

public class TableConfiguration {
    private final Map<String, Object> configuration = new HashMap<String, Object>();
    private boolean useResponsive = false;
    private boolean useColReorder = false;
    private boolean useButtons = false;

    public TableConfiguration responsive() {
        this.configuration.put("responsive", true);
        this.useResponsive = true;
        return this;
    }

    public boolean isUseResponsive() {
        return this.useResponsive;
    }

    public TableConfiguration colReorder() {
        this.configuration.put("colReorder", true);
        this.useColReorder = true;
        return this;
    }

    public boolean isUseColReorder() {
        return this.useColReorder;
    }

    public TableConfiguration buttons() {
        this.configuration.put("buttons", true);
        this.useButtons = true;
        return this;
    }

    public TableConfiguration buttons(String ... types) {
        this.configuration.put("buttons", types);
        this.useButtons = true;
        return this;
    }

    public boolean isUseButtons() {
        return this.useButtons;
    }

    public TableConfiguration stateSave() {
        this.configuration.put("stateSave", true);
        return this;
    }

    public String getConfiguration() {
        try {
            return new ObjectMapper().writeValueAsString(this.configuration);
        }
        catch (JsonProcessingException exception) {
            throw new IllegalArgumentException(String.format("Can't convert table configuration '%s' to JSON object", this.configuration), exception);
        }
    }

    @JsonSerialize
    private static class EmptyConfigObject {
        private EmptyConfigObject() {
        }
    }
}

