/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatables;

import edu.hm.hafner.util.VisibleForTesting;
import io.jenkins.plugins.fontawesome.api.SvgTag;
import io.jenkins.plugins.util.JenkinsFacade;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;

public class TableColumn {
    @VisibleForTesting
    static final String DETAILS_COLUMN_ICON_NAME = "plus-circle";
    private final String headerLabel;
    private final String definition;
    private ColumnCss headerClass = ColumnCss.NONE;
    private int width = 1;

    public static String renderDetailsColumn(String detailsText) {
        return TableColumn.renderDetailsColumn(detailsText, new JenkinsFacade());
    }

    public static String renderDetailsColumn(String detailsText, JenkinsFacade jenkinsFacade) {
        return ((ContainerTag)((ContainerTag)TagCreator.div().withClass("details-control")).attr("data-description", (Object)detailsText)).with((DomContent)new UnescapedText(new SvgTag(DETAILS_COLUMN_ICON_NAME, jenkinsFacade).withClasses(new String[]{"details-icon"}).render())).render();
    }

    public TableColumn(String headerLabel, String dataPropertyName) {
        this.headerLabel = headerLabel;
        this.definition = String.format("{  \"data\": \"%s\",  \"defaultContent\": \"\"}", dataPropertyName);
    }

    public TableColumn(String headerLabel, String dataPropertyName, String columnDataType) {
        this.headerLabel = headerLabel;
        this.definition = String.format("{  \"type\": \"%s\",  \"data\": \"%s\",  \"defaultContent\": \"\",  \"render\": {     \"_\": \"display\",     \"sort\": \"sort\"  }}", columnDataType, dataPropertyName);
    }

    public TableColumn setHeaderClass(ColumnCss headerClass) {
        this.headerClass = headerClass;
        return this;
    }

    public TableColumn setWidth(int width) {
        this.width = width;
        return this;
    }

    public String getHeaderLabel() {
        return this.headerLabel;
    }

    public String getHeaderClass() {
        return this.headerClass.toString();
    }

    public int getWidth() {
        return this.width;
    }

    public String getDefinition() {
        return this.definition;
    }

    public static enum ColumnCss {
        NONE(""),
        DATE("date"),
        NO_SORT("nosort");

        private final String cssClass;

        private ColumnCss(String cssClass) {
            this.cssClass = cssClass;
        }

        public String toString() {
            return this.cssClass;
        }
    }
}

