/*
 * Decompiled with CFR 0.152.
 */
package com.bluersw.analyze;

import com.bluersw.analyze.Configuration;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractFormat
implements Configuration {
    protected final String content;
    protected final LinkedHashMap<String, String> index = new LinkedHashMap();
    protected LinkedHashMap<String, Object> data;

    public AbstractFormat(String content) throws Exception {
        this.content = content;
        this.initializeData();
    }

    public AbstractFormat(InputStream inputStream) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));){
            String line;
            String lineFeed = "\r\n";
            StringBuilder buffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append("\r\n");
            }
            this.content = buffer.toString();
        }
        this.initializeData();
    }

    private void initializeData() throws Exception {
        this.data = this.loadData();
        this.initializeIndex(this.data, "//");
    }

    protected abstract LinkedHashMap<String, Object> loadData() throws Exception;

    private void initializeIndex(Object object, String parentName) {
        Iterator iterator = null;
        String string = parentName = parentName.endsWith("/") ? parentName : parentName + "/";
        if (object instanceof LinkedHashMap) {
            LinkedHashMap linkMap = (LinkedHashMap)object;
            iterator = linkMap.entrySet().iterator();
        } else if (object instanceof ArrayList) {
            ArrayList list = (ArrayList)object;
            iterator = list.iterator();
        } else if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            if (entry.getValue() instanceof ArrayList || entry.getValue() instanceof LinkedHashMap) {
                parentName = parentName + entry.getKey().toString() + "/";
                this.initializeIndex(entry.getValue(), parentName);
            } else {
                parentName = parentName + entry.getKey().toString();
                parentName = parentName + "@" + (parentName + "/" + entry.getValue().toString()).hashCode();
                this.index.put(parentName, entry.getValue().toString());
            }
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.initializeIndex(iterator.next(), parentName);
            }
        }
    }

    @Override
    public List<String> getValueListBySearch(String searchCommand) {
        searchCommand = searchCommand.replace('\\', '/');
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.index.entrySet()) {
            if (!entry.getKey().startsWith(searchCommand)) continue;
            result.add(entry.getValue());
        }
        return result;
    }
}

