/*
 * Decompiled with CFR 0.152.
 */
package com.bluersw.source;

import com.bluersw.source.DataSource;
import hudson.FilePath;
import hudson.model.Executor;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class FileRead
implements DataSource {
    private final String filePath;
    private String statusLine;
    private int statusCode;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public FileRead(String filePath) {
        this.filePath = filePath.replace("/", FILE_SEPARATOR).replace("\\", FILE_SEPARATOR);
        this.statusLine = "unknown.StatusCode:0";
        this.statusCode = 0;
    }

    @Override
    public String get() throws Exception {
        Executor executor = Executor.currentExecutor();
        Object channel = executor != null ? executor.getOwner().getChannel() : Channel.current();
        FilePath file = new FilePath((VirtualChannel)channel, this.filePath);
        InputStream inputStream = file.read();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));){
            String line;
            String lineFeed = "\r\n";
            StringBuilder buffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append("\r\n");
            }
            this.statusLine = "Read File Success.StatusCode:200";
            this.statusCode = 200;
            String string = buffer.toString();
            return string;
        }
    }

    @Override
    public String getStatusLine() {
        return this.statusLine;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }
}

