/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.source;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.coverage.BuildUtils;
import io.jenkins.plugins.coverage.exception.CoverageException;
import io.jenkins.plugins.coverage.source.SourceFileResolver;
import io.jenkins.plugins.coverage.targets.CoveragePaint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultSourceFileResolver
extends SourceFileResolver {
    public static final String DEFAULT_SOURCE_CODE_STORE_DIRECTORY = "coverage-sources/";

    @DataBoundConstructor
    public DefaultSourceFileResolver(SourceFileResolver.SourceFileResolverLevel level) {
        super(level);
    }

    @Override
    public void resolveSourceFiles(Run<?, ?> run, FilePath workspace, TaskListener listener, Map<String, CoveragePaint> paints) throws IOException {
        File sourceFileDir;
        Run<?, ?> b;
        Run<?, ?> lastBuild;
        if (this.getLevel() == null || this.getLevel().equals((Object)SourceFileResolver.SourceFileResolverLevel.NEVER_STORE)) {
            return;
        }
        File runRootDir = run.getRootDir();
        listener.getLogger().printf("Source File Navigation is enabled - Current level: %s%n", new Object[]{this.getLevel()});
        if (this.getLevel().equals((Object)SourceFileResolver.SourceFileResolverLevel.STORE_LAST_BUILD) && (lastBuild = BuildUtils.getPreviousNotFailedCompletedBuild(run)) != null && (b = BuildUtils.getPreviousNotFailedCompletedBuild(lastBuild)) != null && (sourceFileDir = new File(b.getRootDir(), "coverage-sources")).exists() && sourceFileDir.isDirectory()) {
            FileUtils.deleteDirectory((File)sourceFileDir);
        }
        listener.getLogger().printf("%d source files need to be copied.%n", paints.size());
        Map<String, FilePath> sourceFileMapping = this.createSourceFileMapping(workspace, listener);
        paints.forEach((sourceFilePath, paint) -> {
            FilePath buildDirSourceFile = new FilePath(new File(runRootDir, DEFAULT_SOURCE_CODE_STORE_DIRECTORY + this.sanitizeFilename((String)sourceFilePath)));
            try {
                boolean copiedSucceed;
                listener.getLogger().printf("Starting copy source file %s. %n", sourceFilePath);
                Set<String> possibleParentPaths = this.getPossiblePaths();
                if (possibleParentPaths == null) {
                    possibleParentPaths = Collections.emptySet();
                }
                if (copiedSucceed = ((Boolean)workspace.act((FilePath.FileCallable)new SourceFilePainter((String)sourceFilePath, (CoveragePaint)paint, buildDirSourceFile, possibleParentPaths, sourceFileMapping))).booleanValue()) {
                    listener.getLogger().printf("Copied %s. %n", sourceFilePath);
                }
            }
            catch (IOException | InterruptedException e) {
                listener.getLogger().println(e.getMessage());
            }
        });
    }

    private String sanitizeFilename(String inputName) {
        return inputName.replaceAll("[^a-zA-Z0-9-_.]", "_");
    }

    private Map<String, FilePath> createSourceFileMapping(FilePath workspace, TaskListener listener) {
        try {
            return Arrays.stream(workspace.list("**/*")).collect(Collectors.toMap(FilePath::getName, Function.identity(), (path1, path2) -> path1));
        }
        catch (IOException | InterruptedException e) {
            listener.getLogger().println(e);
            return Collections.emptyMap();
        }
    }

    private static class SourceFilePainter
    extends MasterToSlaveFileCallable<Boolean> {
        private static final long serialVersionUID = 6548573019315830249L;
        private final String sourceFilePath;
        private final Set<String> possiblePaths;
        private final CoveragePaint paint;
        private final FilePath destination;
        private final Map<String, FilePath> sourceFileMapping;

        SourceFilePainter(@Nonnull String sourceFilePath, @Nonnull CoveragePaint paint, @Nonnull FilePath destination, @Nonnull Set<String> possiblePaths, @Nonnull Map<String, FilePath> sourceFileMapping) {
            this.sourceFilePath = sourceFilePath;
            this.paint = paint;
            this.destination = destination;
            this.possiblePaths = possiblePaths;
            this.sourceFileMapping = sourceFileMapping;
        }

        public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
            FilePath sourceFile = this.tryFindSourceFile(workspace);
            if (sourceFile == null) {
                throw new IOException(String.format("Unable to find source file %s in workspace %s", this.sourceFilePath, workspace.getAbsolutePath()));
            }
            try {
                this.paintSourceCode(sourceFile, this.paint, this.destination);
            }
            catch (CoverageException e) {
                throw new IOException(e);
            }
            return true;
        }

        private FilePath tryFindSourceFile(File workspace) {
            LinkedList<File> possibleDirectories = new LinkedList<File>();
            for (String directory : this.possiblePaths) {
                File pathFromWorkDir;
                File pathFromRoot = new File(directory);
                if (pathFromRoot.exists() && pathFromRoot.isDirectory()) {
                    possibleDirectories.add(pathFromRoot);
                }
                if (!(pathFromWorkDir = new File(workspace, directory)).exists() || !pathFromWorkDir.isDirectory() || pathFromWorkDir.equals(pathFromRoot)) continue;
                possibleDirectories.add(pathFromWorkDir);
            }
            File sourceFile = new File(workspace, this.sourceFilePath);
            if (this.isValidSourceFile(sourceFile)) {
                return new FilePath(sourceFile);
            }
            for (File directory : possibleDirectories) {
                sourceFile = new File(directory, this.sourceFilePath);
                if (!this.isValidSourceFile(sourceFile)) continue;
                return new FilePath(sourceFile);
            }
            if (Paths.get(this.sourceFilePath, new String[0]).isAbsolute() && Paths.get(this.sourceFilePath, new String[0]).normalize().startsWith(workspace.getAbsolutePath()) && this.isValidSourceFile(sourceFile = new File(this.sourceFilePath))) {
                return new FilePath(sourceFile);
            }
            return this.sourceFileMapping.get(this.sourceFilePath);
        }

        private boolean isValidSourceFile(File sourceFile) {
            return sourceFile.exists() && sourceFile.isFile() && sourceFile.canRead();
        }

        private void paintSourceCode(FilePath source, CoveragePaint paint, FilePath canvas) throws CoverageException {
            try (BufferedWriter output = new BufferedWriter(new OutputStreamWriter(canvas.write(), StandardCharsets.UTF_8));
                 BufferedReader input = new BufferedReader(new InputStreamReader(source.read(), StandardCharsets.UTF_8));){
                String content;
                int line = 0;
                while ((content = input.readLine()) != null) {
                    if (paint.isPainted(++line)) {
                        int coveragePercent;
                        int hits = paint.getHits(line);
                        int branchCoverage = paint.getBranchCoverage(line);
                        int branchTotal = paint.getBranchTotal(line);
                        int n = coveragePercent = hits == 0 ? 0 : (int)((double)branchCoverage * 100.0 / (double)branchTotal);
                        if (paint.getHits(line) > 0) {
                            if (branchTotal == branchCoverage) {
                                output.write("<tr class=\"coverFull\">\n");
                            } else {
                                output.write("<tr class=\"coverPart\" title=\"Line " + line + ": Conditional coverage " + coveragePercent + "% (" + branchCoverage + "/" + branchTotal + ")\">\n");
                            }
                        } else {
                            output.write("<tr class=\"coverNone\">\n");
                        }
                        output.write("<td class=\"line\"><a name='" + line + "'>" + line + "</a></td>\n");
                        output.write("<td class=\"hits\">" + hits + "</td>\n");
                    } else {
                        output.write("<tr class=\"noCover\">\n");
                        output.write("<td class=\"line\"><a name='" + line + "'>" + line + "</a></td>\n");
                        output.write("<td class=\"hits\"></td>\n");
                    }
                    output.write("<td class=\"code\">" + content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "").replace("\r", "").replace(" ", "&nbsp;").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;") + "</td>\n");
                    output.write("</tr>\n");
                }
                paint.setTotalLines(line);
            }
            catch (IOException | InterruptedException e) {
                throw new CoverageException(e);
            }
        }
    }

    @Symbol(value={"sourceFiles"})
    @Extension
    public static final class DefaultSourceFileResolverDescriptor<T extends SourceFileResolver>
    extends Descriptor<SourceFileResolver> {
        private static final ListBoxModel LEVELS = new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option(SourceFileResolver.SourceFileResolverLevel.NEVER_STORE.getName(), SourceFileResolver.SourceFileResolverLevel.NEVER_STORE.toString()), new ListBoxModel.Option(SourceFileResolver.SourceFileResolverLevel.STORE_LAST_BUILD.getName(), SourceFileResolver.SourceFileResolverLevel.STORE_LAST_BUILD.toString()), new ListBoxModel.Option(SourceFileResolver.SourceFileResolverLevel.STORE_ALL_BUILD.getName(), SourceFileResolver.SourceFileResolverLevel.STORE_ALL_BUILD.toString())});

        public DefaultSourceFileResolverDescriptor() {
            super(DefaultSourceFileResolver.class);
        }

        public ListBoxModel doFillLevelItems() {
            return LEVELS;
        }
    }
}

