/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.adapter.util;

import io.jenkins.plugins.coverage.exception.CoverageException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static XMLUtils converter = new XMLUtils();

    public static XMLUtils getInstance() {
        return converter;
    }

    private XMLUtils() {
    }

    public Document convertToDocumentWithXSL(StreamSource xsl, File source) throws FileNotFoundException, CoverageException {
        DOMResult result = this.convertToDOMResultWithXSL(xsl, source);
        return this.getDocumentFromDomResult(result);
    }

    private void convertWithXSL(StreamSource xsl, File source, Result result) throws FileNotFoundException, CoverageException {
        Transformer transformer;
        if (!source.exists()) {
            throw new FileNotFoundException("source File does not exist!");
        }
        TransformerFactory transformerFactory = this.newSecureTransformerFactory();
        try {
            transformer = transformerFactory.newTransformer(xsl);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new CoverageException(e);
        }
        try {
            Document d;
            transformer.transform(new StreamSource(source), result);
            if (result instanceof DOMResult && ((d = this.getDocumentFromDomResult((DOMResult)result)) == null || d.getDocumentElement() == null)) {
                throw new TransformerException("Transform failed");
            }
        }
        catch (TransformerException e) {
            try {
                transformer.transform(new DOMSource(this.readXMLtoDocumentWithoutXSD(source)), result);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException ignore) {
                throw new CoverageException(e);
            }
        }
    }

    public DOMResult convertToDOMResultWithXSL(StreamSource xsl, File source) throws FileNotFoundException, CoverageException {
        DOMResult result = new DOMResult();
        this.convertWithXSL(xsl, source, result);
        return result;
    }

    public SAXResult convertToSAXResultWithXSL(StreamSource xsl, File source) throws FileNotFoundException, CoverageException {
        SAXResult result = new SAXResult();
        this.convertWithXSL(xsl, source, result);
        return result;
    }

    public void writeDocumentToXML(Document document, File target) {
        TransformerFactory transformerFactory = this.newSecureTransformerFactory();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(target));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public Document readXMLtoDocument(File file) throws TransformerException {
        TransformerFactory factory = this.newSecureTransformerFactory();
        Transformer transformer = factory.newTransformer();
        DOMResult result = new DOMResult();
        try {
            transformer.transform(new StreamSource(file), result);
        }
        catch (TransformerException e) {
            try {
                transformer.transform(new DOMSource(this.readXMLtoDocumentWithoutXSD(file)), result);
            }
            catch (IOException | ParserConfigurationException | SAXException ignore) {
                throw e;
            }
        }
        return this.getDocumentFromDomResult(result);
    }

    private Document readXMLtoDocumentWithoutXSD(File file) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
        return builder.parse(file);
    }

    private Document getDocumentFromDomResult(DOMResult domResult) {
        Node node = domResult.getNode();
        if (node == null) {
            return null;
        }
        return node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
    }

    private TransformerFactory newSecureTransformerFactory() {
        TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("http://saxon.sf.net/feature/parserFeature?uri=http://apache.org/xml/features/disallow-doctype-decl", true);
            transformerFactory.setAttribute("http://saxon.sf.net/feature/parserFeature?uri=http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            transformerFactory.setAttribute("http://saxon.sf.net/feature/parserFeature?uri=http://xml.org/sax/features/external-general-entities", false);
            transformerFactory.setAttribute("http://saxon.sf.net/feature/parserFeature?uri=http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        return transformerFactory;
    }
}

