/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.coverage.CoverageAction;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.Ratio;
import io.jenkins.plugins.monitoring.MonitorPortlet;
import io.jenkins.plugins.monitoring.MonitorPortletFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public class CoveragePullRequestMonitoringPortlet
extends MonitorPortlet {
    private final CoverageAction action;

    public CoveragePullRequestMonitoringPortlet(CoverageAction action) {
        this.action = action;
    }

    public String getTitle() {
        return this.action.getDisplayName();
    }

    public String getId() {
        return "code-coverage";
    }

    public boolean isDefault() {
        return true;
    }

    public int getPreferredWidth() {
        return 600;
    }

    public int getPreferredHeight() {
        return 350;
    }

    public Optional<String> getIconUrl() {
        return Optional.of("/images/48x48/graph.png");
    }

    public Optional<String> getDetailViewUrl() {
        return Optional.ofNullable(this.action.getUrlName());
    }

    public String getCoverageResultsAsJsonModel() {
        Ratio line = this.action.getResult().getResults().get(CoverageElement.LINE);
        Ratio conditional = this.action.getResult().getResults().get(CoverageElement.CONDITIONAL);
        JsonObject data = new JsonObject();
        JsonArray metrics = new JsonArray();
        metrics.add(CoverageElement.LINE.getName());
        metrics.add(CoverageElement.CONDITIONAL.getName());
        data.add("metrics", (JsonElement)metrics);
        JsonArray covered = new JsonArray();
        covered.add((Number)Float.valueOf(line.numerator));
        covered.add((Number)Float.valueOf(conditional.numerator));
        data.add("covered", (JsonElement)covered);
        JsonArray missed = new JsonArray();
        missed.add((Number)Float.valueOf(line.denominator - line.numerator));
        missed.add((Number)Float.valueOf(conditional.denominator - conditional.numerator));
        data.add("missed", (JsonElement)missed);
        JsonArray coveredPercentage = new JsonArray();
        coveredPercentage.add((Number)(line.denominator == 0.0f ? 0.0 : (double)(100.0f * ((float)covered.get(0).getAsInt() / line.denominator))));
        coveredPercentage.add((Number)(conditional.denominator == 0.0f ? 0.0 : (double)(100.0f * ((float)covered.get(1).getAsInt() / conditional.denominator))));
        data.add("coveredPercentage", (JsonElement)coveredPercentage);
        JsonArray missedPercentage = new JsonArray();
        missedPercentage.add((Number)(100.0 - coveredPercentage.get(0).getAsDouble()));
        missedPercentage.add((Number)(100.0 - coveredPercentage.get(1).getAsDouble()));
        data.add("missedPercentage", (JsonElement)missedPercentage);
        String deltaLineLabel = this.getReferenceBuildUrl().isPresent() ? String.format("%.2f%% (%s %.2f%%)", coveredPercentage.get(0).getAsDouble(), Character.valueOf('\u0394'), Float.valueOf(this.action.getResult().getCoverageDelta(CoverageElement.LINE))) : String.format("%.2f%% (%s unknown)", coveredPercentage.get(0).getAsDouble(), Character.valueOf('\u0394'));
        String deltaConditionalLabel = this.getReferenceBuildUrl().isPresent() ? String.format("%.2f%% (%s %.2f%%)", coveredPercentage.get(1).getAsDouble(), Character.valueOf('\u0394'), Float.valueOf(this.action.getResult().getCoverageDelta(CoverageElement.CONDITIONAL))) : String.format("%.2f%% (%s unknown)", coveredPercentage.get(1).getAsDouble(), Character.valueOf('\u0394'));
        JsonArray coveredPercentageLabels = new JsonArray();
        coveredPercentageLabels.add(deltaLineLabel);
        coveredPercentageLabels.add(deltaConditionalLabel);
        data.add("coveredPercentageLabels", (JsonElement)coveredPercentageLabels);
        return data.toString();
    }

    public Optional<String> getReferenceBuildUrl() {
        return Optional.ofNullable(this.action.getResult().getReferenceBuildUrl());
    }

    @Extension(optional=true)
    public static class PortletFactory
    extends MonitorPortletFactory {
        public Collection<MonitorPortlet> getPortlets(Run<?, ?> build) {
            CoverageAction action = (CoverageAction)build.getAction(CoverageAction.class);
            if (action == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(new CoveragePullRequestMonitoringPortlet(action));
        }

        public String getDisplayName() {
            return "Code Coverage API";
        }
    }
}

