/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.api.ChecksStatus;
import io.jenkins.plugins.coverage.CoverageAction;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import io.jenkins.plugins.coverage.targets.Ratio;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class CoverageChecksPublisher {
    private final CoverageAction action;
    private final JenkinsFacade jenkinsFacade;
    private static final List<String> COVERAGE_TYPES = Arrays.asList("Report", "Group", "Package", "File", "Class", "Method", "Conditional", "Line", "Instruction");

    CoverageChecksPublisher(CoverageAction action) {
        this(action, new JenkinsFacade());
    }

    @VisibleForTesting
    CoverageChecksPublisher(CoverageAction action, JenkinsFacade jenkinsFacade) {
        this.jenkinsFacade = jenkinsFacade;
        this.action = action;
    }

    void publishChecks(TaskListener listener) {
        ChecksPublisher publisher = ChecksPublisherFactory.fromRun(this.action.getOwner(), (TaskListener)listener);
        publisher.publish(this.extractChecksDetails());
    }

    @VisibleForTesting
    ChecksDetails extractChecksDetails() {
        CoverageResult result = this.action.getResult();
        ChecksOutput output = new ChecksOutput.ChecksOutputBuilder().withTitle(this.extractChecksTitle(result)).withSummary(this.extractComparedBuildsSummary(result) + this.extractHealthSummary(this.action)).withText(this.extractChecksText(result)).build();
        return new ChecksDetails.ChecksDetailsBuilder().withName("Code Coverage").withStatus(ChecksStatus.COMPLETED).withConclusion(StringUtils.isBlank((CharSequence)this.action.getFailMessage()) ? ChecksConclusion.SUCCESS : ChecksConclusion.FAILURE).withDetailsURL(this.jenkinsFacade.getAbsoluteUrl(new String[]{result.getOwner().getUrl(), this.action.getUrlName()})).withOutput(output).build();
    }

    private String extractChecksText(CoverageResult result) {
        Map<String, Float> ratios = this.convertRatios(result.getResults());
        Map<String, Float> lastRatios = this.convertRatios(this.getLastRatios(result));
        ArrayList<String> containedTypes = new ArrayList<String>(COVERAGE_TYPES.size());
        StringBuilder coverages = new StringBuilder("|:white_check_mark: **Coverage**|");
        StringBuilder trends = new StringBuilder("|:chart_with_upwards_trend: **Trend**|");
        for (String singleType : COVERAGE_TYPES) {
            if (!ratios.containsKey(singleType)) continue;
            containedTypes.add(singleType);
            float percentage = ratios.get(singleType).floatValue();
            coverages.append(String.format("%.2f%%|", Float.valueOf(percentage)));
            if (lastRatios.containsKey(singleType)) {
                float diff = percentage - lastRatios.get(singleType).floatValue();
                trends.append(String.format("%+.2f%%", Float.valueOf(diff)));
                if (Float.compare(diff, 0.0f) > 0) {
                    trends.append(" :arrow_up:|");
                    continue;
                }
                if (Float.compare(diff, 0.0f) < 0) {
                    trends.append(" :arrow_down:|");
                    continue;
                }
                trends.append(" :arrow_right:|");
                continue;
            }
            trends.append("-|");
        }
        return "||" + String.join((CharSequence)"|", containedTypes) + "|\n|" + String.join((CharSequence)"", Collections.nCopies(containedTypes.size() + 1, ":-:|")) + "\n" + coverages + "\n" + trends;
    }

    private String extractChecksTitle(CoverageResult result) {
        StringBuilder title = new StringBuilder();
        Map<CoverageElement, Ratio> lastRatios = this.getLastRatios(result);
        if (result.getCoverage(CoverageElement.LINE) != null) {
            float lineCoverage = result.getCoverage(CoverageElement.LINE).getPercentageFloat();
            if (result.getReferenceBuildUrl() != null) {
                title.append(this.extractChecksTitle("Line", "target branch", lineCoverage, result.getCoverageDelta(CoverageElement.LINE)));
            } else if (lastRatios.containsKey(CoverageElement.LINE)) {
                title.append(this.extractChecksTitle("Line", "last successful build", lineCoverage, lineCoverage - lastRatios.get(CoverageElement.LINE).getPercentageFloat()));
            } else {
                title.append(this.extractChecksTitle("Line", "", lineCoverage, 0.0f));
            }
            title.append(" ");
        }
        if (result.getCoverage(CoverageElement.CONDITIONAL) != null) {
            float branchCoverage = result.getCoverage(CoverageElement.CONDITIONAL).getPercentageFloat();
            if (result.getReferenceBuildUrl() != null) {
                title.append(this.extractChecksTitle("Branch", "target branch", branchCoverage, result.getCoverageDelta(CoverageElement.CONDITIONAL)));
            } else if (lastRatios.containsKey(CoverageElement.CONDITIONAL)) {
                title.append(this.extractChecksTitle("Branch", "last successful build", branchCoverage, branchCoverage - lastRatios.get(CoverageElement.CONDITIONAL).getPercentageFloat()));
            } else {
                title.append(this.extractChecksTitle("Branch", "", branchCoverage, 0.0f));
            }
        }
        if (title.length() == 0) {
            title.append("No line or branch coverage has been computed.");
        }
        return title.toString();
    }

    private String extractChecksTitle(String elementName, String targetBuildName, float coverage, float coverageDiff) {
        StringBuilder title = new StringBuilder().append(elementName).append(String.format(": %.2f", Float.valueOf(coverage))).append("%");
        if (StringUtils.isBlank((CharSequence)targetBuildName)) {
            title.append(".");
        } else {
            title.append(" (").append(String.format("%+.2f%%", Float.valueOf(coverageDiff))).append(" against ").append(targetBuildName).append(").");
        }
        return title.toString();
    }

    private String extractComparedBuildsSummary(CoverageResult result) {
        Run lastSuccessfulBuild;
        StringBuilder summary = new StringBuilder();
        if (result.getReferenceBuildUrl() != null) {
            summary.append("* ### [Target branch build](").append(this.jenkinsFacade.getAbsoluteUrl(new String[]{result.getReferenceBuildUrl()})).append(")\n");
        }
        if ((lastSuccessfulBuild = result.getOwner().getPreviousSuccessfulBuild()) != null) {
            summary.append("* ### [Last successful build](").append(this.jenkinsFacade.getAbsoluteUrl(new String[]{lastSuccessfulBuild.getUrl()})).append(")\n");
        }
        return summary.toString();
    }

    private String extractHealthSummary(CoverageAction action) {
        StringBuilder summary = new StringBuilder("## ").append(action.getHealthReport().getLocalizableDescription().toString()).append(".");
        if (!StringUtils.isBlank((CharSequence)action.getFailMessage())) {
            summary.append("\n## ").append(action.getFailMessage());
        }
        return summary.toString();
    }

    private Map<CoverageElement, Ratio> getLastRatios(CoverageResult result) {
        CoverageResult previousResult = result.getPreviousResult();
        if (previousResult == null) {
            return Collections.emptyMap();
        }
        return previousResult.getResults();
    }

    private Map<String, Float> convertRatios(Map<CoverageElement, Ratio> ratios) {
        HashMap<String, Float> converted = new HashMap<String, Float>(ratios.size());
        for (Map.Entry<CoverageElement, Ratio> singleRatio : ratios.entrySet()) {
            converted.put(singleRatio.getKey().getName(), Float.valueOf(singleRatio.getValue().getPercentageFloat()));
        }
        return converted;
    }
}

