/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.targets;

import io.jenkins.plugins.coverage.targets.CoverageElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CoverageElementRegister {
    private static Map<String, LinkedList<CoverageElement>> typedRegisteredElements = new HashMap<String, LinkedList<CoverageElement>>();

    public static boolean addCoverageElement(CoverageElement element) {
        return CoverageElementRegister.addCoverageElement("None", element);
    }

    public static boolean addCoverageElement(String type, CoverageElement element) {
        typedRegisteredElements.putIfAbsent(type, new LinkedList());
        return typedRegisteredElements.get(type).add(element);
    }

    public static boolean addCoverageElements(List<CoverageElement> elements) {
        return CoverageElementRegister.addCoverageElements("None", elements);
    }

    public static boolean addCoverageElements(String type, List<CoverageElement> elements) {
        typedRegisteredElements.putIfAbsent(type, new LinkedList());
        return typedRegisteredElements.get(type).addAll(elements);
    }

    public static CoverageElement get(String type, String name) {
        return typedRegisteredElements.get(type).stream().filter(c -> c.is(name)).findAny().orElse(null);
    }

    public static CoverageElement getDespiteType(String name) {
        return typedRegisteredElements.values().stream().flatMap(Collection::stream).filter(c -> c.is(name)).findAny().orElse(null);
    }

    public static CoverageElement[] all() {
        return typedRegisteredElements.values().stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList()).toArray(new CoverageElement[0]);
    }

    public static CoverageElement[] listByType(String type) {
        return typedRegisteredElements.get(type).toArray(new CoverageElement[0]);
    }

    public static CoverageElement[] listCommonsAndSpecificType(String type) {
        Object[] elements = typedRegisteredElements.entrySet().stream().filter(e -> ((String)e.getKey()).equals("None") || ((String)e.getKey()).equals(type)).flatMap(e -> ((LinkedList)e.getValue()).stream()).distinct().collect(Collectors.toList()).toArray(new CoverageElement[0]);
        Arrays.sort(elements);
        return elements;
    }

    static {
        CoverageElementRegister.addCoverageElement(CoverageElement.AGGREGATED_REPORT);
        CoverageElementRegister.addCoverageElement(CoverageElement.REPORT);
        CoverageElementRegister.addCoverageElement(CoverageElement.LINE);
        CoverageElementRegister.addCoverageElement(CoverageElement.CONDITIONAL);
    }
}

