/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.adapter.parser;

import io.jenkins.plugins.coverage.exception.CoverageException;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import io.jenkins.plugins.coverage.targets.Ratio;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CoverageParser {
    private static final Pattern CONDITION_COVERAGE_PATTERN = Pattern.compile("(\\d*)\\s*%\\s*\\((\\d*)/(\\d*)\\)");
    private String reportName;

    public CoverageParser(String reportName) {
        this.reportName = reportName;
    }

    public CoverageResult parse(Document document) throws CoverageException {
        Element documentElement = document.getDocumentElement();
        if (documentElement == null) {
            throw new CoverageException("Unable to parse report");
        }
        CoverageResult result = this.processElement(documentElement, null);
        this.parse(document.getDocumentElement(), result);
        return result;
    }

    public void parse(Node parent, CoverageResult parentResult) {
        NodeList nodeList = parent.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            CoverageResult r;
            Node n = nodeList.item(i);
            if (n.getNodeType() != 1 || (r = this.processElement((Element)n, parentResult)) == null) continue;
            this.parse(n, r);
        }
    }

    protected abstract CoverageResult processElement(Element var1, CoverageResult var2);

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    protected String getAttribute(Element e, String attributeName, String defaultValue) {
        String value = e.getAttribute(attributeName);
        return StringUtils.isEmpty((String)value) ? defaultValue : value;
    }

    protected String getAttribute(Element e, String attributeName) {
        return this.getAttribute(e, attributeName, null);
    }

    protected void processLine(Element current, CoverageResult parentResult) {
        Matcher matcher;
        String conditionCoverage;
        String hitsString = current.getAttribute("hits");
        String lineNumber = current.getAttribute("number");
        int denominator = 0;
        int numerator = 0;
        if (Boolean.parseBoolean(current.getAttribute("branch")) && (conditionCoverage = current.getAttribute("condition-coverage")) != null && (matcher = CONDITION_COVERAGE_PATTERN.matcher(conditionCoverage)).matches()) {
            assert (matcher.groupCount() == 3);
            String numeratorStr = matcher.group(2);
            String denominatorStr = matcher.group(3);
            try {
                numerator = Integer.parseInt(numeratorStr);
                denominator = Integer.parseInt(denominatorStr);
                parentResult.updateCoverage(CoverageElement.CONDITIONAL, Ratio.create(numerator, denominator));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            int hits = Integer.parseInt(hitsString);
            int number = Integer.parseInt(lineNumber);
            if (denominator == 0) {
                parentResult.paint(number, hits);
            } else {
                parentResult.paint(number, hits, numerator, denominator);
            }
            parentResult.updateCoverage(CoverageElement.LINE, Ratio.create(hits == 0 ? 0.0f : 1.0f, 1.0f));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

