/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.adapter;

import com.google.common.collect.Lists;
import hudson.Extension;
import io.jenkins.plugins.coverage.adapter.CoverageReportAdapter;
import io.jenkins.plugins.coverage.adapter.CoverageReportAdapterDescriptor;
import io.jenkins.plugins.coverage.adapter.Messages;
import io.jenkins.plugins.coverage.adapter.XMLCoverageReportAdapter;
import io.jenkins.plugins.coverage.adapter.parser.CoverageParser;
import io.jenkins.plugins.coverage.exception.CoverageException;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IstanbulCoberturaReportAdapter
extends XMLCoverageReportAdapter {
    @DataBoundConstructor
    public IstanbulCoberturaReportAdapter(String path) {
        super(path);
    }

    @Override
    @CheckForNull
    public String getXSL() {
        return "istanbul-cobertura-to-standard.xsl";
    }

    @Override
    @Nullable
    public String getXSD() {
        return null;
    }

    @Override
    @CheckForNull
    protected CoverageResult parseToResult(Document document, String reportName) throws CoverageException {
        return new IstanbulCoberturaCoverageParser(reportName).parse(document);
    }

    public static class IstanbulCoberturaCoverageParser
    extends CoverageParser {
        public IstanbulCoberturaCoverageParser(String reportName) {
            super(reportName);
        }

        @Override
        protected CoverageResult processElement(Element current, CoverageResult parentResult) {
            CoverageResult result = null;
            switch (current.getLocalName()) {
                case "report": {
                    result = new CoverageResult(CoverageElement.REPORT, null, this.getAttribute(current, "name", "") + ": " + this.getReportName());
                    break;
                }
                case "directory": {
                    String directoryName = this.getAttribute(current, "name", "<root>").replaceAll("\\.", "/");
                    result = new CoverageResult(CoverageElement.get("Directory"), parentResult, directoryName);
                    break;
                }
                case "file": {
                    result = new CoverageResult(CoverageElement.get("File"), parentResult, this.getAttribute(current, "name", ""));
                    result.setRelativeSourcePath(this.getAttribute(current, "name", null));
                    break;
                }
                case "function": {
                    String functionName = this.getAttribute(current, "name", "");
                    result = new CoverageResult(CoverageElement.get("Function"), parentResult, functionName);
                    break;
                }
                case "line": {
                    this.processLine(current, parentResult);
                    break;
                }
                case "additionalProperty": {
                    String propertyName = this.getAttribute(current, "name", "");
                    if (StringUtils.isEmpty((String)propertyName)) break;
                    String propertyValue = this.getAttribute(current, "value", "");
                    parentResult.addAdditionalProperty(propertyName, propertyValue);
                    break;
                }
            }
            return result;
        }
    }

    @Symbol(value={"istanbulCoberturaAdapter", "istanbulCobertura"})
    @Extension
    public static class IstanbulCoberturaReportAdapterDescriptor
    extends CoverageReportAdapterDescriptor<CoverageReportAdapter> {
        public IstanbulCoberturaReportAdapterDescriptor() {
            super((Class<? extends CoverageReportAdapter>)IstanbulCoberturaReportAdapter.class);
        }

        @Override
        public List<CoverageElement> getCoverageElements() {
            return Lists.newArrayList((Object[])new CoverageElement[]{new CoverageElement("Directory", 1), new CoverageElement("File", 2), new CoverageElement("Function", 4)});
        }

        @Override
        public String getCoverageElementType() {
            return "JavaScript";
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.IstanbulCoberturaReportAdapter_displayName();
        }
    }
}

