/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.targets;

import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.Ratio;
import java.util.Map;
import java.util.TreeMap;

public class CoverageAggregationRule {
    public static Map<CoverageElement, Ratio> aggregate(CoverageElement source, CoverageElement input, Ratio inputResult, Map<CoverageElement, Ratio> runningTotal) {
        TreeMap<CoverageElement, Ratio> result = new TreeMap<CoverageElement, Ratio>(runningTotal);
        Ratio prevTotal = (Ratio)result.get(input);
        if (prevTotal == null) {
            prevTotal = Ratio.create(0.0f, 0.0f);
        }
        Ratio r = Ratio.create(inputResult.numerator + prevTotal.numerator, inputResult.denominator + prevTotal.denominator);
        result.put(input, r);
        return result;
    }

    public static Ratio combine(CoverageElement element, Ratio existingResult, Ratio additionalResult) {
        return Ratio.create(existingResult.numerator + additionalResult.numerator, existingResult.denominator + additionalResult.denominator);
    }
}

