/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.targets;

import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.Run;
import hudson.util.ChartUtil;
import hudson.util.TextFile;
import io.jenkins.plugins.coverage.BuildUtils;
import io.jenkins.plugins.coverage.CoverageAction;
import io.jenkins.plugins.coverage.exception.CoverageException;
import io.jenkins.plugins.coverage.targets.Chartable;
import io.jenkins.plugins.coverage.targets.CoverageAggregationRule;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoveragePaint;
import io.jenkins.plugins.coverage.targets.CoverageTree;
import io.jenkins.plugins.coverage.targets.CoverageTreeElement;
import io.jenkins.plugins.coverage.targets.CoverageTrend;
import io.jenkins.plugins.coverage.targets.CoverageTrendTree;
import io.jenkins.plugins.coverage.targets.Ratio;
import io.jenkins.plugins.coverage.targets.RestResultWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public class CoverageResult
implements Serializable,
Chartable {
    private static final long serialVersionUID = -3524882671364156445L;
    private static final int DEFAULT_MAX_BUILDS_SHOW_IN_TREND = 6;
    private final CoverageElement element;
    private String name;
    private String tag;
    private float changeRequestCoverageDiffWithTargetBranch = 0.0f;
    private String linkToBuildThatWasUsedForComparison = null;
    private CoverageResult parent;
    private final Map<String, CoverageResult> children = new TreeMap<String, CoverageResult>();
    private final Map<CoverageElement, Ratio> aggregateResults = new TreeMap<CoverageElement, Ratio>();
    private final Map<CoverageElement, Ratio> localResults = new TreeMap<CoverageElement, Ratio>();
    private CoveragePaint paint;
    private String relativeSourcePath;
    private Map<String, Set<String>> additionalProperties = new HashMap<String, Set<String>>();
    public transient Run<?, ?> owner = null;

    public CoverageResult(CoverageElement elementType, CoverageResult parent, String name) {
        this.element = elementType;
        this.parent = parent;
        this.name = name;
        this.relativeSourcePath = null;
        if (this.parent != null) {
            if (parent.getPaint() != null) {
                this.paint = new CoveragePaint(this.element);
            }
            this.parent.children.put(name, this);
        }
    }

    public String getRelativeSourcePath() {
        return this.relativeSourcePath;
    }

    public void setRelativeSourcePath(String relativeSourcePath) {
        this.relativeSourcePath = relativeSourcePath;
        if (!StringUtils.isEmpty((String)relativeSourcePath)) {
            this.paint = new CoveragePaint(this.element);
        }
    }

    public String getName() {
        return this.name == null || this.name.trim().length() == 0 ? "Project" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CoverageResult getParent() {
        return this.parent;
    }

    public CoverageElement getElement() {
        return this.element;
    }

    public boolean isSourceCodeLevel() {
        return this.relativeSourcePath != null;
    }

    public boolean isAggregatedLevel() {
        return this.element.equals(CoverageElement.AGGREGATED_REPORT);
    }

    public CoveragePaint getPaint() {
        return this.paint;
    }

    public void paint(int line, int hits) {
        if (this.paint != null) {
            this.paint.paint(line, hits);
        }
    }

    public void paint(int line, int hits, int branchHits, int branchTotal) {
        if (this.paint != null) {
            this.paint.paint(line, hits, branchHits, branchTotal);
        }
    }

    private File getSourceFile() {
        if (this.hasPermission()) {
            File sourceFile = new File(this.owner.getRootDir(), "coverage-sources/" + this.sanitizeFilename(this.relativeSourcePath));
            if (sourceFile.exists()) {
                return sourceFile;
            }
            sourceFile = new File(this.owner.getRootDir(), "coverage-sources/" + this.relativeSourcePath);
            if (sourceFile.exists()) {
                return sourceFile;
            }
            return Paths.get(sourceFile.getPath(), new String[0]).normalize().toFile();
        }
        return null;
    }

    private String sanitizeFilename(String inputName) {
        return inputName.replaceAll("[^a-zA-Z0-9-_.]", "_");
    }

    public float getChangeRequestCoverageDiffWithTargetBranch() {
        return this.changeRequestCoverageDiffWithTargetBranch;
    }

    public void setChangeRequestCoverageDiffWithTargetBranch(float changeRequestCoverageDiffWithTargetBranch) {
        this.changeRequestCoverageDiffWithTargetBranch = changeRequestCoverageDiffWithTargetBranch;
    }

    public String getLinkToBuildThatWasUsedForComparison() {
        return this.linkToBuildThatWasUsedForComparison;
    }

    public void setLinkToBuildThatWasUsedForComparison(String linkToBuildThatWasUsedForComparison) {
        this.linkToBuildThatWasUsedForComparison = linkToBuildThatWasUsedForComparison;
    }

    public boolean isSourceFileAvailable() {
        if (this.hasPermission()) {
            File sourceFile = this.getSourceFile();
            return sourceFile != null && sourceFile.exists();
        }
        return false;
    }

    public boolean hasPermission() {
        return this.owner.hasPermission(Item.WORKSPACE);
    }

    public String getSourceFileContent() {
        if (!this.hasPermission()) {
            return null;
        }
        File sourceFile = this.getSourceFile();
        if (sourceFile == null) {
            return null;
        }
        try {
            return new TextFile(sourceFile).read();
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<CoverageResult> getParents() {
        ArrayList<CoverageResult> result = new ArrayList<CoverageResult>();
        for (CoverageResult p = this.getParent(); p != null; p = p.getParent()) {
            result.add(p);
        }
        Collections.reverse(result);
        return result;
    }

    public Set<CoverageElement> getChildElements() {
        TreeSet<CoverageElement> result = new TreeSet<CoverageElement>();
        for (CoverageResult child : this.children.values()) {
            result.add(child.element);
        }
        return result;
    }

    public CoverageElement getChildElement() {
        return this.getChildElements().stream().findAny().orElse(null);
    }

    public Set<String> getChildren(CoverageElement element) {
        TreeSet<String> result = new TreeSet<String>();
        for (CoverageResult child : this.children.values()) {
            if (!child.element.equals(element)) continue;
            result.add(child.name);
        }
        return result;
    }

    public Set<String> getChildren() {
        return this.children.keySet();
    }

    public Map<String, CoverageResult> getChildrenReal() {
        return this.children;
    }

    @Override
    public Map<CoverageElement, Ratio> getResults() {
        return Collections.unmodifiableMap(this.aggregateResults);
    }

    @Exported(name="results")
    public CoverageTree getResultsAPI() {
        return new CoverageTree(this.name, this.aggregateResults, this.children);
    }

    public List<CoverageTrend> getCoverageTrends() {
        if (this.getPreviousResult() == null) {
            return null;
        }
        LinkedList<CoverageTrend> coverageTrends = new LinkedList<CoverageTrend>();
        int i = 0;
        for (Chartable c = this; c != null && i < 6; c = c.getPreviousResult(), ++i) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(c.getOwner());
            List<CoverageTreeElement> elements = c.getResults().entrySet().stream().map(e -> new CoverageTreeElement((CoverageElement)e.getKey(), (Ratio)e.getValue())).collect(Collectors.toList());
            CoverageTrend trend = new CoverageTrend(label.toString(), elements);
            coverageTrends.add(trend);
        }
        return coverageTrends;
    }

    public String urlTransform(String name) {
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('0' <= c && '9' >= c || 'A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c) {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    public String xmlTransform(String name) {
        return name.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public String relativeUrl(CoverageResult parent) {
        StringBuilder url = new StringBuilder("..");
        for (CoverageResult p = this.getParent(); p != null && p != parent; p = p.getParent()) {
            url.append("/..");
        }
        return url.toString();
    }

    public CoverageResult getChild(String name) {
        return this.children.get(name);
    }

    public Ratio getCoverage(CoverageElement element) {
        return this.aggregateResults.get(element);
    }

    public Set<CoverageElement> getElements() {
        return Collections.unmodifiableSet(this.aggregateResults.isEmpty() ? Collections.emptySet() : this.aggregateResults.keySet());
    }

    public void updateCoverage(CoverageElement element, Ratio additionalResult) {
        if (this.localResults.containsKey(element)) {
            Ratio existingResult = this.localResults.get(element);
            this.localResults.put(element, CoverageAggregationRule.combine(element, existingResult, additionalResult));
        } else {
            this.localResults.put(element, additionalResult);
        }
    }

    @Override
    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(Run<?, ?> owner) {
        this.owner = owner;
        this.aggregateResults.clear();
        for (CoverageResult child : this.children.values()) {
            child.setOwner(owner);
            if (this.paint != null && child.paint != null) {
                this.paint.add(child.paint);
            }
            for (Map.Entry<CoverageElement, Ratio> childResult : child.aggregateResults.entrySet()) {
                this.aggregateResults.putAll(CoverageAggregationRule.aggregate(child.getElement(), childResult.getKey(), childResult.getValue(), this.aggregateResults));
            }
            Ratio prevTotal = this.aggregateResults.get(child.getElement());
            if (prevTotal == null) {
                prevTotal = Ratio.create(0.0f, 0.0f);
            }
            boolean isChildCovered = false;
            if (child.aggregateResults.entrySet().stream().anyMatch(coverageElementRatioEntry -> ((Ratio)coverageElementRatioEntry.getValue()).numerator > 0.0f)) {
                isChildCovered = true;
            }
            this.aggregateResults.put(child.getElement(), Ratio.create(prevTotal.numerator + (float)(isChildCovered ? 1 : 0), prevTotal.denominator + 1.0f));
        }
        this.aggregateResults.putAll(this.localResults);
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        this.setOwner((Run<?, ?>)owner);
    }

    public void merge(CoverageResult another) throws CoverageException {
        if (!this.element.equals(another.element)) {
            throw new CoverageException(String.format("Unable to merge reports: Unmatched element %s and %s", this.element.getName(), another.getElement().getName()));
        }
        for (Map.Entry<String, CoverageResult> childBeMerged : another.getChildrenReal().entrySet()) {
            if (this.getChild(childBeMerged.getKey()) == null) {
                childBeMerged.getValue().resetParent(this);
                continue;
            }
            this.getChild(childBeMerged.getKey()).merge(childBeMerged.getValue());
        }
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public CoverageResult getPreviousResult() {
        if (this.parent == null) {
            if (this.owner == null) {
                return null;
            }
            Run<?, ?> prevBuild = BuildUtils.getPreviousNotFailedCompletedBuild(this.owner);
            CoverageAction action = null;
            while (prevBuild != null && null == (action = (CoverageAction)prevBuild.getAction(CoverageAction.class))) {
                prevBuild = BuildUtils.getPreviousNotFailedCompletedBuild(prevBuild);
            }
            return action == null ? null : action.getResult();
        }
        CoverageResult prevParent = this.parent.getPreviousResult();
        return prevParent == null ? null : prevParent.getChild(this.name);
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        token = token.toLowerCase();
        String restPath = req.getRestOfPath();
        if (restPath.startsWith("/api/")) {
            if (token.equals("trend")) {
                return new RestResultWrapper(new CoverageTrendTree(this.getName(), this.getCoverageTrends(), this.getChildrenReal()));
            }
            if (token.equals("result")) {
                return new RestResultWrapper(this);
            }
        }
        for (String name : this.children.keySet()) {
            if (!this.urlTransform(name).toLowerCase().equals(token)) continue;
            return this.getChild(name);
        }
        return null;
    }

    public Map<String, CoveragePaint> getPaintedSources() {
        HashMap<String, CoveragePaint> result = new HashMap<String, CoveragePaint>();
        for (CoverageResult child : this.children.values()) {
            result.putAll(child.getPaintedSources());
        }
        if (this.relativeSourcePath != null && this.paint != null) {
            result.put(this.relativeSourcePath, this.paint);
        }
        return result;
    }

    public Object getLast() {
        return this.getPreviousResult();
    }

    public void addParent(CoverageResult p) {
        if (this.parent == null) {
            this.parent = p;
            if (this.parent != null) {
                this.parent.children.put(this.name, this);
            }
        }
    }

    public void resetParent(CoverageResult p) {
        this.parent = null;
        this.addParent(p);
    }

    public void addAdditionalProperty(String propertyName, String value) {
        this.additionalProperties.putIfAbsent(propertyName, new HashSet());
        this.additionalProperties.get(propertyName).add(value);
    }

    public Set<String> getAdditionalProperty(String propertyName) {
        return this.additionalProperties.get(propertyName);
    }

    @JavaScriptMethod
    public List<JSCoverageResult> jsGetResults() {
        LinkedList<JSCoverageResult> results = new LinkedList<JSCoverageResult>();
        for (Map.Entry<CoverageElement, Ratio> c : this.aggregateResults.entrySet()) {
            results.add(new JSCoverageResult(c.getKey().getName(), c.getValue()));
        }
        return results;
    }

    @JavaScriptMethod
    public Map<String, List<JSCoverageResult>> jsGetChildResults() {
        return this.getChildrenReal().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((CoverageResult)v.getValue()).jsGetResults()));
    }

    @JavaScriptMethod
    public Map<String, List<JSCoverageResult>> jsGetTrendResults() {
        LinkedHashMap<String, List<JSCoverageResult>> results = new LinkedHashMap<String, List<JSCoverageResult>>();
        if (this.getPreviousResult() == null) {
            return results;
        }
        int i = 0;
        for (Chartable c = this; c != null && i < 6; c = c.getPreviousResult(), ++i) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(c.getOwner());
            List r = c.getResults().entrySet().stream().filter(e -> {
                if (this.isAggregatedLevel()) {
                    return ((CoverageElement)e.getKey()).equals(CoverageElement.LINE) || ((CoverageElement)e.getKey()).equals(CoverageElement.REPORT);
                }
                return true;
            }).map(e -> new JSCoverageResult(((CoverageElement)e.getKey()).getName(), (Ratio)e.getValue())).collect(Collectors.toList());
            if (r.size() == 0) continue;
            results.put(label.toString(), r);
        }
        return results;
    }

    public static class JSCoverageResult {
        private String name;
        private Ratio ratio;

        public JSCoverageResult(String name, Ratio ratio) {
            this.name = name;
            this.ratio = ratio;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Ratio getRatio() {
            return this.ratio;
        }

        public void setRatio(Ratio ratio) {
            this.ratio = ratio;
        }
    }
}

