/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.steps;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.checks.api.ChecksAction;
import io.jenkins.plugins.checks.api.ChecksAnnotation;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.api.ChecksStatus;
import io.jenkins.plugins.checks.steps.ChecksInfo;
import io.jenkins.plugins.checks.steps.StepUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PublishChecksStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name = "";
    private String summary = "";
    private String title = "";
    private String text = "";
    private String detailsURL = "";
    private ChecksStatus status = ChecksStatus.COMPLETED;
    private ChecksConclusion conclusion = ChecksConclusion.SUCCESS;
    private List<StepChecksAction> actions = Collections.emptyList();
    private List<StepChecksAnnotation> annotations = Collections.emptyList();

    @DataBoundConstructor
    public PublishChecksStep() {
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    @DataBoundSetter
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
    }

    @DataBoundSetter
    public void setText(String text) {
        this.text = text;
    }

    @DataBoundSetter
    public void setDetailsURL(String detailsURL) {
        this.detailsURL = detailsURL;
    }

    @DataBoundSetter
    public void setStatus(ChecksStatus status) {
        this.status = status;
        if (status == ChecksStatus.QUEUED || status == ChecksStatus.IN_PROGRESS) {
            this.conclusion = ChecksConclusion.NONE;
        }
    }

    @DataBoundSetter
    public void setConclusion(ChecksConclusion conclusion) {
        this.conclusion = conclusion;
    }

    @DataBoundSetter
    public void setActions(List<StepChecksAction> actions) {
        this.actions = actions;
    }

    @DataBoundSetter
    public void setAnnotations(List<StepChecksAnnotation> annotations) {
        this.annotations = annotations;
    }

    public String getName() {
        return this.name;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTitle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.title, (CharSequence)this.name);
    }

    public String getText() {
        return this.text;
    }

    public String getDetailsURL() {
        return this.detailsURL;
    }

    public ChecksStatus getStatus() {
        return this.status;
    }

    public ChecksConclusion getConclusion() {
        return this.conclusion;
    }

    public List<StepChecksAction> getActions() {
        return this.actions;
    }

    public List<StepChecksAnnotation> getAnnotations() {
        return this.annotations;
    }

    public StepExecution start(StepContext stepContext) {
        return new PublishChecksStepExecution(stepContext, this);
    }

    public static class StepChecksAction
    extends AbstractDescribableImpl<StepChecksAction>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String label;
        private final String identifier;
        private String description = "";

        @DataBoundConstructor
        public StepChecksAction(String label, String identifier) {
            this.label = label;
            this.identifier = identifier;
        }

        @DataBoundSetter
        public void setDescription(String description) {
            this.description = description;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public ChecksAction getAction() {
            return new ChecksAction(this.label, this.description, this.identifier);
        }

        @Extension
        public static class StepChecksActionDescriptor
        extends Descriptor<StepChecksAction> {
        }
    }

    public static class StepChecksAnnotation
    extends AbstractDescribableImpl<StepChecksAnnotation>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String path;
        private final int startLine;
        private final int endLine;
        private final String message;
        @CheckForNull
        private Integer startColumn;
        @CheckForNull
        private Integer endColumn;
        @CheckForNull
        private String title;
        @CheckForNull
        private String rawDetails;
        private ChecksAnnotation.ChecksAnnotationLevel annotationLevel = ChecksAnnotation.ChecksAnnotationLevel.WARNING;

        @DataBoundConstructor
        public StepChecksAnnotation(String path, int startLine, int endLine, String message) {
            this.path = path;
            this.startLine = startLine;
            this.endLine = endLine;
            this.message = message;
        }

        @DataBoundSetter
        public void setStartColumn(Integer startColumn) {
            this.startColumn = startColumn;
        }

        @DataBoundSetter
        public void setEndColumn(Integer endColumn) {
            this.endColumn = endColumn;
        }

        @DataBoundSetter
        public void setTitle(String title) {
            this.title = title;
        }

        @DataBoundSetter
        public void setRawDetails(String rawDetails) {
            this.rawDetails = rawDetails;
        }

        @DataBoundSetter
        public void setAnnotationLevel(ChecksAnnotation.ChecksAnnotationLevel annotationLevel) {
            this.annotationLevel = annotationLevel;
        }

        public String getPath() {
            return this.path;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public String getMessage() {
            return this.message;
        }

        @CheckForNull
        public Integer getStartColumn() {
            return this.startColumn;
        }

        @CheckForNull
        public Integer getEndColumn() {
            return this.endColumn;
        }

        @CheckForNull
        public String getTitle() {
            return this.title;
        }

        @CheckForNull
        public String getRawDetails() {
            return this.rawDetails;
        }

        public ChecksAnnotation.ChecksAnnotationLevel getAnnotationLevel() {
            return this.annotationLevel;
        }

        public ChecksAnnotation getAnnotation() {
            ChecksAnnotation.ChecksAnnotationBuilder builder = new ChecksAnnotation.ChecksAnnotationBuilder().withPath(this.path).withStartLine(this.startLine).withEndLine(this.endLine).withMessage(this.message).withAnnotationLevel(this.annotationLevel);
            if (this.startColumn != null) {
                builder.withStartColumn(this.startColumn);
            }
            if (this.endColumn != null) {
                builder.withEndColumn(this.endColumn);
            }
            if (this.title != null) {
                builder.withTitle(this.title);
            }
            if (this.rawDetails != null) {
                builder.withRawDetails(this.rawDetails);
            }
            return builder.build();
        }

        @Extension
        public static class StepChecksAnnotationDescriptor
        extends Descriptor<StepChecksAnnotation> {
            private final StepUtils utils = new StepUtils();

            public ListBoxModel doFillAnnotationLevelItems() {
                return this.utils.asListBoxModel((Enum[])Arrays.stream(ChecksAnnotation.ChecksAnnotationLevel.values()).filter(v -> v != ChecksAnnotation.ChecksAnnotationLevel.NONE).toArray(Enum[]::new));
            }
        }
    }

    static class PublishChecksStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final PublishChecksStep step;

        PublishChecksStepExecution(StepContext context, PublishChecksStep step) {
            super(context);
            this.step = step;
        }

        protected Void run() throws IOException, InterruptedException {
            ChecksPublisherFactory.fromRun((Run)this.getContext().get(Run.class), (TaskListener)this.getContext().get(TaskListener.class)).publish(this.extractChecksDetails());
            return null;
        }

        @VisibleForTesting
        ChecksDetails extractChecksDetails() throws IOException, InterruptedException {
            String checksName = (String)StringUtils.defaultIfEmpty((CharSequence)this.step.getName(), (CharSequence)Optional.ofNullable((ChecksInfo)this.getContext().get(ChecksInfo.class)).map(ChecksInfo::getName).orElse(""));
            return new ChecksDetails.ChecksDetailsBuilder().withName(checksName).withStatus(this.step.getStatus()).withConclusion(this.step.getConclusion()).withDetailsURL(this.step.getDetailsURL()).withOutput(new ChecksOutput.ChecksOutputBuilder().withTitle(this.step.getTitle()).withSummary(this.step.getSummary()).withText(this.step.getText()).withAnnotations(this.step.getAnnotations().stream().map(StepChecksAnnotation::getAnnotation).collect(Collectors.toList())).build()).withActions(this.step.getActions().stream().map(StepChecksAction::getAction).collect(Collectors.toList())).build();
        }
    }

    @Extension
    public static class PublishChecksStepDescriptor
    extends StepDescriptor {
        private final StepUtils utils = new StepUtils();

        public String getFunctionName() {
            return "publishChecks";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Run.class, TaskListener.class)));
        }

        @NonNull
        public String getDisplayName() {
            return "Publish customized checks to SCM platforms";
        }

        public ListBoxModel doFillStatusItems() {
            return this.utils.asListBoxModel(ChecksStatus.values());
        }

        public ListBoxModel doFillConclusionItems() {
            return this.utils.asListBoxModel(ChecksConclusion.values());
        }
    }
}

