/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.steps;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.api.ChecksStatus;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PublishChecksStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name = "";
    private String summary = "";
    private String title = "";
    private String text = "";
    private String detailsURL = "";
    private ChecksStatus status = ChecksStatus.COMPLETED;
    private ChecksConclusion conclusion = ChecksConclusion.SUCCESS;

    @DataBoundConstructor
    public PublishChecksStep() {
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    @DataBoundSetter
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
    }

    @DataBoundSetter
    public void setText(String text) {
        this.text = text;
    }

    @DataBoundSetter
    public void setDetailsURL(String detailsURL) {
        this.detailsURL = detailsURL;
    }

    @DataBoundSetter
    public void setStatus(ChecksStatus status) {
        this.status = status;
    }

    @DataBoundSetter
    public void setConclusion(ChecksConclusion conclusion) {
        this.conclusion = conclusion;
    }

    public String getName() {
        return this.name;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTitle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.title, (CharSequence)this.name);
    }

    public String getText() {
        return this.text;
    }

    public String getDetailsURL() {
        return this.detailsURL;
    }

    public ChecksStatus getStatus() {
        return this.status;
    }

    public ChecksConclusion getConclusion() {
        return this.conclusion;
    }

    public StepExecution start(StepContext stepContext) {
        return new PublishChecksStepExecution(stepContext, this);
    }

    static class PublishChecksStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final PublishChecksStep step;

        PublishChecksStepExecution(StepContext context, PublishChecksStep step) {
            super(context);
            this.step = step;
        }

        protected Void run() throws IOException, InterruptedException {
            ChecksPublisherFactory.fromRun((Run)this.getContext().get(Run.class), (TaskListener)this.getContext().get(TaskListener.class)).publish(this.extractChecksDetails());
            return null;
        }

        @VisibleForTesting
        ChecksDetails extractChecksDetails() {
            return new ChecksDetails.ChecksDetailsBuilder().withName(this.step.getName()).withStatus(this.step.getStatus()).withConclusion(this.step.getConclusion()).withDetailsURL(this.step.getDetailsURL()).withOutput(new ChecksOutput.ChecksOutputBuilder().withTitle(this.step.getTitle()).withSummary(this.step.getSummary()).withText(this.step.getText()).build()).build();
        }
    }

    @Extension
    public static class PublishChecksStepDescriptor
    extends StepDescriptor {
        public String getFunctionName() {
            return "publishChecks";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Run.class, TaskListener.class)));
        }

        @NonNull
        public String getDisplayName() {
            return "Publish customized checks to SCM platforms";
        }

        public ListBoxModel doFillStatusItems() {
            return this.asListBoxModel(ChecksStatus.values());
        }

        public ListBoxModel doFillConclusionItems() {
            return this.asListBoxModel(ChecksConclusion.values());
        }

        private ListBoxModel asListBoxModel(Enum<?> ... enums) {
            return Arrays.stream(enums).map(Enum::name).map(name -> new ListBoxModel.Option(this.asDisplayName((String)name), name)).collect(Collectors.toCollection(ListBoxModel::new));
        }

        private String asDisplayName(String name) {
            return StringUtils.capitalize((String)name.toLowerCase(Locale.ENGLISH).replace("_", " "));
        }
    }
}

