/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.api;

import java.util.Objects;
import java.util.Optional;

public class ChecksAnnotation {
    private final String path;
    private final Integer startLine;
    private final Integer endLine;
    private final ChecksAnnotationLevel annotationLevel;
    private final String message;
    private final Integer startColumn;
    private final Integer endColumn;
    private final String title;
    private final String rawDetails;

    private ChecksAnnotation(String path, Integer startLine, Integer endLine, ChecksAnnotationLevel annotationLevel, String message, Integer startColumn, Integer endColumn, String title, String rawDetails) {
        this.path = path;
        this.startLine = startLine;
        this.endLine = endLine;
        this.annotationLevel = annotationLevel;
        this.message = message;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        this.title = title;
        this.rawDetails = rawDetails;
    }

    public ChecksAnnotation(ChecksAnnotation that) {
        this(that.getPath().orElse(null), that.getStartLine().orElse(null), that.getEndLine().orElse(null), that.getAnnotationLevel(), that.getMessage().orElse(null), that.getStartColumn().orElse(null), that.getEndColumn().orElse(null), that.getTitle().orElse(null), that.getRawDetails().orElse(null));
    }

    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    public Optional<Integer> getStartLine() {
        return Optional.ofNullable(this.startLine);
    }

    public Optional<Integer> getEndLine() {
        return Optional.ofNullable(this.endLine);
    }

    public ChecksAnnotationLevel getAnnotationLevel() {
        return this.annotationLevel;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public Optional<Integer> getStartColumn() {
        return Optional.ofNullable(this.startColumn);
    }

    public Optional<Integer> getEndColumn() {
        return Optional.ofNullable(this.endColumn);
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<String> getRawDetails() {
        return Optional.ofNullable(this.rawDetails);
    }

    public String toString() {
        return "ChecksAnnotation{path='" + this.path + '\'' + ", startLine=" + this.startLine + ", endLine=" + this.endLine + ", annotationLevel=" + (Object)((Object)this.annotationLevel) + ", message='" + this.message + '\'' + ", startColumn=" + this.startColumn + ", endColumn=" + this.endColumn + ", title='" + this.title + '\'' + ", rawDetails='" + this.rawDetails + '\'' + '}';
    }

    public static class ChecksAnnotationBuilder {
        private String path;
        private Integer startLine;
        private Integer endLine;
        private ChecksAnnotationLevel annotationLevel = ChecksAnnotationLevel.NONE;
        private String message;
        private Integer startColumn;
        private Integer endColumn;
        private String title;
        private String rawDetails;

        public ChecksAnnotationBuilder withPath(String path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public ChecksAnnotationBuilder withLine(int line) {
            this.withStartLine(line);
            this.withEndLine(line);
            return this;
        }

        public ChecksAnnotationBuilder withStartLine(Integer startLine) {
            this.startLine = Objects.requireNonNull(startLine);
            return this;
        }

        public ChecksAnnotationBuilder withEndLine(Integer endLine) {
            this.endLine = Objects.requireNonNull(endLine);
            return this;
        }

        public ChecksAnnotationBuilder withAnnotationLevel(ChecksAnnotationLevel level) {
            this.annotationLevel = Objects.requireNonNull(level);
            return this;
        }

        public ChecksAnnotationBuilder withMessage(String message) {
            this.message = Objects.requireNonNull(message);
            return this;
        }

        public ChecksAnnotationBuilder withStartColumn(Integer startColumn) {
            this.startColumn = Objects.requireNonNull(startColumn);
            return this;
        }

        public ChecksAnnotationBuilder withEndColumn(Integer endColumn) {
            this.endColumn = Objects.requireNonNull(endColumn);
            return this;
        }

        public ChecksAnnotationBuilder withTitle(String title) {
            this.title = Objects.requireNonNull(title);
            return this;
        }

        public ChecksAnnotationBuilder withRawDetails(String rawDetails) {
            this.rawDetails = Objects.requireNonNull(rawDetails);
            return this;
        }

        public ChecksAnnotation build() {
            return new ChecksAnnotation(this.path, this.startLine, this.endLine, this.annotationLevel, this.message, this.startColumn, this.endColumn, this.title, this.rawDetails);
        }
    }

    public static enum ChecksAnnotationLevel {
        NONE,
        NOTICE,
        WARNING,
        FAILURE;

    }
}

