/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.chaosmonkey;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Queue;
import hudson.model.RootAction;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.io.output.NullOutputStream;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ChaosMonkeyAction
implements RootAction {
    private static final List<Event> events = new ArrayList<Event>();

    @CheckForNull
    public String getIconFileName() {
        return "/plugin/chaos-monkey/images/fire.svg";
    }

    @CheckForNull
    public String getDisplayName() {
        return "Chaos Monkey";
    }

    @CheckForNull
    public String getUrlName() {
        return "chaos";
    }

    @RequirePOST
    public void doLockTheQueue(@QueryParameter int duration, StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Event event = new Event(Event.Type.LOAD, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")), duration);
        events.add(event);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(Queue.wrapWithLock(() -> {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                event.setDone();
            }
        }));
        response.forwardToPreviousPage(request);
    }

    @RequirePOST
    public void doGenerateLoad(@QueryParameter int duration, StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        int threadNumber = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(threadNumber);
        Event event = new Event(Event.Type.LOCK, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")), duration);
        events.add(event);
        CyclicBarrier barrier = new CyclicBarrier(threadNumber, () -> event.setDone());
        for (int i = 0; i < threadNumber; ++i) {
            executorService.submit(() -> NullOutputStream.NULL_OUTPUT_STREAM.write(ChaosMonkeyAction.generateLoad(duration, barrier)));
        }
        response.forwardToPreviousPage(request);
    }

    @RequirePOST
    public void doGenerateMemoryLeak(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Event event = new Event(Event.Type.LEAK_START, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")), -1);
        events.add(event);
        MemoryLeaker.INSTANCE.startLeak();
        response.forwardToPreviousPage(request);
    }

    @RequirePOST
    public void doStopMemoryLeak(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Event event = new Event(Event.Type.LEAK_END, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")), -1);
        events.add(event);
        MemoryLeaker.INSTANCE.endLeak();
        response.forwardToPreviousPage(request);
    }

    private static int generateLoad(int duration, CyclicBarrier barrier) {
        long startTime = System.currentTimeMillis();
        int count = 0;
        while (System.currentTimeMillis() - startTime < (long)duration) {
            ++count;
        }
        try {
            barrier.await();
        }
        catch (InterruptedException | BrokenBarrierException exception) {
            // empty catch block
        }
        return count;
    }

    public List<Event> getEvents() {
        return Collections.unmodifiableList(events);
    }

    private static enum MemoryLeaker {
        INSTANCE;

        private ExecutorService orchestrator;
        private boolean isLeaking;
        private List<BigObject> bigObjects = new ArrayList<BigObject>();

        private void startLeak() {
            if (!this.isLeaking) {
                this.orchestrator = Executors.newSingleThreadExecutor();
                this.orchestrator.submit(() -> {
                    this.isLeaking = true;
                    boolean isInterrupted = false;
                    while (!isInterrupted) {
                        this.bigObjects.add(new BigObject());
                        try {
                            Thread.sleep(100L);
                            NullOutputStream.NULL_OUTPUT_STREAM.write(this.bigObjects.size());
                        }
                        catch (InterruptedException e) {
                            isInterrupted = true;
                        }
                    }
                });
            }
        }

        private void endLeak() {
            if (this.isLeaking) {
                this.orchestrator.shutdownNow();
                this.bigObjects.clear();
                this.isLeaking = false;
            }
        }

        private static class BigObject {
            private byte[] chunk;

            BigObject() {
                Random random = new Random();
                this.chunk = new byte[0x100000];
                random.nextBytes(this.chunk);
            }
        }
    }

    private static class Event {
        private final String startTime;
        private final int duration;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="Read in jelly")
        private boolean done;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="Read in jelly")
        private Type type;

        private Event(Type type, String startTime, int duration) {
            this.type = type;
            this.startTime = startTime;
            this.duration = duration;
        }

        private void setDone() {
            this.done = true;
        }

        private static enum Type {
            LOCK,
            LOAD,
            LEAK_START,
            LEAK_END;

        }
    }
}

