/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.NetStormConnectionManager;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;

public class NetoceanActionResult {
    private String URLConnectionString;
    private String username;
    private final Secret password;
    private static final transient Logger logger = Logger.getLogger(NetoceanActionResult.class.getName());
    private String result;
    private JSONObject resonseReportObj = null;

    public NetoceanActionResult(String URLConnectionString, String username, String password) {
        logger.log(Level.INFO, "inside a netocean constructor..............");
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = StringUtils.isEmpty((String)password) ? null : Secret.fromString((String)password);
    }

    public String getResult() {
        logger.log(Level.INFO, "getting a result..............");
        return "getting a result from netocean";
    }

    public Secret getPassword() {
        return this.password;
    }

    public String activateHPD() {
        try {
            NetStormConnectionManager netStormConnectionManager = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15);
            URL url = new URL(this.URLConnectionString + "/ProductUI/productSummary/NetOceanWebService/restartHPD");
            logger.log(Level.INFO, "startNetstormTest. method called. with arguments for metric  url" + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                logger.log(Level.INFO, "Getting Error code = " + conn.getResponseCode());
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.result = br.readLine();
            logger.log(Level.INFO, "RESPONSE -> " + this.getResult());
            JSONObject resonseObj = null;
            resonseObj = (JSONObject)JSONSerializer.toJSON((Object)this.result);
            System.out.println("resonseObj -- " + resonseObj);
            String status = (String)resonseObj.get("status");
            String result = status + "\n" + (String)resonseObj.get("hpdStatus");
            logger.log(Level.INFO, "status for activating a hpd -> " + result);
            return result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception. IOException -", e);
            return "Error in activating a netocean server";
        }
    }

    public String createService(String service, String urls, String template, String reqData, String resdata, String user) {
        try {
            NetStormConnectionManager netStormConnectionManager = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15);
            JSONObject jsonResponse = null;
            JSONObject jsonRequest1 = new JSONObject();
            jsonRequest1.put("service", (Object)service);
            jsonRequest1.put("url", (Object)urls);
            jsonRequest1.put("template", (Object)template);
            jsonRequest1.put("respData", (Object)resdata);
            jsonRequest1.put("reqData", (Object)reqData);
            jsonRequest1.put("user", (Object)user);
            jsonRequest1.put("host", (Object)"default");
            jsonRequest1.put("contentType", (Object)"");
            jsonRequest1.put("activeStatus", (Object)"yes");
            jsonRequest1.put("duplicate", (Object)"no");
            jsonRequest1.put("regexp", (Object)"");
            jsonRequest1.put("isRtc", (Object)"true");
            jsonRequest1.put("isWsdl", (Object)"false");
            JSONObject jsonRequest = jsonRequest1;
            logger.log(Level.INFO, "json request----- for creation of service>", jsonRequest);
            URL url = new URL(this.URLConnectionString + "/ProductUI/productSummary/NetOceanWebService/addNetoceanService");
            logger.log(Level.INFO, "creating a service url for service creation. " + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            String json = jsonRequest.toString();
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed in creation of service : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.resonseReportObj = (JSONObject)JSONSerializer.toJSON((Object)br.readLine());
            logger.log(Level.INFO, "Response for getting Json report   -> " + this.resonseReportObj);
            jsonResponse = (JSONObject)JSONSerializer.toJSON((Object)this.resonseReportObj);
            logger.log(Level.INFO, "Response for getting Json report   -> " + jsonResponse);
            Boolean status = (Boolean)jsonResponse.get("status");
            if (status.booleanValue()) {
                return "Service created successfully.";
            }
            return "Error in creating a service.";
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception. IOException -", e);
            return "Error in creating a Service.";
        }
    }

    public String enableService(String service, String enableUrl, String user) {
        try {
            NetStormConnectionManager netStormConnectionManager = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15);
            String enableUrlinfo = "?services=" + service + "&enableUrl=" + enableUrl + "&user=" + user;
            URL url = new URL(this.URLConnectionString + "/ProductUI/productSummary/NetOceanWebService/enableServices" + enableUrlinfo);
            logger.log(Level.INFO, "enableUrl. method called. with arguments for metric  url" + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                logger.log(Level.INFO, "Getting Error code = " + conn.getResponseCode());
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.result = br.readLine();
            logger.log(Level.INFO, "RESPONSE -> " + this.getResult());
            JSONObject resonseObj = null;
            resonseObj = (JSONObject)JSONSerializer.toJSON((Object)this.result);
            System.out.println("resonseObj getting response-- " + resonseObj);
            String status = (String)resonseObj.get("status");
            logger.log(Level.INFO, "status for enabling a service-> " + status);
            return status;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception. IOException -", e);
            return "Error in enable a service.";
        }
    }

    public String disableService(String service, String disableUrl, String user) {
        try {
            NetStormConnectionManager netStormConnectionManager = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15);
            String disableUrlInfo = "?services=" + service + "&disableUrl=" + disableUrl + "&user=" + user;
            URL url = new URL(this.URLConnectionString + "/ProductUI/productSummary/NetOceanWebService/disableServices" + disableUrlInfo);
            logger.log(Level.INFO, "disableUrl. method called. with arguments for metric  url" + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                logger.log(Level.INFO, "Getting Error code = " + conn.getResponseCode());
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String result = br.readLine();
            logger.log(Level.INFO, "RESPONSE -> " + result);
            JSONObject resonseObj = null;
            resonseObj = (JSONObject)JSONSerializer.toJSON((Object)result);
            System.out.println("resonseObj getting response-- " + resonseObj);
            String status = (String)resonseObj.get("status");
            logger.log(Level.INFO, "status for disabling a service-> " + status);
            return "service disable successfully.";
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception. IOException -", e);
            return "Error in disable a service.";
        }
    }

    public String deleteService(String service) {
        try {
            NetStormConnectionManager netStormConnectionManager = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15);
            String disableUrlInfo = "?host=default&deleteServices=" + service;
            URL url = new URL(this.URLConnectionString + "/ProductUI/productSummary/NetOceanWebService/deleteService" + disableUrlInfo);
            logger.log(Level.INFO, "disableUrl. method called. with arguments for metric  url" + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                logger.log(Level.INFO, "Getting Error code = " + conn.getResponseCode());
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.result = br.readLine();
            logger.log(Level.INFO, "RESPONSE -> " + this.getResult());
            JSONObject resonseObj = null;
            resonseObj = (JSONObject)JSONSerializer.toJSON((Object)this.result);
            System.out.println("resonseObj getting response-- " + resonseObj);
            String status = (String)resonseObj.get("status");
            logger.log(Level.INFO, "status for deleting a service-> " + status);
            return status;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception. IOException -", e);
            return "Error in delete a service.";
        }
    }

    public String exportNetoceanService(String tarName, String services) {
        try {
            NetStormConnectionManager netStormConnectionManager = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15);
            String exportUrlInfo = "?tarName=" + tarName + "&serviceName=" + services;
            URL url = new URL(this.URLConnectionString + "/ProductUI/productSummary/NetOceanWebService/exportService" + exportUrlInfo);
            logger.log(Level.INFO, "export service. method called. with arguments for metric  url" + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                logger.log(Level.INFO, "Getting Error code = " + conn.getResponseCode());
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.result = br.readLine();
            logger.log(Level.INFO, "RESPONSE -> " + this.getResult());
            JSONObject resonseObj = null;
            resonseObj = (JSONObject)JSONSerializer.toJSON((Object)this.result);
            System.out.println("resonseObj getting response-- " + resonseObj);
            String status = (String)resonseObj.get("msg");
            logger.log(Level.INFO, "status for deleting a service-> " + status);
            return status;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception. IOException -", e);
            return "Error in importing a service.";
        }
    }

    public String copyExportJar(String hostIp, String filepath, String directory, String isExport) {
        try {
            NetStormConnectionManager netStormConnectionManager = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15);
            String filePath = "";
            filePath = isExport.equals("true") ? "$NS_WDIR/webapps/" + filepath : "/tmp/" + filepath;
            JSONObject jsonResponse = null;
            JSONObject jsonRequest = new JSONObject();
            jsonRequest.put("IP", (Object)hostIp);
            jsonRequest.put("path", (Object)filePath);
            jsonRequest.put("dir", (Object)directory);
            URL url = new URL(this.URLConnectionString + "/ProductUI/productSummary/NetOceanWebService/nsuServerAdmin");
            logger.log(Level.INFO, "creating a service url for service creation. " + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            String json = jsonRequest.toString();
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed in Exporting a service : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.resonseReportObj = (JSONObject)JSONSerializer.toJSON((Object)br.readLine());
            logger.log(Level.INFO, "Response for getting Json service   -> " + this.resonseReportObj);
            jsonResponse = (JSONObject)JSONSerializer.toJSON((Object)this.resonseReportObj);
            logger.log(Level.INFO, "Response for getting Json report   -> " + jsonResponse);
            String status = (String)jsonResponse.get("status");
            return status;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception. IOException -", e);
            return "Error in exporting a service tar.";
        }
    }

    public String importServices(String tarName) {
        try {
            NetStormConnectionManager netStormConnectionManager = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15);
            String importurlInfo = "?tarName=" + tarName;
            URL url = new URL(this.URLConnectionString + "/ProductUI/productSummary/NetOceanWebService/importFileForJenkins" + importurlInfo);
            logger.log(Level.INFO, "importUrl. method called. with arguments for metric  url" + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                logger.log(Level.INFO, "Getting Error code = " + conn.getResponseCode());
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.result = br.readLine();
            logger.log(Level.INFO, "RESPONSE -> " + this.getResult());
            JSONObject resonseObj = null;
            resonseObj = (JSONObject)JSONSerializer.toJSON((Object)this.result);
            System.out.println("resonseObj getting response-- " + resonseObj);
            String status = (String)resonseObj.get("status");
            logger.log(Level.INFO, "status for importing a service-> " + status);
            return status;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception. IOException -", e);
            return "Error in importing a services.";
        }
    }

    public String applyRtc(String cmdArgs, String isTemp, String level, String service) {
        try {
            NetStormConnectionManager netStormConnectionManager = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15);
            JSONObject jsonResponse = null;
            JSONObject jsonRequest = new JSONObject();
            jsonRequest.put("cmdArgs", (Object)cmdArgs);
            jsonRequest.put("isTemp", (Object)isTemp);
            jsonRequest.put("level", (Object)level);
            jsonRequest.put("service", (Object)service);
            URL url = new URL(this.URLConnectionString + "/ProductUI/productSummary/NetOceanWebService/applyRTC");
            logger.log(Level.INFO, "creating a service url for apply RTC. " + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            String json = jsonRequest.toString();
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed in Exporting a service : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.resonseReportObj = (JSONObject)JSONSerializer.toJSON((Object)br.readLine());
            logger.log(Level.INFO, "Response for getting Json service   -> " + this.resonseReportObj);
            jsonResponse = (JSONObject)JSONSerializer.toJSON((Object)this.resonseReportObj);
            logger.log(Level.INFO, "Response for getting Json report   -> " + jsonResponse);
            String status = (String)jsonResponse.get("status");
            return status;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception. IOException -", e);
            return "Error in apply RTC.";
        }
    }
}

