/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.NSNDIntegrationConnectionManager;
import com.cavisson.jenkins.NdConnectionManager;
import com.cavisson.jenkins.NetStormConnectionManager;
import com.cavisson.jenkins.NetStormReport;
import hudson.FilePath;
import hudson.model.Run;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetStormDataCollector {
    private static final Logger LOG = Logger.getLogger(NetStormDataCollector.class.getName());
    private static final String[] METRIC_PATHS = new String[]{"Transactions Started/Second", "Transactions Completed/Second", "Transactions Successful/Second", "Average Transaction Response Time (Secs)", "Transactions Completed", "Transactions Success"};
    private static final int[] graphId = new int[]{7, 8, 9, 3, 5, 6};
    private static final int[] groupId = new int[]{6, 6, 6, 6, 6, 6};
    private final NdConnectionManager ndConnection;
    private final NetStormConnectionManager connection;
    private final NSNDIntegrationConnectionManager nsNdConnection;
    private final Run<?, ?> build;
    private final int TEST_RUN;
    private final String TEST_MODE;
    private String test_cycle_number = "";
    private boolean isNDE = false;
    private boolean isIntegrated = false;
    private String duration;

    public NetStormDataCollector(NetStormConnectionManager connection, Run build, int TestRun, String testMode, String testCycleNumber) {
        this.connection = connection;
        this.build = build;
        this.TEST_RUN = TestRun;
        this.TEST_MODE = testMode;
        this.ndConnection = null;
        this.nsNdConnection = null;
        this.test_cycle_number = testCycleNumber;
    }

    public NetStormDataCollector(NdConnectionManager connection, Run<?, ?> build, int TestRun, String testMode, boolean isCM, String duration) {
        this.ndConnection = connection;
        this.build = build;
        this.TEST_RUN = TestRun;
        this.TEST_MODE = testMode;
        this.isNDE = isCM;
        this.connection = null;
        this.duration = duration;
        this.nsNdConnection = null;
    }

    public NetStormDataCollector(NSNDIntegrationConnectionManager connection, Run build, int TestRun, String testMode, boolean isIntegrated, String duration) {
        this.connection = null;
        this.ndConnection = null;
        this.nsNdConnection = connection;
        this.build = build;
        this.TEST_RUN = TestRun;
        this.TEST_MODE = testMode;
        this.duration = duration;
        this.isIntegrated = isIntegrated;
    }

    public static String[] getAvailableMetricPaths() {
        return METRIC_PATHS;
    }

    public NetStormReport createReportFromMeasurements(PrintStream logger, FilePath fp) throws Exception {
        long buildStartTime = this.build.getTimeInMillis();
        String durationInMinutes = this.calculateDurationToFetch(buildStartTime, System.currentTimeMillis());
        boolean status = false;
        try {
            NetStormReport adReport = null;
            if (!this.isNDE && !this.isIntegrated) {
                LOG.log(Level.INFO, "Inside for generating a netstrom test  = ");
                adReport = new NetStormReport(buildStartTime, durationInMinutes);
                status = this.connection.fetchMetricData(this.connection, METRIC_PATHS, durationInMinutes + "", groupId, graphId, this.TEST_RUN, this.TEST_MODE, logger, this.test_cycle_number, this.build);
            } else if (this.isIntegrated && !this.isNDE) {
                System.out.println("test run  -- " + this.TEST_RUN);
                durationInMinutes = this.duration;
                adReport = new NetStormReport(buildStartTime, durationInMinutes);
                adReport.setIsIntegrated(this.isIntegrated);
                status = this.nsNdConnection.fetchMetricData(this.nsNdConnection, METRIC_PATHS, durationInMinutes, groupId, graphId, this.TEST_RUN, this.TEST_MODE, fp);
            } else {
                durationInMinutes = this.duration;
                adReport = new NetStormReport(buildStartTime, durationInMinutes, this.isNDE);
            }
            return adReport;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "exception in createReportFromMeasurements", e);
            throw e;
        }
    }

    private String calculateDurationToFetch(Long testStartTime, Long testEndTime) {
        long duration = testEndTime - testStartTime;
        long seconds = duration / 1000L;
        long s = seconds % 60L;
        long m = seconds / 60L % 60L;
        long h = seconds / 3600L % 24L;
        return String.format("%d:%02d:%02d", h, m, s);
    }
}

