/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.FieldValidator;
import com.cavisson.jenkins.Messages;
import com.cavisson.jenkins.NetStormConnectionManager;
import com.cavisson.jenkins.NetStormStopAction;
import com.cavisson.jenkins.NetStormStopThread;
import com.cavisson.jenkins.ParameterDTO;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class NetStormBuilder
extends Builder
implements SimpleBuildStep {
    private final String project;
    private final String subProject;
    private final String scenario;
    private final String URLConnectionString;
    private final String username;
    private final Secret password;
    private final String testMode;
    private final String defaultTestMode = "true";
    private static final transient Logger logger = Logger.getLogger(NetStormBuilder.class.getName());
    private final String baselineType;
    private final String pollInterval;
    public static String testRunNumber = "-1";
    public static String testCycleNumber = "";
    private static final String fileName = "jenkins_check_rule_for_NS.txt";
    private String protocol = "";
    private String repoIp = "";
    private String repoPort = "";
    private String repoPath = "";
    private String repoUsername = "";
    private String repoPassword = "";
    private String gitPull = "";
    String uploadFileName = "";
    private String profile = "";
    private String script = "";
    private String page = "";
    private String advanceSett = "";
    private String urlHeader = "";
    private String hiddenBox = "";
    private String testProfileBox = "";
    private final boolean generateReport;
    Map<String, String> envVarMap = null;
    private boolean doNotWaitForTestCompletion = false;
    private String totalusers = "";
    private String rampUpSec = "";
    private String rampupmin = "";
    private String rampuphour = "";
    private String duration = "";
    private String serverhost = "";
    private String sla = "";
    private String testName = "";
    private String scriptPath = "";
    private String rampupDuration = "";
    private String emailid = "";
    private String emailidCC = "";
    private String emailidBcc = "";
    private String testsuite = "";
    private String dataDir = "";
    private String checkRuleFileUpload = "";
    private boolean fileUpload = false;
    NetStormConnectionManager netstormConnectionManger = null;
    List<String> testsuiteList = new ArrayList<String>();
    HashMap<String, ParameterDTO> testsuiteParameterMap = new HashMap();

    public NetStormBuilder(String URLConnectionString, String username, String password, String project, String subProject, String scenario, String testMode, String baselineType, String pollInterval, String protocol, String repoIp, String repoPort, String repoPath, String repoUsername, String repoPassword, String profile, String script, String page, String advanceSett, String urlHeader, String hiddenBox, String gitPull, boolean generateReport, String testProfileBox) {
        logger.log(Level.INFO, "inside a constructor..............gitpull -" + gitPull);
        logger.log(Level.INFO, "profile -" + profile + ", advanceSett -" + advanceSett + ", urlHeader -" + urlHeader + ", hiddenBox -" + hiddenBox + ", testProfileBox -" + testProfileBox);
        this.project = project;
        this.subProject = subProject;
        this.scenario = scenario;
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = StringUtils.isEmpty((String)password) ? null : Secret.fromString((String)password);
        this.testMode = testMode;
        this.baselineType = baselineType;
        this.pollInterval = pollInterval;
        this.protocol = protocol;
        this.repoIp = repoIp;
        this.repoPort = repoPort;
        this.repoPath = repoPath;
        this.repoUsername = repoUsername;
        this.repoPassword = repoPassword;
        this.profile = profile;
        this.gitPull = gitPull;
        this.script = script;
        this.page = page;
        this.advanceSett = advanceSett;
        this.urlHeader = urlHeader;
        this.hiddenBox = hiddenBox;
        this.testProfileBox = testProfileBox;
        this.generateReport = generateReport;
        logger.log(Level.INFO, "hiddenBox -" + this.hiddenBox + ", testmode =" + testMode + "testProfileBox -" + this.testProfileBox);
    }

    public NetStormBuilder(String URLConnectionString, String username, String password, String project, String subProject, String scenario, String testMode, String baselineType, String pollInterval, String protocol, String repoIp, String repoPort, String repoPath, String repoUsername, String repoPassword, String profile, String script, String page, String advanceSett, String urlHeader, String hiddenBox, String gitPull, boolean generateReport, Map<String, String> envVarMap, boolean doNotWaitForTestCompletion, String testProfileBox) {
        logger.log(Level.INFO, "inside a constructor..............gitpull -" + gitPull);
        logger.log(Level.INFO, "profile -" + profile + ", advanceSett -" + advanceSett + ", urlHeader -" + urlHeader + ", hiddenBox -" + hiddenBox + ", testProfileBox -" + testProfileBox);
        this.project = project;
        this.subProject = subProject;
        this.scenario = scenario;
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = StringUtils.isEmpty((String)password) ? null : Secret.fromString((String)password);
        this.testMode = testMode;
        this.baselineType = baselineType;
        this.pollInterval = pollInterval;
        this.protocol = protocol;
        this.repoIp = repoIp;
        this.repoPort = repoPort;
        this.repoPath = repoPath;
        this.repoUsername = repoUsername;
        this.repoPassword = repoPassword;
        this.profile = profile;
        this.gitPull = gitPull;
        this.script = script;
        this.page = page;
        this.advanceSett = advanceSett;
        this.urlHeader = urlHeader;
        this.hiddenBox = hiddenBox;
        this.testProfileBox = testProfileBox;
        this.generateReport = generateReport;
        this.envVarMap = envVarMap;
        this.doNotWaitForTestCompletion = doNotWaitForTestCompletion;
        logger.log(Level.INFO, "hiddenBox -" + this.hiddenBox + ", testmode =" + testMode + ", doNotWaitForTestCompletion = " + doNotWaitForTestCompletion + "testProfileBox -" + this.testProfileBox);
    }

    @DataBoundConstructor
    public NetStormBuilder(String URLConnectionString, String username, String password, String project, String subProject, String scenario, String testMode, String baselineType, String pollInterval, String protocol, String repoIp, String repoPort, String repoPath, String repoUsername, String repoPassword, String profile, String script, String page, String advanceSett, String urlHeader, String hiddenBox, String gitPull, boolean generateReport, boolean doNotWaitForTestCompletion, String totalusers, String rampUpSec, String rampupmin, String rampuphour, String duration, String serverhost, String sla, String testName, String scriptPath, String rampupDuration, String emailid, String emailidCC, String emailidBcc, String testsuite, String dataDir, String checkRuleFileUpload) {
        this.project = project;
        this.subProject = subProject;
        this.scenario = scenario;
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = StringUtils.isEmpty((String)password) ? null : Secret.fromString((String)password);
        this.testMode = testMode;
        this.baselineType = baselineType;
        this.pollInterval = pollInterval;
        this.protocol = protocol;
        this.repoIp = repoIp;
        this.repoPort = repoPort;
        this.repoPath = repoPath;
        this.repoUsername = repoUsername;
        this.repoPassword = repoPassword;
        this.profile = profile;
        this.gitPull = gitPull;
        this.script = script;
        this.page = page;
        this.advanceSett = advanceSett;
        this.urlHeader = urlHeader;
        this.hiddenBox = hiddenBox;
        this.generateReport = generateReport;
        this.doNotWaitForTestCompletion = doNotWaitForTestCompletion;
        this.totalusers = totalusers;
        this.rampUpSec = rampUpSec;
        this.rampupmin = rampupmin;
        this.rampuphour = rampuphour;
        this.duration = duration;
        this.serverhost = serverhost;
        this.sla = sla;
        this.testName = testName;
        this.scriptPath = scriptPath;
        this.rampupDuration = rampupDuration;
        this.emailid = emailid;
        this.emailidCC = emailidCC;
        this.emailidBcc = emailidBcc;
        this.testsuite = testsuite;
        this.dataDir = dataDir;
        this.checkRuleFileUpload = checkRuleFileUpload;
        this.setParametersValue();
        logger.log(Level.INFO, "hiddenBox -" + this.hiddenBox + ", testmode =" + testMode + ", doNotWaitForTestCompletion = " + doNotWaitForTestCompletion);
    }

    public NetStormBuilder(String URLConnectionString, String username, String password, String project, String subProject, String scenario, String testMode, String baselineType, String pollInterval, String profile, boolean generateReport) {
        logger.log(Level.INFO, "inside second constructor..............");
        this.project = project;
        this.subProject = subProject;
        this.scenario = scenario;
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = StringUtils.isEmpty((String)password) ? null : Secret.fromString((String)password);
        this.testMode = testMode;
        this.baselineType = baselineType;
        this.pollInterval = pollInterval;
        this.profile = profile;
        this.generateReport = generateReport;
    }

    public String getProject() {
        return this.project;
    }

    public String getDefaultTestMode() {
        return "true";
    }

    public String getSubProject() {
        return this.subProject;
    }

    public String getScenario() {
        return this.scenario;
    }

    public String getURLConnectionString() {
        return this.URLConnectionString;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getTestMode() {
        return this.testMode;
    }

    public String getBaselineType() {
        return this.baselineType;
    }

    public String getPollInterval() {
        return this.pollInterval;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRepoIp() {
        return this.repoIp;
    }

    public String getRepoPort() {
        return this.repoPort;
    }

    public String getRepoPath() {
        return this.repoPath;
    }

    public String getRepoUsername() {
        return this.repoUsername;
    }

    public String getRepoPassword() {
        return this.repoPassword;
    }

    public String getGitPull() {
        return this.gitPull;
    }

    public void setGitPull(String gitPull) {
        this.gitPull = gitPull;
    }

    public String getAdvanceSett() {
        return this.advanceSett;
    }

    public void setAdvanceSett(String advanceSett) {
        this.advanceSett = advanceSett;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getUrlHeader() {
        return this.urlHeader;
    }

    public void setUrlHeader(String urlHeader) {
        this.urlHeader = urlHeader;
    }

    public String getHiddenBox() {
        return this.hiddenBox;
    }

    public void setHiddenBox(String hiddenBox) {
        this.hiddenBox = hiddenBox;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public boolean isGenerateReport() {
        return this.generateReport;
    }

    public boolean isDoNotWaitForTestCompletion() {
        return this.doNotWaitForTestCompletion;
    }

    public void setDoNotWaitForTestCompletion(boolean doNotWaitForTestCompletion) {
        this.doNotWaitForTestCompletion = doNotWaitForTestCompletion;
    }

    public Map<String, String> getEnvVarMap() {
        return this.envVarMap;
    }

    public String getTotalusers() {
        return this.totalusers;
    }

    public void setTotalusers(String totalusers) {
        this.totalusers = totalusers;
    }

    public String getRampupsec() {
        return this.rampUpSec;
    }

    public void setRampupsec(String rampupsec) {
        this.rampUpSec = rampupsec;
    }

    public String getRampupmin() {
        return this.rampupmin;
    }

    public void setRampupmin(String rampupmin) {
        this.rampupmin = rampupmin;
    }

    public String getRampuphour() {
        return this.rampuphour;
    }

    public void setRampuphour(String rampuphour) {
        this.rampuphour = rampuphour;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getServerhost() {
        return this.serverhost;
    }

    public void setServerhost(String serverhost) {
        this.serverhost = serverhost;
    }

    public String getSla() {
        return this.sla;
    }

    public void setSla(String sla) {
        this.sla = sla;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getRampupDuration() {
        return this.rampupDuration;
    }

    public void setRampupDuration(String rampupDuration) {
        this.rampupDuration = rampupDuration;
    }

    public String getEmailidTo() {
        return this.emailid;
    }

    public void setEmailidTo(String emailidTo) {
        this.emailid = emailidTo;
    }

    public String getEmailIdCC() {
        return this.emailidCC;
    }

    public void setEmailIdCC(String emailIdCC) {
        this.emailidCC = emailIdCC;
    }

    public String getEmailIdBcc() {
        return this.emailidBcc;
    }

    public void setEmailIdBcc(String emailIdBcc) {
        this.emailidBcc = emailIdBcc;
    }

    public String getTestsuite() {
        return this.testsuite;
    }

    public void setTestsuite(String testsuite) {
        this.testsuite = testsuite;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getCheckRuleFileUpload() {
        return this.checkRuleFileUpload;
    }

    public void setCheckRuleFileUpload(String checkRuleFileUpload) {
        this.checkRuleFileUpload = checkRuleFileUpload;
    }

    public void perform(Run<?, ?> run, FilePath fp, Launcher lnchr, TaskListener taskListener) throws InterruptedException, IOException {
        run.addAction((Action)new NetStormStopAction(run));
        run.addAction((Action)new NetStormStopThread(run));
        Boolean fileUpload = false;
        boolean uploadNCDataFile = false;
        String scriptName = "";
        if (this.envVarMap == null) {
            this.envVarMap = run instanceof AbstractBuild ? ((AbstractBuild)run).getBuildVariables() : Collections.emptyMap();
        }
        PrintStream logg = taskListener.getLogger();
        StringBuffer errMsg = new StringBuffer();
        logger.log(Level.INFO, "before if check" + this.envVarMap.size());
        Set<String> keyset = this.envVarMap.keySet();
        logger.log(Level.INFO, "key set = " + keyset.size());
        String path = "";
        String jobName = "";
        String automateScripts = "";
        String testsuiteName = "";
        String dataDir = "";
        String serverhost = "";
        if (keyset.size() > 0) {
            this.netstormConnectionManger = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, this.project, this.subProject, this.scenario, this.testMode, this.baselineType, this.pollInterval, this.profile, this.hiddenBox, this.generateReport, this.doNotWaitForTestCompletion, this.gitPull);
        }
        if (this.envVarMap.get("Testsuite") != null) {
            logger.log(Level.INFO, "Test Suite Nameee = " + this.envVarMap.get("Testsuite"));
            testsuiteName = this.envVarMap.get("Testsuite");
            if (!testsuiteName.isEmpty()) {
                logger.log(Level.INFO, "Test Suite Name = " + testsuiteName);
                this.testsuiteList = Arrays.asList(testsuiteName.split("\\s*,\\s*"));
            }
        } else if (!this.testProfileBox.isEmpty()) {
            logger.log(Level.INFO, "testProfileBox = " + this.testProfileBox);
            this.testsuiteList = Arrays.asList(this.testProfileBox.split("\\s*,\\s*"));
        }
        if (keyset.size() > 0 && this.testsuiteList != null) {
            this.testsuiteParameterMap = new HashMap();
            logger.log(Level.INFO, "testsuite size  = " + this.testsuiteList.size());
            if (this.testsuiteList.size() > 1) {
                for (int i = 0; i < this.testsuiteList.size(); ++i) {
                    String suiteName = this.testsuiteList.get(i);
                    String[] prefix = suiteName.split("_");
                    if (prefix.length <= 1) continue;
                    logger.log(Level.INFO, "testsuiteParameterMap = " + this.testsuiteParameterMap);
                    this.testsuiteParameterMap.put(prefix[0], new ParameterDTO());
                }
            } else if (this.testsuiteList.size() == 1) {
                String[] testsuite = testsuiteName.split("/");
                if (testsuite.length == 3) {
                    this.netstormConnectionManger.setProject(testsuite[0]);
                    this.netstormConnectionManger.setSubProject(testsuite[1]);
                    this.netstormConnectionManger.setScenario(testsuite[2]);
                } else {
                    this.netstormConnectionManger.setScenario(testsuiteName);
                }
            }
        }
        for (String keys : keyset) {
            String[] prefix;
            String mail;
            String[] prefix2;
            String[] temp;
            String value = this.envVarMap.get(keys);
            String key = keys;
            if (key.equals("JENKINS_HOME")) {
                path = this.envVarMap.get(key);
            }
            logger.log(Level.INFO, "keys loop = " + key);
            if (key.endsWith("DataDirectory")) {
                logger.log(Level.INFO, "data dir = " + this.envVarMap.get(key));
                dataDir = this.envVarMap.get(key);
                if (this.testsuiteList.size() > 1) {
                    String[] prefix3 = key.split("_");
                    if (prefix3.length > 1) {
                        if (this.testsuiteParameterMap.containsKey(prefix3[0])) {
                            this.testsuiteParameterMap.get(prefix3[0]).setDataDir(dataDir);
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setDataDir(dataDir);
                            }
                        }
                    } else {
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            this.testsuiteParameterMap.get(entry.getKey()).setDataDir(dataDir);
                        }
                    }
                } else if (this.testsuiteList.size() == 1) {
                    this.netstormConnectionManger.setDataDir(dataDir);
                }
            }
            if (key.equals("Override DataDir") && !(dataDir = this.envVarMap.get(key)).equals("")) {
                this.netstormConnectionManger.setDataDir(dataDir);
            }
            if (key.endsWith("Server_Host")) {
                serverhost = this.envVarMap.get(key);
                if (this.testsuiteList.size() > 1) {
                    String[] prefix3 = key.split("_");
                    if (prefix3.length > 1) {
                        if (this.testsuiteParameterMap.containsKey(prefix3[0])) {
                            this.testsuiteParameterMap.get(prefix3[0]).setServerhost(serverhost);
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setServerhost(serverhost);
                            }
                        }
                    } else {
                        for (Map.Entry<String, ParameterDTO> entry3 : this.testsuiteParameterMap.entrySet()) {
                            this.testsuiteParameterMap.get(entry3.getKey()).setServerhost(serverhost);
                        }
                    }
                } else if (this.testsuiteList.size() == 1) {
                    this.netstormConnectionManger.setServerHost(serverhost);
                }
            }
            if (!(value instanceof String)) continue;
            String envValue = value;
            logger.log(Level.INFO, "env value = " + envValue);
            if (key.startsWith("Script Name")) {
                scriptName = envValue;
            }
            this.netstormConnectionManger.addSLAValue("1", "2");
            if (envValue.startsWith("NS_SESSION")) {
                temp = envValue.split("_");
                if (temp.length > 2) {
                    if (this.testsuiteList.size() > 1) {
                        String[] prefix22 = key.split("_");
                        if (prefix22.length > 1) {
                            this.testsuiteParameterMap.get(prefix22[0]).setDuration(temp[2]);
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setDuration(temp[2]);
                    }
                }
            } else if (envValue.startsWith("NS_NUM_USERS")) {
                temp = envValue.split("_");
                if (temp.length > 3) {
                    if (this.testsuiteList.size() > 1) {
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            this.testsuiteParameterMap.get(prefix2[0]).setTotalusers(temp[3]);
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setvUsers(temp[3]);
                    }
                }
            } else if (envValue.startsWith("NS_SERVER_HOST")) {
                temp = envValue.split("_");
                if (temp.length > 3) {
                    if (this.testsuiteList.size() > 1) {
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix2[0])) {
                                this.testsuiteParameterMap.get(prefix2[0]).setServerhost(temp[3]);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    this.testsuiteParameterMap.get(entry.getKey()).setServerhost(temp[3]);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setServerhost(temp[3]);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setServerHost(temp[3]);
                    }
                }
            } else if (envValue.startsWith("NS_SLA_CHANGE")) {
                temp = envValue.split("_");
                if (temp.length > 3) {
                    if (this.testsuiteList.size() > 1) {
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            this.testsuiteParameterMap.get(prefix2[0]).addSLAValue(prefix2[1], temp[3]);
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.addSLAValue(key.toString(), temp[3]);
                    }
                }
            } else if (envValue.startsWith("NS_RAMP_UP_SEC") || envValue.startsWith("NS_RAMP_UP_MIN") || envValue.startsWith("NS_RAMP_UP_HR")) {
                temp = envValue.split("_");
                if (temp.length > 4) {
                    if (this.testsuiteList.size() > 1) {
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            this.testsuiteParameterMap.get(prefix2[0]).setRampUp(temp[4] + "_" + temp[3]);
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setRampUp(temp[4] + "_" + temp[3]);
                    }
                }
            } else if (envValue.startsWith("NS_TNAME")) {
                String tName = this.getSubString(envValue, 2, "_");
                if (!tName.equals("")) {
                    if (this.testsuiteList.size() > 1) {
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            this.testsuiteParameterMap.get(prefix2[0]).setTestName(tName);
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.settName(tName);
                    }
                }
            } else if (envValue.startsWith("NS_AUTOSCRIPT")) {
                temp = envValue.split("_", 3);
                if (temp.length > 2) {
                    automateScripts = automateScripts.equals("") ? temp[2] : automateScripts + "," + temp[2];
                }
            } else if (envValue.startsWith("NS_RAMP_UP_DURATION")) {
                temp = envValue.split("_");
                if (temp.length > 4) {
                    if (this.testsuiteList.size() > 1) {
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            this.testsuiteParameterMap.get(prefix2[0]).setRampupDuration(temp[4]);
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setRampUpDuration(temp[4]);
                    }
                }
            } else if (envValue.startsWith("EMAIL_IDS_TO")) {
                temp = envValue.split("_");
                if (temp.length > 3) {
                    mail = envValue.split("IDS_TO_")[1].replaceAll("\\|", ",");
                    if (this.testsuiteList.size() > 1) {
                        prefix = key.split("_");
                        if (prefix.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                                this.testsuiteParameterMap.get(prefix[0]).setEmailid(mail);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    this.testsuiteParameterMap.get(entry.getKey()).setEmailid(mail);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setEmailid(mail);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setEmailIdTo(mail);
                    }
                }
            } else if (envValue.startsWith("EMAIL_IDS_CC")) {
                temp = envValue.split("_");
                if (temp.length > 3) {
                    mail = envValue.split("IDS_CC_")[1].replaceAll("\\|", ",");
                    if (this.testsuiteList.size() > 1) {
                        prefix = key.split("_");
                        if (prefix.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                                this.testsuiteParameterMap.get(prefix[0]).setEmailidCC(mail);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    this.testsuiteParameterMap.get(entry.getKey()).setEmailidCC(mail);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setEmailidCC(mail);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setEmailIdCc(mail);
                    }
                }
            } else if (envValue.startsWith("EMAIL_IDS_BCC") && (temp = envValue.split("_")).length > 3) {
                mail = envValue.split("IDS_BCC_")[1].replaceAll("\\|", ",");
                if (this.testsuiteList.size() > 1) {
                    prefix = key.split("_");
                    if (prefix.length > 1) {
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            this.testsuiteParameterMap.get(prefix[0]).setEmailidBcc(mail);
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setEmailidBcc(mail);
                            }
                        }
                    } else {
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            this.testsuiteParameterMap.get(entry.getKey()).setEmailidBcc(mail);
                        }
                    }
                } else if (this.testsuiteList.size() == 1) {
                    this.netstormConnectionManger.setEmailIdBcc(mail);
                }
            }
            if (!envValue.equalsIgnoreCase(fileName)) continue;
            fileUpload = true;
        }
        if (!automateScripts.isEmpty()) {
            this.netstormConnectionManger.setAutoScript(automateScripts);
        }
        if (this.testMode == null) {
            logg.println("Please verify configured buit step, test profile mode is not selected.");
            run.setResult(Result.FAILURE);
        }
        if (this.scenario.equals("") || this.scenario == null || this.scenario.equals("---Select Scenarios ---")) {
            if (this.getTestMode().equals("N")) {
                logg.println("Please verify configured build step, scenario is not selected.");
            } else {
                logg.println("Please verify configured build step, Test Suite is not selected.");
            }
            run.setResult(Result.FAILURE);
            return;
        }
        if (this.getTestMode().equals("N")) {
            logg.println("Starting test with scenario(" + this.project + "/" + this.subProject + "/" + this.scenario + ")");
        } else {
            logg.println("Starting test with test suite(" + this.project + "/" + this.subProject + "/" + this.scenario + ")");
        }
        logg.println("NetStorm URI: " + this.URLConnectionString);
        JSONObject json = null;
        if (fileUpload.booleanValue()) {
            json = this.createJsonForFileUpload(fp, logg);
        }
        this.netstormConnectionManger.setJkRule(json);
        if (scriptName != null && !scriptName.equals("")) {
            FilePath file = new FilePath(fp.getChannel(), fp + "/uploadNCDataFiles");
            logger.log(Level.INFO, "File path for uploading data file = " + file);
            if (file.isDirectory()) {
                logger.log(Level.INFO, "List of files = " + file.list());
                if (file.list().size() > 0) {
                    FilePath files = (FilePath)file.list().get(0);
                    this.netstormConnectionManger.updateNCDataFile(files, scriptName, logg);
                } else {
                    logg.println("No Data file is uploaded");
                }
            }
        }
        String destDir = fp + "/TestSuiteReport";
        FilePath direc = new FilePath(fp.getChannel(), destDir);
        if (direc.exists()) {
            direc.deleteRecursive();
        }
        HashMap result = new HashMap();
        if (this.testsuiteList != null && this.testsuiteList.size() > 1) {
            this.netstormConnectionManger.setTestsuitelist(this.testsuiteList);
            this.netstormConnectionManger.setTestsuiteParameterDTO(this.testsuiteParameterMap);
            result = this.netstormConnectionManger.startMultipleTest(errMsg, logg);
        } else {
            result = this.netstormConnectionManger.startNetstormTest(errMsg, logg);
        }
        boolean status = (Boolean)result.get("STATUS");
        logger.log(Level.INFO, "result 11111 = " + result.toString());
        if (this.doNotWaitForTestCompletion) {
            if (result.get("TESTRUN") != null && !result.get("TESTRUN").toString().trim().equals("")) {
                logg.println("Test Run Number - " + result.get("TESTRUN"));
                run.setDisplayName((String)result.get("TESTRUN"));
                run.setResult(Result.SUCCESS);
            }
            return;
        }
        logg.println("Test Run Status - " + status);
        if (result.get("TESTRUN") != null && !result.get("TESTRUN").toString().trim().equals("")) {
            try {
                File file;
                File dir;
                logg.println("Test Run  - " + result.get("TESTRUN"));
                run.setDisplayName((String)result.get("TESTRUN"));
                testRunNumber = (String)result.get("TESTRUN");
                if (this.testMode.equals("T") && (result.get("errMsg") == null || result.get("errMsg").toString().trim().equals(""))) {
                    testCycleNumber = (String)result.get("TEST_CYCLE_NUMBER");
                    if (this.generateReport) {
                        this.netstormConnectionManger.checkTestSuiteStatus(logg, fp, run);
                    }
                }
                if (result.get("ENV_NAME") != null && !result.get("ENV_NAME").toString().trim().equals("")) {
                    run.setDescription((String)result.get("ENV_NAME"));
                }
                if (!(dir = new File(path.trim() + "/Property")).exists()) {
                    if (dir.mkdir()) {
                        System.out.println("Directory is created!");
                    } else {
                        System.out.println("Failed to create directory!");
                    }
                }
                if ((file = new File(path.trim() + "/Property/" + ((String)result.get("TESTRUN")).trim() + "_CavEnv.property")).exists()) {
                    file.delete();
                } else {
                    file.createNewFile();
                    try {
                        FileWriter fw = new FileWriter(file, true);
                        BufferedWriter bufferedWriter = new BufferedWriter(fw);
                        bufferedWriter.write("HostName=" + this.URLConnectionString);
                        bufferedWriter.write("\n");
                        bufferedWriter.write("UserName=" + this.username);
                        bufferedWriter.close();
                    }
                    catch (Exception e) {
                        System.out.println("Exception in writing in file - " + e);
                    }
                }
                run.setResult(Result.SUCCESS);
            }
            catch (Exception e) {
                System.out.println("Unknown exception. IOException -" + e);
            }
        } else {
            run.setResult(Result.FAILURE);
        }
    }

    public JSONObject getTestsuiteJson() {
        try {
            JSONArray testsuiteArray = new JSONArray();
            for (int i = 0; i < this.testsuiteList.size(); ++i) {
                String[] prefix = this.testsuiteList.get(i).split("_");
                if (prefix.length <= 1) continue;
                logger.log(Level.INFO, "parameter dto = " + this.testsuiteParameterMap.get(prefix[0]));
                JSONObject obj = this.testsuiteParameterMap.get(prefix[0]).testsuiteJson();
                obj.put("scenario", (Object)this.testsuiteList.get(i));
                obj.put("project", (Object)this.project);
                obj.put("subproject", (Object)this.subProject);
                obj.put("testmode", (Object)this.testMode);
                obj.put("scriptHeaders", (Object)this.hiddenBox);
                obj.put("baselineType", (Object)this.baselineType);
                testsuiteArray.add((Object)obj);
            }
            JSONObject requestObj = new JSONObject();
            requestObj.put("username", (Object)this.username);
            requestObj.put("password", (Object)this.password.getPlainText());
            requestObj.put("URLConnectionString", (Object)this.URLConnectionString);
            requestObj.put("scenario", (Object)testsuiteArray);
            requestObj.put("workProfile", (Object)this.profile);
            requestObj.put("generateReport", (Object)Boolean.toString(this.generateReport));
            String uniqueID = UUID.randomUUID().toString();
            requestObj.put("JOB_ID", (Object)uniqueID);
            return requestObj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setParametersValue() {
        try {
            String mail;
            String mail2;
            Object mail3;
            String email;
            String[] temp;
            String tName;
            String rampupsec;
            String[] prefix;
            ArrayList<String> prefixList;
            this.netstormConnectionManger = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, this.project, this.subProject, this.scenario, this.testMode, this.baselineType, this.pollInterval, this.profile, this.hiddenBox, this.generateReport, this.doNotWaitForTestCompletion, this.gitPull);
            logger.log(Level.INFO, "parameter values testsuite = " + this.testsuite + ", data dir = " + this.dataDir);
            if (this.testsuite != null && !this.testsuite.isEmpty()) {
                logger.log(Level.INFO, "Test Suite Name = " + this.testsuite);
                this.testsuiteList = Arrays.asList(this.testsuite.split("\\s*,\\s*"));
                this.testsuiteParameterMap = new HashMap();
                logger.log(Level.INFO, "testsuite size  = " + this.testsuiteList.size());
                if (this.testsuiteList.size() > 1) {
                    for (int i = 0; i < this.testsuiteList.size(); ++i) {
                        String suiteName = this.testsuiteList.get(i);
                        String[] prefix2 = suiteName.split("_");
                        if (prefix2.length <= 1) continue;
                        logger.log(Level.INFO, "testsuiteParameterMap = " + this.testsuiteParameterMap);
                        this.testsuiteParameterMap.put(prefix2[0], new ParameterDTO());
                    }
                } else if (this.testsuiteList.size() == 1) {
                    String[] testsuites = this.testsuite.split("/");
                    if (testsuites.length == 3) {
                        this.netstormConnectionManger.setProject(testsuites[0]);
                        this.netstormConnectionManger.setSubProject(testsuites[1]);
                        this.netstormConnectionManger.setScenario(testsuites[2]);
                    } else {
                        this.netstormConnectionManger.setScenario(this.testsuite);
                    }
                }
            }
            if (this.dataDir != null && !this.dataDir.isEmpty()) {
                logger.log(Level.INFO, "data dir = " + this.dataDir);
                if (this.testsuiteList.size() > 1) {
                    List<String> dataDirNames = Arrays.asList(this.dataDir.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < dataDirNames.size(); ++i) {
                        String dirName = dataDirNames.get(i);
                        prefix = dirName.split("_");
                        if (prefix.length <= 1) continue;
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setDataDir(dirName.substring(dirName.indexOf("_") + 1, dirName.length()));
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setDataDir(dirName.substring(dirName.indexOf("_") + 1, dirName.length()));
                        }
                    }
                } else if (this.testsuiteList.size() == 1) {
                    this.netstormConnectionManger.setDataDir(this.dataDir);
                }
            }
            this.netstormConnectionManger.addSLAValue("1", "2");
            if (this.duration != null && this.duration.contains("NS_SESSION")) {
                String[] temp2;
                if (this.testsuiteList.size() > 1) {
                    List<String> durationValue = Arrays.asList(this.duration.split("\\s*,\\s*"));
                    prefixList = new ArrayList<String>();
                    for (int i = 0; i < durationValue.size(); ++i) {
                        String durtn = durationValue.get(i);
                        prefix = durtn.split("_");
                        if (prefix.length <= 1) continue;
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setDuration(prefix[3]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setDuration(prefix[2]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp2 = this.duration.split("_")).length > 2) {
                    this.netstormConnectionManger.setDuration(temp2[2]);
                }
            }
            if (this.totalusers != null && this.totalusers.contains("NS_NUM_USERS")) {
                String[] temp3;
                if (this.testsuiteList.size() > 1) {
                    List<String> users = Arrays.asList(this.totalusers.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < users.size(); ++i) {
                        String vusers = users.get(i);
                        prefix = vusers.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 3) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setTotalusers(prefix[3]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 2 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setTotalusers(prefix[2]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp3 = this.totalusers.split("_")).length > 3) {
                    this.netstormConnectionManger.setvUsers(temp3[3]);
                }
            }
            logger.log(Level.INFO, "server host = " + this.serverhost);
            if (this.serverhost != null && this.serverhost.contains("NS_SERVER_HOST")) {
                String[] temp4;
                logger.log(Level.INFO, "inside server host = " + this.serverhost);
                if (this.testsuiteList.size() > 1) {
                    List<String> host = Arrays.asList(this.serverhost.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < host.size(); ++i) {
                        String shost = host.get(i);
                        prefix = shost.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 4) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setServerhost(shost.split("HOST_")[1]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 3 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setServerhost(shost.split("HOST_")[1]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp4 = this.serverhost.split("_")).length > 3) {
                    this.netstormConnectionManger.setServerHost(this.serverhost.split("HOST_")[1]);
                }
            }
            if (this.sla != null && this.sla.contains("NS_SLA_CHANGE")) {
                String[] temp5;
                if (this.testsuiteList.size() > 1) {
                    List<String> slas = Arrays.asList(this.sla.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < slas.size(); ++i) {
                        String checkRuleSla = slas.get(i);
                        prefix = checkRuleSla.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 5) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).addSLAValue(prefix[5], prefix[4]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 4 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).addSLAValue(prefix[4], prefix[3]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp5 = this.sla.split("_")).length > 3) {
                    this.netstormConnectionManger.addSLAValue(temp5[4], temp5[3]);
                }
            }
            if (this.rampUpSec != null && this.rampUpSec.contains("NS_RAMP_UP_SEC")) {
                String[] temp6;
                if (this.testsuiteList.size() > 1) {
                    List<String> rampup = Arrays.asList(this.rampUpSec.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < rampup.size(); ++i) {
                        rampupsec = rampup.get(i);
                        prefix = rampupsec.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 5) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setRampUp(prefix[5] + "_" + prefix[4]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 4 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setRampUp(prefix[4] + "_" + prefix[3]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp6 = this.rampUpSec.split("_")).length > 4) {
                    this.netstormConnectionManger.setRampUp(temp6[4] + "_" + temp6[3]);
                }
            }
            if (this.rampupmin != null && this.rampupmin.contains("NS_RAMP_UP_MIN")) {
                String[] temp7;
                if (this.testsuiteList.size() > 1) {
                    List<String> rampup = Arrays.asList(this.rampupmin.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < rampup.size(); ++i) {
                        rampupsec = rampup.get(i);
                        prefix = rampupsec.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 5) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setRampUp(prefix[5] + "_" + prefix[4]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 4 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setRampUp(prefix[4] + "_" + prefix[3]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp7 = this.rampupmin.split("_")).length > 4) {
                    this.netstormConnectionManger.setRampUp(temp7[4] + "_" + temp7[3]);
                }
            }
            if (this.rampuphour != null && this.rampuphour.contains("NS_RAMP_UP_HR")) {
                String[] temp8;
                if (this.testsuiteList.size() > 1) {
                    List<String> rampup = Arrays.asList(this.rampuphour.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < rampup.size(); ++i) {
                        rampupsec = rampup.get(i);
                        prefix = rampupsec.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 5) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setRampUp(prefix[5] + "_" + prefix[4]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 4) continue;
                            if (!prefixList.contains(entry.getKey())) {
                                // empty if block
                            }
                            this.testsuiteParameterMap.get(entry.getKey()).setRampUp(prefix[4] + "_" + prefix[3]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp8 = this.rampupmin.split("_")).length > 4) {
                    this.netstormConnectionManger.setRampUp(temp8[4] + "_" + temp8[3]);
                }
            }
            if (this.testName != null && this.testName.contains("NS_TNAME") && !(tName = this.getSubString(this.testName, 2, "_")).equals("")) {
                this.netstormConnectionManger.settName(tName);
            }
            if (this.scriptPath.startsWith("NS_AUTOSCRIPT") && (temp = this.scriptPath.split("_", 3)).length > 2) {
                this.netstormConnectionManger.setAutoScript(temp[2]);
            }
            if (this.rampupDuration != null && this.rampupDuration.contains("NS_RAMP_UP_DURATION")) {
                if (this.testsuiteList.size() > 1) {
                    List<String> rampup = Arrays.asList(this.rampupDuration.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < rampup.size(); ++i) {
                        rampupsec = rampup.get(i);
                        prefix = rampupsec.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 5) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setRampupDuration(prefix[5]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 4 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setEmailid(rampupsec.split("UP_DURATION_")[1]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp = this.rampupDuration.split("_")).length > 4) {
                    this.netstormConnectionManger.setRampUpDuration(temp[4]);
                }
            }
            logger.log(Level.INFO, "email id to = " + this.emailid);
            if (this.emailid != null && this.emailid.contains("EMAIL_IDS_TO")) {
                if (this.testsuiteList.size() > 1) {
                    logger.log(Level.INFO, "inside email id = " + this.emailid);
                    List<String> emailidto = Arrays.asList(this.emailid.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < emailidto.size(); ++i) {
                        email = emailidto.get(i);
                        prefix = email.split("_");
                        logger.log(Level.INFO, "insideeeee email id = " + email);
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 4) continue;
                            prefixList.add(prefix[0]);
                            mail3 = email.split("IDS_TO_")[1].replaceAll("\\|", ",");
                            logger.log(Level.INFO, "mail = " + (String)mail3);
                            this.testsuiteParameterMap.get(prefix[0]).setEmailid((String)mail3);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 3 || prefixList.contains(entry.getKey())) continue;
                            mail2 = email.split("IDS_TO_")[1].replaceAll("\\|", ",");
                            logger.log(Level.INFO, "mail = " + mail2);
                            this.testsuiteParameterMap.get(entry.getKey()).setEmailid(mail2);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp = this.emailid.split("_")).length > 3) {
                    mail = this.emailid.split("IDS_TO_")[1].replaceAll("\\|", ",");
                    logger.log(Level.INFO, "mail = " + mail);
                    this.netstormConnectionManger.setEmailIdTo(mail);
                }
            }
            if (this.emailidCC != null && this.emailidCC.contains("EMAIL_IDS_CC")) {
                if (this.testsuiteList.size() > 1) {
                    List<String> emailidcc = Arrays.asList(this.emailidCC.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < emailidcc.size(); ++i) {
                        email = emailidcc.get(i);
                        prefix = email.split("_");
                        if (prefix.length <= 1) continue;
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 4) continue;
                            prefixList.add(prefix[0]);
                            mail3 = email.split("IDS_CC_")[1].replaceAll("\\|", ",");
                            this.testsuiteParameterMap.get(prefix[0]).setEmailidCC((String)mail3);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 3 || !prefixList.contains(entry.getKey())) continue;
                            mail2 = email.split("IDS_CC_")[1].replaceAll("\\|", ",");
                            this.testsuiteParameterMap.get(entry.getKey()).setEmailidCC(mail2);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp = this.emailidCC.split("_")).length > 3) {
                    mail = this.emailidCC.split("IDS_CC_")[1].replaceAll("\\|", ",");
                    this.netstormConnectionManger.setEmailIdCc(mail);
                }
            }
            if (this.emailidBcc != null && this.emailidBcc.contains("EMAIL_IDS_BCC")) {
                if (this.testsuiteList.size() > 1) {
                    List<String> emailidbcc = Arrays.asList(this.emailidBcc.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < emailidbcc.size(); ++i) {
                        email = emailidbcc.get(i);
                        prefix = email.split("_");
                        if (prefix.length <= 1) continue;
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 4) continue;
                            prefixList.add(prefix[0]);
                            mail3 = email.split("IDS_BCC_")[1].replaceAll("\\|", ",");
                            this.testsuiteParameterMap.get(prefix[0]).setEmailidBcc((String)mail3);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 3 || prefixList.contains(entry.getKey())) continue;
                            mail2 = email.split("IDS_BCC_")[1].replaceAll("\\|", ",");
                            this.testsuiteParameterMap.get(entry.getKey()).setEmailidBcc(mail2);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp = this.emailidBcc.split("_")).length > 3) {
                    mail = this.emailidBcc.split("IDS_BCC_")[1].replaceAll("\\|", ",");
                    this.netstormConnectionManger.setEmailIdBcc(mail);
                }
            }
            if (this.checkRuleFileUpload.equalsIgnoreCase(fileName)) {
                this.fileUpload = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getGitConfigurationFromNS() {
        try {
            System.out.println("In method getGitConfigurationFromNS ...");
            logger.log(Level.INFO, "In method getGitConfigurationFromNS ...");
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15);
            String res = netstormConnectionManger.getGitConfiguration();
            logger.log(Level.INFO, "getGitConfigurationFromNS res ..." + res);
            System.out.println("getGitConfigurationFromNS resss ..." + res);
            if (res == null || res.equals("") || res.equals("notConfigured")) {
                logger.log(Level.INFO, "git is not configured ...");
                this.repoIp = "";
                this.repoPort = "";
                this.repoPath = "";
                this.repoUsername = "";
                this.repoPassword = "";
                this.protocol = "";
            } else {
                String[] resArr = res.split(" ");
                if (resArr.length > 8) {
                    this.repoIp = resArr[0];
                    this.repoPort = resArr[1];
                    this.repoPath = resArr[2];
                    this.repoUsername = resArr[3];
                    this.repoPassword = resArr[4];
                    this.protocol = resArr[8];
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception in getGitConfigurationFromNS.", e);
        }
    }

    @JavaScriptMethod
    public String getAddedHeaders() {
        try {
            logger.log(Level.INFO, "getAddedHeaders called ...hiddenBox -" + this.hiddenBox);
            return this.hiddenBox;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception in getAddedHeaders.", e);
            return "";
        }
    }

    @JavaScriptMethod
    public String getTableValue() {
        try {
            logger.log(Level.INFO, "getTableValue called ...testProfileBox -" + this.testProfileBox);
            return this.testProfileBox;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception in getTableValue.", e);
            return "";
        }
    }

    public JSONObject createJsonForFileUpload(FilePath fp, PrintStream logger) {
        try {
            JSONObject json = null;
            String fileNm = fileName;
            if (fileName.indexOf(".") != -1) {
                String[] name = fileName.split("\\.");
                fileNm = name[0];
            }
            File file = new File(fp + "/" + fileNm);
            logger.println("File path" + file);
            if (file.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    if (line.contains("GroupName") || line.contains("GraphName") || line.contains("VectorName") || line.contains("RuleDesc")) {
                        line = line.trim().replaceAll("\\s", "@@");
                    }
                    builder.append(line.trim());
                }
                json = (JSONObject)JSONSerializer.toJSON((Object)builder.toString());
            }
            return json;
        }
        catch (Exception e) {
            System.out.println("Unknown exception. IOException -" + e);
            return null;
        }
    }

    public String startTest(NetStormConnectionManager netstormConnectionManger) {
        try {
            StringBuffer errBuf = new StringBuffer();
            File tempFile = File.createTempFile("myfile", ".tmp");
            FileOutputStream fout = new FileOutputStream(tempFile);
            PrintStream pout = new PrintStream(fout);
            HashMap result = netstormConnectionManger.startNetstormTest(errBuf, pout);
            if (result.get("TESTRUN") != null && !result.get("TESTRUN").toString().trim().equals("")) {
                testRunNumber = (String)result.get("TESTRUN");
                testCycleNumber = (String)result.get("TEST_CYCLE_NUMBER");
                return result.toString();
            }
            return result.toString();
        }
        catch (Exception e) {
            System.out.println("Error in startin a test" + e);
            return "Error in starting a test";
        }
    }

    public String getSubString(String OrgString, int startIndex, String seperator) {
        String[] f = OrgString.split(seperator);
        String result = "";
        if (startIndex <= f.length - 1) {
            for (int i = startIndex; i < f.length; ++i) {
                result = i == startIndex ? result + f[i] : result + "_" + f[i];
            }
        }
        return result;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType);
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)super.newInstance(req, formData);
        }

        public String getDisplayName() {
            return Messages.NetStormBuilder_Task();
        }

        public FormValidation doCheckPassword(@QueryParameter String password) {
            return FieldValidator.validatePassword(password);
        }

        public FormValidation doCheckUsername(@QueryParameter String username) {
            return FieldValidator.validateUsername(username);
        }

        public FormValidation doCheckURLConnectionString(@QueryParameter String URLConnectionString) {
            return FieldValidator.validateURLConnectionString(URLConnectionString);
        }

        @JavaScriptMethod
        public ArrayList<String> getPulledObjects(String value, String URLConnectionString, String username, String password, String project, String subProject, String testMode, String profile) {
            try {
                logger.log(Level.INFO, "getPulledObjects args - value :" + value + ",url -" + URLConnectionString + ", project -" + project + ", subProject -" + subProject + ",testMode -" + testMode + ", profile -" + profile);
                ArrayList<String> res = new ArrayList<String>();
                StringBuffer errMsg = new StringBuffer();
                if (!(URLConnectionString.equals("") || URLConnectionString.equals("NA") || URLConnectionString.equals(" ") || URLConnectionString == null || password.equals("") || password.equals("NA") || password.equals(" ") || password == null || username.equals("") || username.equals("NA") || username.equals(" ") || username == null)) {
                    NetStormConnectionManager connection = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
                    if (value.equals("P")) {
                        logger.log(Level.INFO, "in P.......");
                        res = connection.getProjectList(errMsg, profile);
                    } else if (value.equals("SP")) {
                        logger.log(Level.INFO, "in SP.......");
                        res = connection.getSubProjectList(errMsg, project, profile);
                    } else if (value.equals("S")) {
                        logger.log(Level.INFO, "in S.......");
                        res = connection.getScenarioList(errMsg, project, subProject, testMode, profile);
                    }
                }
                if (res != null && res.size() > 0) {
                    for (int i = 0; i < res.size(); ++i) {
                        logger.log(Level.INFO, "res items -" + res.get(i));
                    }
                }
                return res;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception in getPulledObjects -" + e);
                return null;
            }
        }

        @JavaScriptMethod
        public JSONObject performGitpull(String URLConnectionString, String username, String password, String gitPull, String project, String subProject, String testMode) {
            logger.log(Level.INFO, "performGitpull called -");
            JSONObject status = new JSONObject();
            if (URLConnectionString.equals("") || URLConnectionString.equals("NA") || URLConnectionString.equals(" ") || URLConnectionString == null || password.equals("") || password.equals("NA") || password.equals(" ") || password == null || username.equals("") || username.equals("NA") || username.equals(" ") || username == null) {
                String temp = "Specify Netstorm URL Connection, Username and Password";
                status.put("msg", (Object)temp);
                status.put("color", (Object)"#CC0000");
                return status;
            }
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            JSONObject res = netstormConnectionManger.pullObjectsFromGit();
            logger.log(Level.INFO, "performGitpull: project before ..." + project);
            if (res != null && !res.isEmpty()) {
                if (!res.get("ErrMsg").toString().equals("")) {
                    logger.log(Level.INFO, "performGitpull: In first check ...");
                    String tmp = res.get("ErrMsg").toString();
                    status.put("msg", (Object)tmp);
                    status.put("color", (Object)"#C4A000");
                } else {
                    logger.log(Level.INFO, "performGitpull: In second check ...");
                    String tm = res.get("msg").toString();
                    status.put("msg", (Object)tm);
                    status.put("color", (Object)"#159537");
                }
            } else {
                status.put("msg", (Object)"GIT Pull was unsuccessful.");
                status.put("color", (Object)"#C4A000");
            }
            return status;
        }

        public FormValidation doTestNetstormConnection(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password) {
            StringBuffer errMsg;
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            FormValidation validationResult = netstormConnectionManger.testNSConnection(errMsg = new StringBuffer()) ? FormValidation.ok((String)"Successfully Connected") : FormValidation.warning((String)("Cannot Connect to NetStorm due to :" + errMsg));
            return validationResult;
        }

        public FormValidation doPullObjectsFromGit(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="profile") String profile) {
            FormValidation validationResult;
            StringBuffer errMsg = new StringBuffer();
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            JSONObject res = netstormConnectionManger.pullObjectsFromGit();
            logger.log(Level.INFO, "res in doPullObjectsFromGit -" + res);
            if (res != null && !res.isEmpty()) {
                if (!res.get("ErrMsg").toString().equals("")) {
                    logger.log(Level.INFO, "In first check ...");
                    validationResult = FormValidation.warning((String)res.get("ErrMsg").toString());
                } else {
                    logger.log(Level.INFO, "In second check ...");
                    validationResult = FormValidation.ok((String)res.get("msg").toString());
                }
            } else {
                validationResult = FormValidation.warning((String)"GIT Pull was unsuccessful.");
            }
            this.doFillProjectItems(URLConnectionString, username, password, profile);
            return validationResult;
        }

        public FormValidation doTestGitConfiguration(@QueryParameter(value="protocol") String protocol, @QueryParameter(value="repoIp") String repoIp, @QueryParameter(value="repoPort") String repoPort, @QueryParameter(value="repoPath") String repoPath, @QueryParameter(value="repoUsername") String repoUserName, @QueryParameter(value="repoPassword") String repoPassword, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="URLConnectionString") String URLConnectionString) {
            if (URLConnectionString.equals("") || URLConnectionString.equals("NA") || URLConnectionString.equals(" ") || URLConnectionString == null || password.equals("") || password.equals("NA") || password.equals(" ") || password == null || username.equals("") || username.equals("NA") || username.equals(" ") || username == null) {
                FormValidation validationResult = FormValidation.warning((String)"Specify Netstorm URL Connection, Username and Password first ...");
                return validationResult;
            }
            if (protocol.equals("") || protocol.equals("NA") || protocol.equals(" ") || protocol == null) {
                FormValidation validationResult = FormValidation.warning((String)"Protocol can not be empty");
                return validationResult;
            }
            if (repoIp.equals("") || repoIp.equals("NA") || repoIp.equals(" ") || repoIp == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository IP can not be empty");
                return validationResult;
            }
            if (repoPort.equals("") || repoPort.equals("NA") || repoPort.equals(" ") || repoPort == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository Port can not be empty");
                return validationResult;
            }
            if (repoPath.equals("") || repoPath.equals("NA") || repoPath.equals(" ") || repoPath == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository Path can not be empty");
                return validationResult;
            }
            if (repoUserName.equals("") || repoUserName.equals("NA") || repoUserName.equals(" ") || repoUserName == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository username can not be empty");
                return validationResult;
            }
            if (repoPassword.equals("") || repoPassword.equals("NA") || repoPassword.equals(" ") || repoPassword == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository password can not be empty");
                return validationResult;
            }
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            JSONObject res = netstormConnectionManger.checkGitConfiguration(protocol.toLowerCase(), repoIp, repoPort, repoPath, repoUserName, repoPassword, "NA");
            FormValidation validationResult = res != null && !res.isEmpty() ? (res.get("errMsg").toString().equals("") ? FormValidation.ok((String)res.get("msg").toString()) : (!res.get("errMsg").toString().equals("") ? FormValidation.warning((String)res.get("errMsg").toString()) : FormValidation.warning((String)"GIT configuration test failed."))) : FormValidation.warning((String)"GIT configuration test failed.");
            return validationResult;
        }

        public FormValidation doSaveGitConfiguration(@QueryParameter(value="protocol") String protocol, @QueryParameter(value="repoIp") String repoIp, @QueryParameter(value="repoPort") String repoPort, @QueryParameter(value="repoPath") String repoPath, @QueryParameter(value="repoUsername") String repoUserName, @QueryParameter(value="repoPassword") String repoPassword, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="URLConnectionString") String URLConnectionString) {
            if (URLConnectionString.equals("") || URLConnectionString.equals("NA") || URLConnectionString.equals(" ") || URLConnectionString == null || password.equals("") || password.equals("NA") || password.equals(" ") || password == null || username.equals("") || username.equals("NA") || username.equals(" ") || username == null) {
                FormValidation validationResult = FormValidation.warning((String)"Specify Netstorm URL Connection, Username and Password first ...");
                return validationResult;
            }
            if (protocol.equals("") || protocol.equals("NA") || protocol.equals(" ") || protocol == null) {
                FormValidation validationResult = FormValidation.warning((String)"Protocol can not be empty");
                return validationResult;
            }
            if (repoIp.equals("") || repoIp.equals("NA") || repoIp.equals(" ") || repoIp == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository IP can not be empty");
                return validationResult;
            }
            if (repoPort.equals("") || repoPort.equals("NA") || repoPort.equals(" ") || repoPort == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository Port can not be empty");
                return validationResult;
            }
            if (repoPath.equals("") || repoPath.equals("NA") || repoPath.equals(" ") || repoPath == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository Path can not be empty");
                return validationResult;
            }
            if (repoUserName.equals("") || repoUserName.equals("NA") || repoUserName.equals(" ") || repoUserName == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository username can not be empty");
                return validationResult;
            }
            if (repoPassword.equals("") || repoPassword.equals("NA") || repoPassword.equals(" ") || repoPassword == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository password can not be empty");
                return validationResult;
            }
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            String res = netstormConnectionManger.saveGitConfiguration(protocol.toLowerCase(), repoIp, repoPort, repoPath, repoUserName, repoPassword, "NA");
            logger.log(Level.INFO, "res.............." + res);
            FormValidation validationResult = FormValidation.ok((String)res);
            return validationResult;
        }

        public synchronized ListBoxModel doFillProfileItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password) {
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("")) {
                models.add("---Select Profile ---");
                return models;
            }
            NetStormConnectionManager objProject = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            ArrayList<String> profileList = objProject.getProfileList(errMsg);
            if (profileList == null || profileList.size() == 0) {
                models.add("---Select Profile ---");
                return models;
            }
            for (String profile : profileList) {
                models.add(profile);
            }
            return models;
        }

        public synchronized ListBoxModel doFillProjectItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="profile") String profile) {
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("") || profile == null || profile.trim().equals("")) {
                models.add("---Select Project ---");
                return models;
            }
            if (profile.trim().equals("---Select Profile ---")) {
                models.add("---Select Project ---");
                return models;
            }
            NetStormConnectionManager objProject = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            ArrayList<String> projectList = objProject.getProjectList(errMsg, profile);
            if (projectList == null || projectList.size() == 0) {
                models.add("---Select Project ---");
                return models;
            }
            for (String project : projectList) {
                models.add(project);
            }
            return models;
        }

        public synchronized ListBoxModel doFillBaselineTypeItems() {
            ListBoxModel models = new ListBoxModel();
            models.add("Select Baseline");
            models.add("All");
            models.add("Baseline1");
            models.add("Baseline2");
            models.add("Baseline3");
            return models;
        }

        public synchronized ListBoxModel doFillSubProjectItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="profile") String profile, @QueryParameter(value="project") String project) {
            StringBuffer errMsg;
            ListBoxModel models = new ListBoxModel();
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("") || project == null || project.trim().equals("")) {
                models.add("---Select SubProject ---");
                return models;
            }
            if (project.trim().equals("---Select Project ---")) {
                models.add("---Select SubProject ---");
                return models;
            }
            NetStormConnectionManager connection = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            ArrayList<String> subProjectList = connection.getSubProjectList(errMsg = new StringBuffer(), project, profile);
            if (subProjectList == null || subProjectList.size() == 0) {
                models.add("---Select SubProject ---");
                return models;
            }
            for (String subProject : subProjectList) {
                models.add(subProject);
            }
            return models;
        }

        public synchronized ListBoxModel doFillScenarioItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="profile") String profile, @QueryParameter(value="project") String project, @QueryParameter(value="subProject") String subProject, @QueryParameter(value="testMode") String testMode) {
            StringBuffer errMsg;
            ListBoxModel models = new ListBoxModel();
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("") || project == null || project.trim().equals("") || subProject == null || subProject.trim().equals("")) {
                models.add("---Select Profile ---");
                return models;
            }
            if (project.trim().equals("---Select Project ---") || subProject.trim().equals("---Select SubProject ---")) {
                models.add("---Select SubProject ---");
                return models;
            }
            NetStormConnectionManager connection = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            ArrayList<String> scenariosList = connection.getScenarioList(errMsg = new StringBuffer(), project, subProject, testMode, profile);
            if (scenariosList == null || scenariosList.size() == 0) {
                models.add("---Select Scenarios ---");
                return models;
            }
            for (String scenarios : scenariosList) {
                models.add(scenarios);
            }
            return models;
        }

        public ListBoxModel doFillTestModeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Scenario", "N");
            model.add("Test Suite", "T");
            return model;
        }

        public synchronized ListBoxModel doFillScriptItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="profile") String profile, @QueryParameter(value="scenario") String scenario, @QueryParameter(value="project") String project, @QueryParameter(value="subProject") String subProject, @QueryParameter(value="testMode") String testMode) {
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            logger.log(Level.INFO, "scriptList: url -" + URLConnectionString + ",username -" + username + ",password -" + password);
            logger.log(Level.INFO, "scriptList: profile -" + profile + ",project -" + project + ",sub project -" + subProject + ",testmode -" + testMode);
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("")) {
                models.add("---Select Script---");
                return models;
            }
            NetStormConnectionManager objProject = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            JSONArray scriptList = objProject.getScriptList(profile, scenario, project, subProject, testMode);
            logger.log(Level.INFO, "scriptList size -" + scriptList.size());
            if (scriptList == null || scriptList.size() == 0) {
                models.add("---Select Profile ---");
                return models;
            }
            for (int i = 0; i < scriptList.size(); ++i) {
                logger.log(Level.INFO, "scriptList item -" + (String)scriptList.get(i));
                models.add((String)scriptList.get(i));
            }
            return models;
        }

        public synchronized ListBoxModel doFillPageItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="script") String script, @QueryParameter(value="profile") String profile, @QueryParameter(value="scenario") String scenario, @QueryParameter(value="project") String project, @QueryParameter(value="subProject") String subProject, @QueryParameter(value="testMode") String testMode) {
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            logger.log(Level.INFO, "pageList: url -" + URLConnectionString + ",username -" + username + ",password -" + password);
            logger.log(Level.INFO, "pageList: profile -" + profile + ",project -" + project + ",sub project -" + subProject + ",testmode -" + testMode);
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("") || script.equals("---Select Script---")) {
                models.add("---Select Page---");
                return models;
            }
            NetStormConnectionManager objProject = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15);
            if (!script.equals("All")) {
                JSONArray pageList = objProject.getPageList(script, scenario, profile, testMode, project, subProject);
                logger.log(Level.INFO, "pageList size -" + pageList.size());
                if (pageList == null || pageList.size() == 0) {
                    models.add("---Select Profile ---");
                    return models;
                }
                for (int i = 0; i < pageList.size(); ++i) {
                    logger.log(Level.INFO, "pageList item -" + (String)pageList.get(i));
                    String temp = (String)pageList.get(i);
                    temp = temp.replace("\"", "");
                    logger.log(Level.INFO, "temp -" + temp);
                    models.add(temp);
                }
            } else if (script.equals("All")) {
                logger.log(Level.INFO, "in all check ...");
                models.add("All");
            }
            return models;
        }

        public synchronized ListBoxModel doFillUrlHeaderItems() {
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            models.add("Main");
            models.add("Inline");
            models.add("ALL");
            return models;
        }
    }
}

