/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.BuildActionResultsDisplay;
import com.cavisson.jenkins.NetStormReport;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerProxy;

public class NetStormBuildAction
implements Action,
StaplerProxy {
    private final Run<?, ?> build;
    private final NetStormReport report;
    private transient WeakReference<BuildActionResultsDisplay> buildActionResultsDisplay;
    private boolean isNDE = false;
    private boolean isIntegrated = false;
    private static final transient Logger logger = Logger.getLogger(NetStormBuildAction.class.getName());

    public NetStormBuildAction(Run<?, ?> build, NetStormReport report) {
        this.build = build;
        this.report = report;
    }

    public NetStormBuildAction(Run<?, ?> build, NetStormReport report, boolean isNDE) {
        this.build = build;
        this.report = report;
        this.isNDE = isNDE;
    }

    public NetStormBuildAction(Run<?, ?> build, NetStormReport report, boolean isNDE, boolean isIntegrated) {
        this.build = build;
        this.report = report;
        this.isNDE = isNDE;
        this.isIntegrated = isIntegrated;
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "";
    }

    public String getUrlName() {
        if (this.isNDE) {
            return "netdiagonstic-dashboard";
        }
        return "netstorm-dashboard";
    }

    public BuildActionResultsDisplay getTarget() {
        return this.getBuildActionResultsDisplay();
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public NetStormReport getNetStormReport() {
        return this.report;
    }

    public BuildActionResultsDisplay getBuildActionResultsDisplay() {
        BuildActionResultsDisplay buildDisplay = null;
        WeakReference<BuildActionResultsDisplay> wr = this.buildActionResultsDisplay;
        if (wr != null && (buildDisplay = (BuildActionResultsDisplay)wr.get()) != null) {
            return buildDisplay;
        }
        try {
            buildDisplay = new BuildActionResultsDisplay(this, (TaskListener)StreamTaskListener.fromStdout(), this.isNDE);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error creating new BuildActionResultsDisplay()", e);
        }
        this.buildActionResultsDisplay = new WeakReference<BuildActionResultsDisplay>(buildDisplay);
        return buildDisplay;
    }

    public void setBuildActionResultsDisplay(WeakReference<BuildActionResultsDisplay> buildActionResultsDisplay) {
        this.buildActionResultsDisplay = buildActionResultsDisplay;
    }
}

