/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.MetricData;
import com.cavisson.jenkins.MetricDataContainer;
import com.cavisson.jenkins.MetricInfo;
import com.cavisson.jenkins.MetricLinkInfo;
import com.cavisson.jenkins.MetricVal;
import com.cavisson.jenkins.MetricValues;
import com.cavisson.jenkins.NSNDIntegrationParameterForReport;
import com.cavisson.jenkins.ScalarVal;
import com.cavisson.jenkins.TestMetrics;
import com.cavisson.jenkins.TestReport;
import com.cavisson.jenkins.TransactionStats;
import hudson.FilePath;
import hudson.util.Secret;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;

public class NSNDIntegrationConnectionManager {
    private final String nsUrlConnectionString;
    private String nsUsername = "";
    private Secret nsPassword;
    private final String ndUrlConnectionString;
    private URLConnection urlConn = null;
    private final transient Logger logger = Logger.getLogger(NSNDIntegrationConnectionManager.class.getName());
    private String ndUsername = "";
    private Secret ndPassword;
    NSNDIntegrationParameterForReport ndParam;
    private ObjectOutputStream oos = null;
    private ObjectInputStream ois = null;
    private String restUrlNS = "";
    private String restUrlND = "";
    private String resultNS;
    private String resultND;
    private String curStart;
    private String curEnd;
    private JSONObject jkRule = new JSONObject();
    private String critical;
    private String warning;
    private String overall;
    private String project = "";
    private String subProject = "";
    private String scenario = "";
    private String scenarioName = "NA";
    private PrintStream consoleLogger = null;
    private String pollReportURL;
    private JSONObject resonseReportObjNS = null;
    private JSONObject resonseReportObjND = null;
    private static int POLL_CONN_TIMEOUT = 60000;
    private static int POLL_REPEAT_TIME = 60000;
    private static int POLL_REPEAT_FOR_REPORT_TIME = 30000;
    private static int INITIAL_POLL_DELAY = 60000;
    private int testRun = -1;
    private String err = "Connection failure, please check whether Connection URI is specified correctly";

    public String getCritical() {
        return this.critical;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getSubProject() {
        return this.subProject;
    }

    public void setSubProject(String subProject) {
        this.subProject = subProject;
    }

    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public void setCritical(String critical) {
        this.critical = critical;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public String getOverall() {
        return this.overall;
    }

    public void setOverall(String overall) {
        this.overall = overall;
    }

    public JSONObject getJkRule() {
        return this.jkRule;
    }

    public void setJkRule(JSONObject jkRule) {
        this.jkRule = jkRule;
    }

    public String getCurStart() {
        return this.curStart;
    }

    public void setCurStart(String curStart) {
        this.curStart = curStart;
    }

    public String getCurEnd() {
        return this.curEnd;
    }

    public void setCurEnd(String curEnd) {
        this.curEnd = curEnd;
    }

    public String getResultNS() {
        return this.resultNS;
    }

    public void setResultNS(String result) {
        this.resultNS = result;
    }

    public String getResultND() {
        return this.resultND;
    }

    public void setResultND(String result) {
        this.resultND = result;
    }

    private static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
    }

    public NSNDIntegrationConnectionManager(String nsUrlConnectionString, String nsUsername, Secret nsPassword, String ndUrlConnectionString, String ndUsername, Secret ndPassword, NSNDIntegrationParameterForReport ndParam) {
        this.nsUrlConnectionString = nsUrlConnectionString;
        this.ndUrlConnectionString = ndUrlConnectionString;
        this.nsUsername = nsUsername;
        this.ndUsername = ndUsername;
        this.ndParam = ndParam;
        this.restUrlNS = nsUrlConnectionString;
        this.restUrlND = ndUrlConnectionString;
        this.nsPassword = nsPassword;
        this.ndPassword = ndPassword;
    }

    public boolean testNDConnection(StringBuffer errMsg, String test) {
        this.logger.log(Level.INFO, "testNDConnection() method is  called. rest url -" + this.restUrlND);
        if (this.checkAndMakeConnection(this.ndUrlConnectionString, this.restUrlND, errMsg, test) && this.checkAndMakeConnectionNS(this.nsUrlConnectionString, errMsg)) {
            this.logger.log(Level.INFO, "After check connection method for in integrated.");
            JSONObject jsonResponse = (JSONObject)JSONSerializer.toJSON((Object)this.getResultNS());
            JSONObject jsonResponseND = (JSONObject)JSONSerializer.toJSON((Object)this.getResultND());
            if (this.getResultNS() == null) {
                this.logger.log(Level.INFO, "Connection failure, please check whether Connection URI of Netstorm is specified correctly");
                errMsg.append("Connection failure, please check whether Connection URI is specified correctly");
                return false;
            }
            if (this.getResultND() == null) {
                this.logger.log(Level.INFO, "Connection failure, please check whether Connection URI of Netdiganostic  is specified correctly");
                errMsg.append("Connection failure, please check whether Connection URI is specified correctly");
                return false;
            }
            if (!jsonResponse.get("errMsg").equals("") || !jsonResponseND.get("errMsg").equals("")) {
                String nsErr = "";
                String ndErr = "";
                if (!jsonResponse.get("errMsg").equals("")) {
                    nsErr = (String)jsonResponse.get(jsonResponse.get("errMsg")) + " for netstorm.";
                }
                if (!jsonResponseND.get("errMsg").equals("")) {
                    ndErr = (String)jsonResponseND.get("errMsg") + " for netdiagnostics . ";
                }
                this.err = nsErr + " " + ndErr;
                this.logger.log(Level.INFO, "Connection failure, please check whether Connection URI of either NetStorm or Netdiagnostic is specified correctly");
                errMsg.append(this.err);
                return false;
            }
            this.logger.log(Level.INFO, "Successfully Authenticated.");
            return true;
        }
        this.logger.log(Level.INFO, "Connection failure, please check whether Connection URI of either NetStorm or Netdiagnostic is specified correctly");
        errMsg.append(this.err);
        return false;
    }

    private boolean checkAndMakeConnectionNS(String urlString, StringBuffer errMsg) {
        this.logger.log(Level.INFO, "checkAndMakeConnectionNS method called. with arguments restUrl for netstorm  : ", new Object[]{urlString});
        try {
            JSONObject reqObj = new JSONObject();
            reqObj.put("username", (Object)this.nsUsername);
            reqObj.put("password", (Object)this.nsPassword.getPlainText());
            reqObj.put("URLConnectionString", (Object)this.nsUrlConnectionString);
            NSNDIntegrationConnectionManager.disableSslVerification();
            String str = this.getUrlString(urlString);
            URL url = new URL(str + "ProductUI/productSummary/jenkinsService/validateUser");
            this.logger.log(Level.INFO, "checkAndMakeConnectionNS method for netstorm  called. with arguments url = " + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            String json = reqObj.toString();
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.setResultNS(br.readLine());
            this.logger.log(Level.INFO, "RESPONSE from Netstorm -> " + this.getResultNS());
            return true;
        }
        catch (MalformedURLException e) {
            this.logger.log(Level.SEVERE, "Unknown exception in establishing connection with Netstorm Machine. MalformedURLException -", e);
            return false;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Unknown exception in establishing connection with Netstorm Machine. IOException -", e);
            return false;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unknown exception in establishing connection with Netstorm Machine.", e);
            return false;
        }
    }

    public String getUrlString(String urlString) {
        String urlAddrs = "";
        try {
            String[] str = urlString.split(":");
            if (str.length > 2) {
                urlAddrs = str[0] + ":" + str[1];
                if (str[2].contains("/")) {
                    String[] value = str[2].split("/");
                    urlAddrs = urlAddrs + ":" + value[0];
                } else {
                    urlAddrs = urlAddrs + ":" + str[2];
                }
            } else {
                urlAddrs = urlString;
            }
            if (!urlAddrs.trim().endsWith("/")) {
                urlAddrs = urlAddrs + "/";
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error in getting url string ");
            return urlString.substring(0, urlString.lastIndexOf("/"));
        }
        return urlAddrs;
    }

    private boolean checkAndMakeConnection(String urlString, String restUrl, StringBuffer errMsg) {
        return this.checkAndMakeConnection(urlString, restUrl, errMsg, null);
    }

    private boolean checkAndMakeConnection(String urlString, String restUrl, StringBuffer errMsg, String test) {
        this.logger.log(Level.INFO, "checkAndMakeConnection method for NetDiagnostics called. with arguments restUrl : ", new Object[]{restUrl});
        try {
            if (this.ndParam != null) {
                this.logger.log(Level.INFO, "checkAndMakeConnection method for NetDiagnostics called. with ndParam " + this.ndParam.toString());
                if (this.ndParam.getBase1StartTime().equals("")) {
                    this.ndParam.setBase1StartTime(null);
                } else {
                    this.ndParam.setBase1StartTime(this.ndParam.getBase1StartTime().replace(" ", "@"));
                }
                if (this.ndParam.getBase1EndTime().equals("")) {
                    this.ndParam.setBase1EndTime(null);
                } else {
                    this.ndParam.setBase1EndTime(this.ndParam.getBase1EndTime().replace(" ", "@"));
                }
                if (this.ndParam.getBase2StartTime() != null && !this.ndParam.getBase2StartTime().equals("")) {
                    this.ndParam.setBase2StartTime(this.ndParam.getBase2StartTime().replace(" ", "@"));
                } else {
                    this.ndParam.setBase2StartTime(null);
                }
                if (this.ndParam.getBase2EndTime() != null && !this.ndParam.getBase2EndTime().equals("")) {
                    this.ndParam.setBase2EndTime(this.ndParam.getBase2EndTime().replace(" ", "@"));
                } else {
                    this.ndParam.setBase2EndTime(null);
                }
                if (this.ndParam.getBase3StartTime() != null && !this.ndParam.getBase3StartTime().equals("")) {
                    this.ndParam.setBase3StartTime(this.ndParam.getBase3StartTime().replace(" ", "@"));
                } else {
                    this.ndParam.setBase3StartTime(null);
                }
                if (this.ndParam.getBase3EndTime() != null && !this.ndParam.getBase3EndTime().equals("")) {
                    this.ndParam.setBase3EndTime(this.ndParam.getBase3EndTime().replace(" ", "@"));
                } else {
                    this.ndParam.setBase3EndTime(null);
                }
            }
            if (this.getCritical() != null && this.getCritical() != "") {
                this.ndParam.setCritiThreshold(this.getCritical().replace(" ", "@"));
            }
            if (this.getWarning() != null && this.getWarning() != "") {
                this.ndParam.setWarThreshold(this.getWarning().replace(" ", "@"));
            }
            if (this.getOverall() != null && this.getOverall() != "") {
                this.ndParam.setFailThreshold(this.getOverall().replace(" ", "@"));
            }
            String str = this.getUrlString(urlString);
            this.logger.log(Level.INFO, "value of test in case ND connection..." + test);
            URL url = test == null || test.equals(null) ? new URL(str + "ProductUI/productSummary/jenkinsService/reportData?&reportParam=" + this.ndParam.toString() + "&status=false&chkRule=" + this.getJkRule()) : new URL(str + "ProductUI/productSummary/jenkinsService/reportData?&reportParam=" + test + "&status=true");
            this.logger.log(Level.INFO, "checkAndMakeConnection method for NetDiagnostics called. with arguments url - " + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.setResultND(br.readLine());
            this.logger.log(Level.INFO, "RESPONSE from Netdiagnostics -> " + this.getResultND());
            JSONObject resonseObj = null;
            resonseObj = (JSONObject)JSONSerializer.toJSON((Object)this.resultND);
            Boolean status = (Boolean)resonseObj.get("status");
            return status;
        }
        catch (MalformedURLException e) {
            this.logger.log(Level.SEVERE, "Unknown exception in establishing connection with Netdiagnostics. MalformedURLException -", e);
            return false;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Unknown exception in establishing connection with Netdiagnostics. IOException -", e);
            return false;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unknown exception in establishing connection with Netdiagnostics.", e);
            return false;
        }
    }

    private void connectNSAndPollJsonReport() {
        try {
            this.logger.log(Level.INFO, "Test is stopped. Now getting report from Netstorm. It may take some time. URL = " + this.pollReportURL);
            Runnable pollReportState = new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean isReportGenerated = true;
                        NSNDIntegrationConnectionManager.this.logger.log(Level.INFO, "Starting Polling to server.");
                        while (isReportGenerated) {
                            try {
                                String pollURLWithArgs = NSNDIntegrationConnectionManager.this.pollReportURL + "?&testRun=" + NSNDIntegrationConnectionManager.this.testRun;
                                URL url = new URL(pollURLWithArgs);
                                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                                conn.setConnectTimeout(POLL_CONN_TIMEOUT);
                                conn.setReadTimeout(POLL_CONN_TIMEOUT);
                                conn.setRequestMethod("GET");
                                conn.setRequestProperty("Accept", "application/json");
                                if (conn.getResponseCode() != 200) {
                                    NSNDIntegrationConnectionManager.this.logger.log(Level.INFO, "Getting Error code on polling  = " + conn.getResponseCode() + ". Retrying in next poll in 5 minutes.");
                                }
                                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                                String pollResString = br.readLine();
                                try {
                                    NSNDIntegrationConnectionManager.this.logger.log(Level.INFO, "Polling Response = " + pollResString);
                                    JSONObject pollResponse = (JSONObject)JSONSerializer.toJSON((Object)pollResString);
                                    if (pollResponse.getBoolean("status")) {
                                        isReportGenerated = false;
                                        NSNDIntegrationConnectionManager.this.resonseReportObjNS = pollResponse;
                                    }
                                }
                                catch (Exception e) {
                                    NSNDIntegrationConnectionManager.this.logger.log(Level.SEVERE, "Error in parsing polling response = " + pollResString, e);
                                }
                                try {
                                    br.close();
                                }
                                catch (Exception e) {
                                    NSNDIntegrationConnectionManager.this.logger.log(Level.SEVERE, "Error in closing stream inside polling thread.", e);
                                }
                            }
                            catch (Exception e) {
                                NSNDIntegrationConnectionManager.this.logger.log(Level.SEVERE, "Error in polling report with interval. Retrying after 5 sec.", e);
                            }
                            try {
                                Thread.sleep(POLL_REPEAT_FOR_REPORT_TIME);
                                NSNDIntegrationConnectionManager.this.logger.log(Level.INFO, "Report generation is  in progress. Going to check on server. Time = " + new Date());
                            }
                            catch (Exception ex) {
                                NSNDIntegrationConnectionManager.this.logger.log(Level.SEVERE, "Error in polling connection in loop", ex);
                            }
                        }
                    }
                    catch (Exception e) {
                        NSNDIntegrationConnectionManager.this.logger.log(Level.SEVERE, "Error in polling report with interval.", e);
                    }
                }
            };
            Thread pollTestRunThread = new Thread(pollReportState, "pollTestRunThread");
            ExecutorService threadExecutorService = Executors.newFixedThreadPool(1);
            threadExecutorService.execute(pollTestRunThread);
            threadExecutorService.shutdown();
            while (!threadExecutorService.isTerminated()) {
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error in polling report.", e);
        }
    }

    public boolean fetchMetricData(NSNDIntegrationConnectionManager connection, String[] metrics, String duration, int[] groupIds, int[] graphIds, int testRun, String testMode, FilePath fp) {
        JSONObject jsonRequest = this.makeRequestObject("GET_DATA");
        jsonRequest.put("TESTRUN", (Object)String.valueOf(testRun));
        jsonRequest.put(JSONKeys.TESTMODE.getValue(), (Object)testMode);
        jsonRequest.put(JSONKeys.PROJECT.getValue(), (Object)connection.getProject());
        jsonRequest.put(JSONKeys.SUBPROJECT.getValue(), (Object)connection.getSubProject());
        jsonRequest.put(JSONKeys.SCENARIO.getValue(), (Object)connection.getScenario());
        jsonRequest.put(JSONKeys.URLCONNECTION.getValue(), (Object)this.nsUrlConnectionString);
        this.testRun = testRun;
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < metrics.length; ++i) {
            jSONArray.add((Object)(groupIds[i] + "." + graphIds[i]));
        }
        jsonRequest.put("Metric", (Object)jSONArray);
        this.logger.log(Level.INFO, "fetchMetricData() called. get result for netstorm " + this.getResultNS());
        this.logger.log(Level.INFO, "fetchMetricData() called. get result for netdiagnostic " + this.getResultND());
        Object resonseObjNS = null;
        JSONObject resonseObjND = null;
        boolean nsStatus = false;
        boolean ndStatus = false;
        StringBuffer errMsg = new StringBuffer();
        try {
            String str = this.getUrlString(this.nsUrlConnectionString);
            URL url = new URL(str + "ProductUI/productSummary/jenkinsService/jsonData");
            this.logger.log(Level.INFO, "Making connection with netstorm for metric  url - " + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            String json = jsonRequest.toString();
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.resonseReportObjNS = (JSONObject)JSONSerializer.toJSON((Object)br.readLine());
            if (this.resonseReportObjNS.containsKey((Object)"status")) {
                if (!this.resonseReportObjNS.getBoolean("status")) {
                    this.logger.log(Level.SEVERE, "Not able to get response form server due to some reason");
                    this.consoleLogger.println("Error in report generation.");
                    nsStatus = false;
                    return false;
                }
                if (this.resonseReportObjNS.containsKey((Object)"Current Start Time") && this.resonseReportObjNS.containsKey((Object)"Current End Time")) {
                    this.setCurStartAndEndDateTime(this.resonseReportObjNS.getString("Current Start Time"), this.resonseReportObjNS.getString("Current End Time"), connection.getScenario());
                }
            }
            this.pollReportURL = str + "ProductUI/productSummary/jenkinsService/checkNetstormReportStatus";
            this.logger.log(Level.INFO, "url for polling report - pollReportURL = " + this.pollReportURL);
            this.connectNSAndPollJsonReport();
            if (this.resonseReportObjNS.getBoolean("status")) {
                this.getHTMLReport("NS", fp, String.valueOf(testRun));
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unknown exception in establishing connection with Netstorm .", e);
        }
        if (this.checkAndMakeConnection(this.ndUrlConnectionString, this.restUrlND, errMsg, null)) {
            this.logger.log(Level.INFO, "RESPONSE from netdiagnostics  -- " + this.resultND);
            resonseObjND = (JSONObject)JSONSerializer.toJSON((Object)this.resultND);
            ndStatus = true;
            this.getHTMLReport("ND", fp, "-1");
        } else {
            this.logger.log(Level.INFO, "Connection to netdiagnostics unsuccessful, cannot to proceed to generate report.");
            this.logger.log(Level.SEVERE, "Error: " + errMsg);
            ndStatus = false;
        }
        return nsStatus && ndStatus;
    }

    private boolean getHTMLReport(String type, FilePath fp, String testRun) {
        String zipFile = fp + "/TestSuiteReport.zip";
        this.logger.log(Level.INFO, "Pdf directory" + zipFile);
        File file = new File(zipFile);
        try {
            String str = "";
            str = type.equals("NS") ? this.nsUrlConnectionString : this.ndUrlConnectionString;
            URL urlForHTMLReport = new URL(str + "/ProductUI/productSummary/jenkinsService/getHTMLReport");
            this.logger.log(Level.INFO, "urlForPdf-" + urlForHTMLReport);
            HttpURLConnection connect = (HttpURLConnection)urlForHTMLReport.openConnection();
            connect.setConnectTimeout(0);
            connect.setReadTimeout(0);
            connect.setRequestMethod("POST");
            connect.setRequestProperty("Content-Type", "application/octet-stream");
            connect.setDoOutput(true);
            OutputStream outStream = connect.getOutputStream();
            outStream.write(testRun.getBytes());
            outStream.flush();
            if (connect.getResponseCode() == 200) {
                int bytesRead;
                this.logger.log(Level.INFO, "response 200 OK");
                byte[] mybytearray = new byte[1024];
                InputStream is = connect.getInputStream();
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                while ((bytesRead = is.read(mybytearray)) > 0) {
                    this.logger.log(Level.INFO, "bytesRead inside while check" + bytesRead);
                    bos.write(mybytearray, 0, bytesRead);
                }
                bos.close();
                is.close();
            } else {
                this.logger.log(Level.INFO, "ErrorCode-" + connect.getResponseCode());
                this.logger.log(Level.INFO, "content type-" + connect.getContentType());
            }
            String destDir = fp + "/TestSuiteReport";
            NSNDIntegrationConnectionManager.unzip(zipFile, destDir);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void unzip(String zipFilePath, String destDir) {
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        try {
            FileInputStream fis = new FileInputStream(zipFilePath);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(destDir + File.separator + fileName);
                System.out.println("Unzipping to " + newFile.getAbsolutePath());
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setCurStartAndEndDateTime(String curStartTime, String curEndTime, String scenario) {
        if (this.ndParam.getTimePeriod() != null) {
            if (this.ndParam.getTimePeriod().equals("Absolute Time")) {
                this.ndParam.setCurStartTime(this.ndParam.getCurStartTimeAbsolute().replace(" ", "@"));
                this.ndParam.setCurEndTime(this.ndParam.getCurEndTimeAbsolute().replace(" ", "@"));
            } else if (this.ndParam.getTimePeriod().equals("Elapsed Time")) {
                long startTime = NSNDIntegrationConnectionManager.convertFormattedDateToMilliscond(curStartTime, "MM/dd/yy HH:mm:ss", null);
                long elapsedStartTime = NSNDIntegrationConnectionManager.convertFormattedTimeToMillisecond(this.ndParam.getCurStartTimeElapsed(), ":");
                long elapStartTime = startTime + elapsedStartTime;
                String startElapsedTime = NSNDIntegrationConnectionManager.convertDateTimeStampToFormattedString(elapStartTime, "MM/dd/yy HH:mm:ss", null);
                long elapsedEndTime = NSNDIntegrationConnectionManager.convertFormattedTimeToMillisecond(this.ndParam.getCurEndTimeElapsed(), ":");
                long elapEndTime = startTime + elapsedEndTime;
                String endElapsedTime = NSNDIntegrationConnectionManager.convertDateTimeStampToFormattedString(elapEndTime, "MM/dd/yy HH:mm:ss", null);
                this.ndParam.setCurStartTime(startElapsedTime.replace(" ", "@"));
                this.ndParam.setCurEndTime(endElapsedTime.replace(" ", "@"));
            } else if (this.ndParam.getTimePeriod().equals("Phase")) {
                try {
                    String str = this.getUrlString(this.nsUrlConnectionString);
                    URL url = new URL(str + "ProductUI/productSummary/jenkinsService/getPhaseDuration?phaseName=" + this.ndParam.getPhase() + "&testRun=" + this.testRun + "&scenarioName=" + this.scenarioName);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setRequestProperty("Accept", "application/json");
                    if (conn.getResponseCode() != 200) {
                        this.logger.log(Level.INFO, "Getting Error code on polling  = " + conn.getResponseCode() + ". Retrying in next poll in 5 minutes.");
                    }
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    String phaseResponse = br.readLine();
                    JSONObject phaseDuration = (JSONObject)JSONSerializer.toJSON((Object)phaseResponse);
                    String startTime = phaseDuration.getString("start Time");
                    String endTime = phaseDuration.getString("end Time");
                    long startTimee = NSNDIntegrationConnectionManager.convertFormattedDateToMilliscond(curStartTime, "MM/dd/yy HH:mm:ss", null);
                    long timeInMilisecond = NSNDIntegrationConnectionManager.convertFormattedTimeToMillisecond(startTime, ":");
                    long stTime = startTimee + timeInMilisecond;
                    String startElapsedTime = NSNDIntegrationConnectionManager.convertDateTimeStampToFormattedString(stTime, "MM/dd/yy HH:mm:ss", null);
                    long endTimee = NSNDIntegrationConnectionManager.convertFormattedDateToMilliscond(curEndTime, "MM/dd/yy HH:mm:ss", null);
                    long endtimeInMilisecond = NSNDIntegrationConnectionManager.convertFormattedTimeToMillisecond(endTime, ":");
                    long edTime = startTimee + endtimeInMilisecond;
                    String edElapsedTime = NSNDIntegrationConnectionManager.convertDateTimeStampToFormattedString(edTime, "MM/dd/yy HH:mm:ss", null);
                    this.ndParam.setCurStartTime(startElapsedTime.replace(" ", "@"));
                    this.ndParam.setCurEndTime(edElapsedTime.replace(" ", "@"));
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Unknown exception in establishing connection with Netstorm .", e);
                }
            } else if (this.ndParam.getTimePeriod().equals("Whole Scenario")) {
                this.ndParam.setCurStartTime(curStartTime.replace(" ", "@"));
                this.ndParam.setCurEndTime(curEndTime.replace(" ", "@"));
            }
            this.setCurStart(curStartTime);
            this.setCurEnd(curEndTime);
            this.logger.log(Level.INFO, "current stat time and end time...." + this.ndParam.getCurStartTime() + "   " + this.ndParam.getCurEndTime());
        }
    }

    public static String convertDateTimeStampToFormattedString(long dateTimeStamp, String dateFormat, TimeZone timeZone) {
        try {
            SimpleDateFormat trDateFormat = new SimpleDateFormat(dateFormat);
            if (timeZone != null) {
                trDateFormat.setTimeZone(timeZone);
            }
            Date userDate = new Date(dateTimeStamp);
            String formattedDate = trDateFormat.format(userDate);
            return formattedDate;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static long convertFormattedDateToMilliscond(String dateTime, String dateFormat, TimeZone timeZone) {
        try {
            SimpleDateFormat trDateFormat = new SimpleDateFormat(dateFormat);
            if (timeZone != null) {
                trDateFormat.setTimeZone(timeZone);
            }
            Date userDate = trDateFormat.parse(dateTime);
            long absoluteDateInMillies = userDate.getTime();
            return absoluteDateInMillies;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long convertFormattedTimeToMillisecond(String formattedString, String seperater) {
        try {
            String[] arrTime = formattedString.split(seperater);
            if (arrTime == null || arrTime.length != 3) {
                return 0L;
            }
            int hourInSecond = Integer.parseInt(arrTime[0]) * 3600;
            int minuteInSecond = Integer.parseInt(arrTime[1]) * 60;
            int second = Integer.parseInt(arrTime[2]);
            long totalMilliscond = (long)(hourInSecond + minuteInSecond + second) * 1000L;
            return totalMilliscond;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private MetricDataContainer parseJSONDataND(JSONObject resonseObj, JSONObject resonseObjND, String testMode) {
        this.logger.log(Level.INFO, "parseJSONData() called.");
        MetricDataContainer metricDataContainer = new MetricDataContainer();
        this.logger.log(Level.INFO, "Recived response from netstorm :" + resonseObj);
        this.logger.log(Level.INFO, "Recived response from netdiagnostic : " + resonseObjND);
        try {
            ArrayList<MetricData> dataList = new ArrayList<MetricData>();
            JSONObject jsonGraphs = (JSONObject)resonseObj.get("graphs");
            this.logger.log(Level.INFO, "Recived response from graphs for netstorm : " + jsonGraphs);
            int freq = (Integer)resonseObj.get("frequency") / 1000;
            this.logger.log(Level.INFO, "Recived response from netstorm  : frq = " + freq);
            metricDataContainer.setFrequency(freq);
            TestReport testReportNS = new TestReport();
            if ("T".equals(testMode)) {
                testReportNS = new TestReport();
                JSONObject jsonTestReportWholeObj = resonseObj.getJSONObject("testReport");
                this.logger.log(Level.INFO, "Recived response from whole report : " + jsonTestReportWholeObj);
                JSONObject jsonTestReport = jsonTestReportWholeObj.getJSONObject("members");
                this.logger.log(Level.INFO, "Recived response from test : " + jsonTestReport);
                String overAllStatus = jsonTestReport.getString("Overall Status");
                String date = jsonTestReport.getString("Date");
                String overAllFailCriteria = jsonTestReport.getString("Overall Fail Criteria (greater than red) %");
                String serverName = jsonTestReport.getString("IP");
                String productName = jsonTestReport.getString("ProductName");
                String previousTestRun = jsonTestReport.getString("Previous Test Run");
                String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
                String initialTestRun = jsonTestReport.getString("Initial Test Run");
                String baseLineDateTime = jsonTestReport.getString("Baseline Date Time");
                String previousDateTime = jsonTestReport.getString("Previous Date Time");
                String initialDateTime = jsonTestReport.getString("Initial Date Time");
                String testRun = jsonTestReport.getString("Test Run");
                String normalThreshold = jsonTestReport.getString("Normal Threshold");
                String criticalThreshold = jsonTestReport.getString("Critical Threshold");
                String currentDateTime = "";
                String previousDescription = "";
                String baselineDescription = "";
                String currentDescription = "";
                String initialDescription = "";
                String dashboardURL = jsonTestReport.getString("Dashboard Link");
                String reportLink = jsonTestReport.getString("Report Link");
                try {
                    currentDateTime = jsonTestReport.getString("Current Date Time");
                    previousDescription = jsonTestReport.getString("Previous Description");
                    baselineDescription = jsonTestReport.getString("Baseline Description");
                    currentDescription = jsonTestReport.getString("Current Description");
                    initialDescription = jsonTestReport.getString("Initial Description");
                }
                catch (Exception ex) {
                    this.logger.log(Level.SEVERE, "NSNDIntegration - Error in parsing Test Report Data from  netstorm json:" + ex);
                    this.logger.log(Level.SEVERE, "NSNDIntegration ---" + ex.getMessage());
                }
                if (jsonTestReport.get("Metrics Under Test") != null) {
                    JSONArray metricsUnderTest = jsonTestReport.getJSONArray("Metrics Under Test");
                    ArrayList<TestMetrics> testMetricsList = new ArrayList<TestMetrics>(metricsUnderTest.size());
                    String str = "";
                    int index = 0;
                    for (Object jsonData : metricsUnderTest) {
                        JSONObject jsonObject = (JSONObject)jsonData;
                        String prevTestValue = jsonObject.getString("Prev Test Value ");
                        String baseLineValue = jsonObject.getString("Baseline Value ");
                        String initialValue = jsonObject.getString("Initial Value ");
                        String edLink = jsonObject.getString("link");
                        String currValue = jsonObject.getString("Value");
                        String metric = jsonObject.getString("Metric");
                        String metricRule = jsonObject.getString("MetricRule");
                        String operator = jsonObject.getString("Operator");
                        String sla = jsonObject.getString("SLA");
                        if (sla.indexOf(">") != -1 || sla.indexOf(">") > 0) {
                            sla = sla.substring(sla.lastIndexOf(">") + 1, sla.length());
                        }
                        String count = jsonObject.getString("Count");
                        String transactiontStatus = jsonObject.getString("Transaction Status");
                        String transactionBgcolor = jsonObject.getString("Transaction BGcolor");
                        String transactionTooltip = jsonObject.getString("Transaction Tooltip");
                        String trendLink = jsonObject.getString("trendLink");
                        String metricLink = jsonObject.getString("Metric_DashboardLink");
                        TestMetrics testMetric = new TestMetrics();
                        testMetric.setBaseLineValue(baseLineValue);
                        testMetric.setCurrValue(currValue);
                        if (edLink != null) {
                            testMetric.setEdLink(edLink);
                        } else {
                            testMetric.setEdLink("NA");
                        }
                        testMetric.setOperator(operator);
                        testMetric.setPrevTestRunValue(prevTestValue);
                        testMetric.setInitialValue(initialValue);
                        testMetric.setSLA(sla);
                        if (count.equals("noCount")) {
                            testMetric.setCount("NA");
                        } else {
                            testMetric.setCount(count);
                        }
                        if (trendLink != null) {
                            testMetric.setLinkForTrend(trendLink);
                        } else {
                            testMetric.setLinkForTrend("NA");
                        }
                        boolean fromPattern = false;
                        String patt = jsonObject.getString("PATTERN");
                        if (metric.trim().contains("- PATTERN")) {
                            int len = patt.length() + 2;
                            String dName = metric.substring(metric.indexOf("-") + len + 1, metric.trim().length() - 1);
                            metric = metric.replace(metric.substring(metric.indexOf("-"), metric.length()), "- " + dName);
                            fromPattern = true;
                        }
                        String headerName = "";
                        String displayName = metric;
                        if (index == 0) {
                            str = displayName;
                            if (displayName.contains("- All") && !fromPattern) {
                                headerName = displayName.substring(0, str.lastIndexOf("-") + 5);
                                displayName = displayName.substring(displayName.lastIndexOf("-") + 6, displayName.length() - 1);
                            } else if (displayName.contains(" - ")) {
                                headerName = displayName.substring(0, str.lastIndexOf("-") + 1);
                                displayName = displayName.substring(displayName.lastIndexOf("-") + 1, displayName.length() - 1);
                            } else {
                                headerName = "Other";
                            }
                            ++index;
                        } else if (displayName.contains(" - ") && str.lastIndexOf("-") != -1) {
                            String metricName = displayName.substring(0, displayName.lastIndexOf("-"));
                            if (metricName.toString().trim().equals(str.substring(0, str.lastIndexOf("-")).toString().trim())) {
                                headerName = "";
                                displayName = displayName.contains("- All") && !fromPattern ? displayName.substring(displayName.lastIndexOf("-") + 6, displayName.length() - 1) : displayName.substring(displayName.lastIndexOf("-") + 1, displayName.length());
                            } else {
                                str = displayName;
                                if (displayName.contains("- All") && !fromPattern) {
                                    headerName = displayName.substring(0, displayName.lastIndexOf("-") + 5);
                                    displayName = displayName.substring(displayName.lastIndexOf("-") + 6, displayName.length() - 1);
                                } else if (displayName.contains(" - ")) {
                                    headerName = displayName.substring(0, displayName.lastIndexOf("-"));
                                    displayName = displayName.substring(displayName.lastIndexOf("-") + 1, displayName.length());
                                } else {
                                    headerName = "Other";
                                }
                            }
                        } else if (str.lastIndexOf("-") == -1) {
                            str = displayName;
                            if (displayName.contains("- All") && !fromPattern) {
                                headerName = displayName.substring(0, str.lastIndexOf("-") + 5);
                                displayName = displayName.substring(str.lastIndexOf("-") + 6, displayName.length() - 1);
                            } else if (displayName.contains(" - ")) {
                                headerName = displayName.substring(0, str.lastIndexOf("-"));
                                displayName = displayName.substring(str.lastIndexOf("-") + 1, displayName.length());
                            } else {
                                headerName = "Other";
                            }
                        } else {
                            headerName = "Other";
                        }
                        testMetric.setNewReport("NewReport");
                        testMetric.setDisplayName(displayName);
                        testMetric.setHeaderName(headerName);
                        testMetric.setMetricName(metric);
                        testMetric.setMetricRuleName(metricRule);
                        testMetric.setMetricLink(metricLink);
                        testMetric.setTransactiontStatus(transactiontStatus);
                        testMetric.setStatusColour(transactionBgcolor);
                        testMetric.setTransactionTooltip(transactionTooltip);
                        testMetricsList.add(testMetric);
                        testReportNS.setOperator(operator);
                        testReportNS.setTestMetrics(testMetricsList);
                        if (count.equals("noCount")) {
                            testReportNS.setShowCount("0");
                            continue;
                        }
                        testReportNS.setShowCount("1");
                    }
                } else {
                    if (jsonTestReport.get("Transaction Stats") != null) {
                        JSONObject transStats = (JSONObject)jsonTestReport.get("Transaction Stats");
                        testReportNS = this.metricDataForTrans(transStats, testReportNS, jsonTestReport);
                    }
                    if (jsonTestReport.get("Vector Groups") != null) {
                        JSONObject vectorGroups = (JSONObject)jsonTestReport.get("Vector Groups");
                        testReportNS = this.metricDataForVectorGroups(vectorGroups, testReportNS, jsonTestReport);
                    }
                    if (jsonTestReport.get("Scalar Groups") != null) {
                        JSONObject scalarGroups = (JSONObject)jsonTestReport.get("Scalar Groups");
                        testReportNS = this.metricDataForScalar(scalarGroups, testReportNS, jsonTestReport);
                    }
                }
                int transObj = 1;
                if (jsonTestReport.has("BASETOT")) {
                    transObj = 2;
                }
                for (int i = 0; i < transObj; ++i) {
                    JSONObject transactionJson = null;
                    transactionJson = i == 1 ? jsonTestReport.getJSONObject("BASETOT") : (jsonTestReport.has("TOT") ? jsonTestReport.getJSONObject("TOT") : jsonTestReport.getJSONObject("CTOT"));
                    String complete = "NA";
                    if (transactionJson.getString("complete") != null) {
                        complete = transactionJson.getString("complete");
                    }
                    String totalTimeOut = "NA";
                    if (transactionJson.getString("Time Out") != null) {
                        totalTimeOut = transactionJson.getString("Time Out");
                    }
                    String t4xx = "NA";
                    if (transactionJson.getString("4xx") != null) {
                        t4xx = transactionJson.getString("4xx");
                    }
                    String t5xx = "NA";
                    if (transactionJson.getString("5xx") != null) {
                        t5xx = transactionJson.getString("5xx");
                    }
                    String conFail = "NA";
                    if (transactionJson.getString("ConFail") != null) {
                        conFail = transactionJson.getString("ConFail");
                    }
                    String cvFail = "NA";
                    if (transactionJson.getString("C.V Fail") != null) {
                        cvFail = transactionJson.getString("C.V Fail");
                    }
                    String success = "NA";
                    if (transactionJson.getString("success") != null) {
                        success = transactionJson.getString("success");
                    }
                    String warVersionTrans = "NA";
                    if (transactionJson.has("warVersion")) {
                        warVersionTrans = transactionJson.getString("warVersion");
                    }
                    String releaseVersionTrans = "NA";
                    if (transactionJson.has("releaseVersion")) {
                        releaseVersionTrans = transactionJson.getString("releaseVersion");
                    }
                    TransactionStats transactionStats = new TransactionStats();
                    if (i == 1) {
                        transactionStats.setTransTestRun("BASETOT");
                    } else if (jsonTestReport.has("TOT")) {
                        transactionStats.setTransTestRun("TOT");
                    } else {
                        transactionStats.setTransTestRun("CTOT");
                    }
                    transactionStats.setComplete(complete);
                    transactionStats.setConFail(conFail);
                    transactionStats.setCvFail(cvFail);
                    transactionStats.setSuccess(success);
                    transactionStats.setT4xx(t4xx);
                    transactionStats.setT5xx(t5xx);
                    transactionStats.setTotalTimeOut(totalTimeOut);
                    transactionStats.setWarVersion(warVersionTrans);
                    transactionStats.setReleaseVersion(releaseVersionTrans);
                    testReportNS.getTransStatsList().add(transactionStats);
                }
                testReportNS.setDashboardURL(dashboardURL);
                testReportNS.setReportLink(reportLink);
                testReportNS.setBaseLineTestRun(baseLineTestRun);
                testReportNS.setInitialTestRun(initialTestRun);
                testReportNS.setBaselineDateTime(baseLineDateTime);
                testReportNS.setPreviousDateTime(previousDateTime);
                testReportNS.setInitialDateTime(initialDateTime);
                testReportNS.setOverAllFailCriteria(overAllFailCriteria);
                testReportNS.setDate(date);
                testReportNS.setOverAllStatus(overAllStatus);
                testReportNS.setServerName(serverName);
                testReportNS.setIpPortLabel(productName);
                testReportNS.setPreviousTestRun(previousTestRun);
                testReportNS.setTestRun(testRun);
                testReportNS.setNormalThreshold(normalThreshold);
                testReportNS.setCriticalThreshold(criticalThreshold);
                testReportNS.setCurrentDateTime(currentDateTime);
                testReportNS.setPreviousDescription(previousDescription);
                testReportNS.setBaselineDescription(baselineDescription);
                testReportNS.setInitialDescription(initialDescription);
                testReportNS.setCurrentDescription(currentDescription);
                metricDataContainer.setTestReport(testReportNS);
            }
            TestReport testReportND = new TestReport();
            String[] prefix = this.ndUrlConnectionString.split("//");
            if ("T".equals(testMode)) {
                testReportND = new TestReport();
                JSONObject jsonTestReportWholeObj = resonseObjND.getJSONObject("testReport");
                this.logger.log(Level.INFO, "Recived response from whole report in  case of ND : " + jsonTestReportWholeObj);
                JSONObject jsonTestReport = jsonTestReportWholeObj.getJSONObject("members");
                this.logger.log(Level.INFO, "Recived response from test report in  case of ND : " + jsonTestReport);
                String overAllStatus = jsonTestReport.getString("Overall Status");
                String date = jsonTestReport.getString("Date");
                String overAllFailCriteria = jsonTestReport.getString("Overall Fail Criteria (greater than red) %");
                String serverName = jsonTestReport.getString("IP");
                String productName = jsonTestReport.getString("ProductName");
                String previousTestRun = jsonTestReport.getString("Previous Test Run");
                String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
                String initialTestRun = jsonTestReport.getString("Initial Test Run");
                String baseLineDateTime = jsonTestReport.getString("Baseline Date Time");
                String previousDateTime = jsonTestReport.getString("Previous Date Time");
                String initialDateTime = jsonTestReport.getString("Initial Date Time");
                String testRun = jsonTestReport.getString("Test Run");
                String normalThreshold = jsonTestReport.getString("Normal Threshold");
                String criticalThreshold = jsonTestReport.getString("Critical Threshold");
                String dashboardURL = jsonTestReport.getString("Dashboard Link");
                String reportLink = jsonTestReport.getString("Report Link");
                String currentDateTime = "";
                String previousDescription = "";
                String baselineDescription = "";
                String currentDescription = "";
                String initialDescription = "";
                try {
                    previousDescription = jsonTestReport.getString("Previous Description");
                    baselineDescription = jsonTestReport.getString("Baseline Description");
                    currentDescription = jsonTestReport.getString("Current Description");
                    initialDescription = jsonTestReport.getString("Initial Description");
                }
                catch (Exception ex) {
                    this.logger.log(Level.SEVERE, " NSNDIntegration -Error in parsing Test Report Data from netdiagnostics json :" + ex);
                    this.logger.log(Level.SEVERE, "NSNDIntegration Error ---" + ex.getMessage());
                }
                if (jsonTestReport.get("Metrics Under Test") != null) {
                    JSONArray metricsUnderTest = jsonTestReport.getJSONArray("Metrics Under Test");
                    ArrayList<TestMetrics> testMetricsList = new ArrayList<TestMetrics>(metricsUnderTest.size());
                    String str = "";
                    int index = 0;
                    for (Object jsonData : metricsUnderTest) {
                        JSONObject jsonObject = (JSONObject)jsonData;
                        String prevTestValue = jsonObject.getString("Prev Test Value ");
                        String baseLineValue = jsonObject.getString("Baseline Value ");
                        String initialValue = jsonObject.getString("Initial Value ");
                        String edLink = jsonObject.getString("link");
                        String currValue = jsonObject.getString("Value");
                        String metric = jsonObject.getString("Metric");
                        String metricRule = jsonObject.getString("MetricRule");
                        String operator = jsonObject.getString("Operator");
                        String sla = jsonObject.getString("SLA");
                        if (sla.indexOf(">") != -1 || sla.indexOf(">") > 0) {
                            sla = sla.substring(sla.lastIndexOf(">") + 1, sla.length());
                        }
                        String transactiontStatus = jsonObject.getString("Transaction Status");
                        String transactionBgcolor = jsonObject.getString("Transaction BGcolor");
                        String transactionTooltip = jsonObject.getString("Transaction Tooltip");
                        String trendLink = jsonObject.getString("trendLink");
                        String metricLink = jsonObject.getString("Metric_DashboardLink");
                        String count = jsonObject.getString("Count");
                        TestMetrics testMetric = new TestMetrics();
                        if (count.equals("noCount")) {
                            testMetric.setCount("NA");
                        } else {
                            testMetric.setCount(count);
                        }
                        testMetric.setBaseLineValue(baseLineValue);
                        testMetric.setCurrValue(currValue);
                        if (edLink != null) {
                            testMetric.setEdLink(edLink);
                        } else {
                            testMetric.setEdLink("NA");
                        }
                        testMetric.setOperator(operator);
                        testMetric.setPrevTestRunValue(prevTestValue);
                        testMetric.setInitialValue(initialValue);
                        testMetric.setSLA(sla);
                        testMetric.setLinkForTrend(trendLink);
                        boolean fromPattern = false;
                        String patt = jsonObject.getString("PATTERN");
                        if (metric.trim().contains("- PATTERN")) {
                            int len = patt.length() + 2;
                            String dName = metric.substring(metric.indexOf("-") + len + 1, metric.trim().length() - 1);
                            metric = metric.replace(metric.substring(metric.indexOf("-"), metric.length()), "- " + dName);
                            fromPattern = true;
                        }
                        String headerName = "";
                        String displayName = metric;
                        if (index == 0) {
                            str = displayName;
                            if (displayName.contains("- All") && !fromPattern) {
                                headerName = displayName.substring(0, str.indexOf("-") + 5);
                                displayName = displayName.substring(displayName.indexOf("-") + 6, displayName.length() - 1);
                            } else if (displayName.contains(" - ")) {
                                headerName = displayName.substring(0, str.indexOf("-") + 1);
                                displayName = displayName.substring(displayName.indexOf("-") + 1, displayName.length() - 1);
                            } else {
                                headerName = "Other";
                            }
                            ++index;
                        } else if (displayName.contains(" - ") && str.indexOf("-") != -1) {
                            String metricName = displayName.substring(0, displayName.indexOf("-"));
                            if (metricName.toString().trim().equals(str.substring(0, str.indexOf("-")).toString().trim())) {
                                headerName = "";
                                displayName = displayName.contains("- All") && !fromPattern ? displayName.substring(displayName.indexOf("-") + 6, displayName.length() - 1) : displayName.substring(displayName.indexOf("-") + 1, displayName.length());
                            } else {
                                str = displayName;
                                if (displayName.contains("- All") && !fromPattern) {
                                    headerName = displayName.substring(0, displayName.indexOf("-") + 5);
                                    displayName = displayName.substring(displayName.indexOf("-") + 6, displayName.length() - 1);
                                } else if (displayName.contains(" - ")) {
                                    headerName = displayName.substring(0, displayName.indexOf("-"));
                                    displayName = displayName.substring(displayName.indexOf("-") + 1, displayName.length());
                                } else {
                                    headerName = "Other";
                                }
                            }
                        } else if (str.indexOf("-") == -1) {
                            str = displayName;
                            if (displayName.contains("- All") && !fromPattern) {
                                headerName = displayName.substring(0, str.indexOf("-") + 5);
                                displayName = displayName.substring(str.indexOf("-") + 6, displayName.length() - 1);
                            } else if (displayName.contains(" - ")) {
                                headerName = displayName.substring(0, str.indexOf("-"));
                                displayName = displayName.substring(str.indexOf("-") + 1, displayName.length());
                            } else {
                                headerName = "Other";
                            }
                        } else {
                            headerName = "Other";
                        }
                        testMetric.setNewReport("NewReport");
                        testMetric.setDisplayName(displayName);
                        testMetric.setHeaderName(headerName);
                        testMetric.setMetricName(metric);
                        testMetric.setMetricRuleName(metricRule);
                        testMetric.setTransactiontStatus(transactiontStatus);
                        testMetric.setStatusColour(transactionBgcolor);
                        testMetric.setTransactionTooltip(transactionTooltip);
                        testMetric.setMetricLink(metricLink);
                        testMetricsList.add(testMetric);
                        testReportND.setOperator(operator);
                        testReportND.setTestMetrics(testMetricsList);
                    }
                } else {
                    if (jsonTestReport.get("Transaction Stats") != null) {
                        JSONObject transStats = (JSONObject)jsonTestReport.get("Transaction Stats");
                        testReportND = this.metricDataForTrans(transStats, testReportND, jsonTestReport);
                    }
                    if (jsonTestReport.get("Vector Groups") != null) {
                        JSONObject vectorGroups = (JSONObject)jsonTestReport.get("Vector Groups");
                        testReportND = this.metricDataForVectorGroups(vectorGroups, testReportND, jsonTestReport);
                    }
                    if (jsonTestReport.get("Scalar Groups") != null) {
                        JSONObject scalarGroups = (JSONObject)jsonTestReport.get("Scalar Groups");
                        testReportND = this.metricDataForScalar(scalarGroups, testReportND, jsonTestReport);
                    }
                }
                int transObj = 1;
                if (jsonTestReport.has("BASETOT")) {
                    transObj = 2;
                }
                testReportND.setShowHideTransaction(true);
                testReportND.setDashboardURL(dashboardURL);
                testReportND.setReportLink(reportLink);
                testReportND.setBaseLineTestRun(baseLineTestRun);
                testReportND.setInitialTestRun(initialTestRun);
                testReportND.setBaselineDateTime(baseLineDateTime);
                testReportND.setPreviousDateTime(previousDateTime);
                testReportND.setInitialDateTime(initialDateTime);
                testReportND.setOverAllFailCriteria(overAllFailCriteria);
                testReportND.setDate(date);
                testReportND.setOverAllStatus(overAllStatus);
                testReportND.setServerName(serverName);
                testReportND.setIpPortLabel(productName);
                testReportND.setPreviousTestRun(previousTestRun);
                testReportND.setTestRun(testRun);
                testReportND.setNormalThreshold(normalThreshold);
                testReportND.setCriticalThreshold(criticalThreshold);
                testReportND.setCurrentDateTime(this.ndParam.getCurStartTime().replace("@", " ") + " to " + this.ndParam.getCurEndTime().replace("@", " "));
                testReportND.setPreviousDescription(previousDescription);
                testReportND.setBaselineDescription(baselineDescription);
                testReportND.setInitialDescription(initialDescription);
                testReportND.setCurrentDescription(currentDescription);
                metricDataContainer.setTestReportND(testReportND);
            }
            Set keySet = jsonGraphs.keySet();
            for (String key : keySet) {
                MetricData metricData = new MetricData();
                JSONObject graphJsonObj = (JSONObject)jsonGraphs.get(key);
                String graphName = (String)graphJsonObj.get("graphMetricPath");
                metricData.setMetricPath(graphName.substring(graphName.indexOf("|") + 1));
                metricData.setFrequency(String.valueOf(freq));
                JSONArray jsonArray = (JSONArray)graphJsonObj.get("graphMetricValues");
                ArrayList<MetricValues> list = new ArrayList<MetricValues>();
                for (Object jsonArray1 : jsonArray) {
                    MetricValues values = new MetricValues();
                    JSONObject graphValues = (JSONObject)jsonArray1;
                    String currVal = String.valueOf(graphValues.get("currentValue"));
                    String maxVal = String.valueOf(graphValues.get("maxValue"));
                    String minVal = String.valueOf(graphValues.get("minValue"));
                    String avg = String.valueOf(graphValues.get("avgValue"));
                    long timeStamp = (Long)graphValues.get("timeStamp");
                    values.setValue((Double)graphValues.get("currentValue"));
                    values.setMax((Double)graphValues.get("maxValue"));
                    values.setMin(this.getMinForMetric((Double)graphValues.get("minValue")));
                    values.setStartTimeInMillis(timeStamp);
                    list.add(values);
                }
                metricData.setMetricValues(list);
                dataList.add(metricData);
                metricDataContainer.setMetricDataList(dataList);
            }
            if (testMode.equals("T")) {
                ArrayList<MetricData> baseLineMetricDataList;
                JSONObject jsonGraphObj;
                ArrayList<MetricData> prevMetricDataList;
                if (resonseObj.get("previousTestDataMap") != null && (prevMetricDataList = this.parsePreviousAndBaseLineData(jsonGraphObj = (JSONObject)resonseObj.get("previousTestDataMap"), freq, "Previous Test Run")) != null) {
                    this.logger.log(Level.INFO, "Setting previous test data in metric container = " + prevMetricDataList);
                    metricDataContainer.setMetricPreviousDataList(prevMetricDataList);
                }
                if (resonseObj.get("baseLineTestDataMap") != null && (baseLineMetricDataList = this.parsePreviousAndBaseLineData(jsonGraphObj = (JSONObject)resonseObj.get("baseLineTestDataMap"), freq, "Base Line Test Run")) != null) {
                    this.logger.log(Level.INFO, "Setting baseline test data in metric container = " + baseLineMetricDataList);
                    metricDataContainer.setMetricBaseLineDataList(baseLineMetricDataList);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "NSNDIntegration - Error in parsing metrics stats");
            this.logger.log(Level.SEVERE, "NSNDIntegration - Metric Data:" + e);
            this.logger.log(Level.SEVERE, "NSNDIntegration ---" + e.getMessage());
            return null;
        }
        this.logger.log(Level.INFO, "NSNDIntegration - Metric Data:" + metricDataContainer);
        return metricDataContainer;
    }

    private TestReport metricDataForVectorGroups(JSONObject vectorGroups, TestReport testReport, JSONObject jsonTestReport) {
        try {
            this.logger.log(Level.INFO, "metricDataForVectorGroups() called.");
            String previousTestRun = jsonTestReport.getString("Previous Test Run");
            String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
            String initialTestRun = jsonTestReport.getString("Initial Test Run");
            ArrayList<MetricInfo> arr = new ArrayList<MetricInfo>();
            Iterator keys = vectorGroups.keys();
            while (keys.hasNext()) {
                String groupName = (String)keys.next();
                MetricInfo info = new MetricInfo();
                info.setGroupName(groupName);
                JSONObject groupInfo = (JSONObject)vectorGroups.get(groupName);
                JSONArray metricListForVector = (JSONArray)groupInfo.get("MetricName");
                JSONArray vectorListForVector = (JSONArray)groupInfo.get("vector List");
                JSONObject metricInfoForVector = (JSONObject)groupInfo.get("Metric Info");
                JSONObject linkInfo = (JSONObject)groupInfo.get("link");
                ArrayList<String> vectorList = new ArrayList<String>();
                ArrayList<ScalarVal> arrForVectorinfo = new ArrayList<ScalarVal>();
                for (int i = 0; i < vectorListForVector.size(); ++i) {
                    vectorList.add((String)vectorListForVector.get(i));
                }
                info.setVectorList(vectorList);
                ArrayList<MetricLinkInfo> metricLinkInfo = new ArrayList<MetricLinkInfo>();
                for (int i = 0; i < vectorListForVector.size(); ++i) {
                    String vectorNameVec = (String)vectorListForVector.get(i);
                    this.logger.log(Level.INFO, "vector name--" + vectorNameVec);
                    for (int j = 0; j < metricListForVector.size(); ++j) {
                        String metricNameVec = (String)metricListForVector.get(j);
                        this.logger.log(Level.INFO, "metric name--" + metricNameVec);
                        if (!metricInfoForVector.containsKey((Object)vectorNameVec)) continue;
                        JSONArray vectorInfo = (JSONArray)metricInfoForVector.get(vectorNameVec);
                        for (int k = 0; k < vectorInfo.size(); ++k) {
                            JSONObject metricVecInfo = (JSONObject)vectorInfo.get(k);
                            if (!metricVecInfo.containsKey((Object)metricNameVec)) continue;
                            JSONObject metricInfoFinal = (JSONObject)metricVecInfo.get(metricNameVec);
                            ScalarVal finalInfoForVector = new ScalarVal();
                            String Op = (String)metricInfoFinal.get("Operator");
                            String prev = (String)metricInfoFinal.get("Prev Test Value ");
                            String Product = (String)metricInfoFinal.get("Prod");
                            String baselineValue = (String)metricInfoFinal.get("Baseline Value ");
                            String transStatus = (String)metricInfoFinal.get("Transaction Status");
                            String transTooltip = (String)metricInfoFinal.get("Transaction Tooltip");
                            String transBGcolor = (String)metricInfoFinal.get("Transaction BGcolor");
                            String Value = (String)metricInfoFinal.get("Value");
                            String linkss = (String)metricInfoFinal.get("link");
                            String trendLink = (String)metricInfoFinal.get("Trend Link");
                            String SLA = (String)metricInfoFinal.get("SLA");
                            String initialValue = (String)metricInfoFinal.get("Initial Value ");
                            String Stress = (String)metricInfoFinal.get("Stress");
                            finalInfoForVector.setOperator(Op);
                            finalInfoForVector.setPrevTestValue(prev);
                            finalInfoForVector.setProd(Product);
                            finalInfoForVector.setBaselineValue(baselineValue);
                            finalInfoForVector.setTransactionStatus(transStatus);
                            finalInfoForVector.setTransactionTooltip(transTooltip);
                            finalInfoForVector.setTransactionBGcolor(transBGcolor);
                            finalInfoForVector.setValue(Value);
                            finalInfoForVector.setLink(linkss);
                            finalInfoForVector.setSLA(SLA);
                            finalInfoForVector.setInitialValue(initialValue);
                            finalInfoForVector.setStress(Stress);
                            finalInfoForVector.setMetricName(metricNameVec);
                            finalInfoForVector.setVectorName(vectorNameVec);
                            finalInfoForVector.setTrendLink(trendLink);
                            arrForVectorinfo.add(finalInfoForVector);
                        }
                    }
                    MetricLinkInfo link = new MetricLinkInfo();
                    link.setVectorName(vectorNameVec);
                    String lnk = (String)linkInfo.get(vectorNameVec);
                    link.setLink(lnk);
                    metricLinkInfo.add(link);
                }
                info.setMetricLink(metricLinkInfo);
                info.setGroupInfo(arrForVectorinfo);
                ArrayList<MetricVal> vectorArrFinal = new ArrayList<MetricVal>();
                String vectorVal = vectorList.get(0);
                for (int i = 0; i < metricListForVector.size(); ++i) {
                    String metrcNames = (String)metricListForVector.get(i);
                    int counts = 0;
                    MetricVal metrVal = new MetricVal();
                    JSONArray metricArrSec = (JSONArray)metricInfoForVector.get(vectorVal);
                    for (int j = 0; j < metricArrSec.size(); ++j) {
                        String trans;
                        String st;
                        JSONObject metricObj = (JSONObject)metricArrSec.get(j);
                        if (!metricObj.containsKey((Object)metrcNames)) continue;
                        JSONObject finalMetric = (JSONObject)metricObj.get(metrcNames);
                        ArrayList<String> headerForVector = new ArrayList<String>();
                        headerForVector.add("SLA");
                        String pr = (String)finalMetric.get("Prod");
                        if (!pr.equals("0.0") && !pr.equals("-")) {
                            ++counts;
                            headerForVector.add("Prod");
                            metrVal.setProd(true);
                        }
                        if (!(st = (String)finalMetric.get("Stress")).equals("0.0") && !st.equals("-")) {
                            ++counts;
                            headerForVector.add("Stress");
                            metrVal.setStress(true);
                        }
                        if (!baseLineTestRun.equals("-1")) {
                            ++counts;
                            headerForVector.add("Baseline TR");
                        }
                        if (!initialTestRun.equals("-1")) {
                            ++counts;
                            headerForVector.add("Initial TR");
                        }
                        if (!previousTestRun.equals("-1")) {
                            ++counts;
                            headerForVector.add("Previous TR");
                        }
                        if (!(trans = (String)finalMetric.get("Transaction Status")).equals("-1")) {
                            ++counts;
                            headerForVector.add("Success (%)");
                            metrVal.setTrans(true);
                        }
                        metrVal.setCountForBenchmark(++counts);
                        int countForMetrices = counts + 2;
                        metrVal.setCountForMetrices(countForMetrices);
                        metrVal.setHeadersForTrans(headerForVector);
                        metrVal.setNameOfMetric(metrcNames);
                    }
                    vectorArrFinal.add(metrVal);
                }
                info.setVectorObj(vectorArrFinal);
                arr.add(info);
            }
            testReport.setVectorValues(arr);
            return testReport;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error in getting metric data for vector Group");
            this.logger.log(Level.SEVERE, "Metric Data:" + e);
            this.logger.log(Level.SEVERE, "---" + e.getMessage());
            return null;
        }
    }

    private TestReport metricDataForTrans(JSONObject transGroup, TestReport testReport, JSONObject jsonTestReport) {
        try {
            JSONObject metricObj;
            this.logger.log(Level.INFO, "metricDataForTrans() called.");
            String previousTestRun = jsonTestReport.getString("Previous Test Run");
            String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
            String initialTestRun = jsonTestReport.getString("Initial Test Run");
            JSONArray metricNamesForTrans = (JSONArray)transGroup.get("MetricName");
            JSONArray vectorListForTrans = (JSONArray)transGroup.get("vector List");
            JSONObject metricInfoForTrans = (JSONObject)transGroup.get("Metric Info");
            JSONObject linkObj = (JSONObject)transGroup.get("link");
            boolean prodCount = false;
            boolean stressCount = false;
            ArrayList<ScalarVal> transArr = new ArrayList<ScalarVal>();
            ArrayList<String> vectorForTrans = new ArrayList<String>();
            for (int i = 0; i < vectorListForTrans.size(); ++i) {
                vectorForTrans.add((String)vectorListForTrans.get(i));
            }
            testReport.setVecList(vectorForTrans);
            ArrayList<MetricLinkInfo> merticLink = new ArrayList<MetricLinkInfo>();
            for (int i = 0; i < vectorListForTrans.size(); ++i) {
                String vectorNameTrans = (String)vectorListForTrans.get(i);
                for (int j = 0; j < metricNamesForTrans.size(); ++j) {
                    String metricNameTranss = (String)metricNamesForTrans.get(j);
                    ScalarVal transValue = new ScalarVal();
                    if (metricInfoForTrans.containsKey((Object)vectorNameTrans)) {
                        JSONArray metricArr = (JSONArray)metricInfoForTrans.get(vectorNameTrans);
                        for (int k = 0; k < metricArr.size(); ++k) {
                            JSONObject newMetric = (JSONObject)metricArr.get(k);
                            if (!newMetric.containsKey((Object)metricNameTranss)) continue;
                            metricObj = (JSONObject)newMetric.get(metricNameTranss);
                            String Oper = (String)metricObj.get("Operator");
                            String prevTest = (String)metricObj.get("Prev Test Value ");
                            String Production = (String)metricObj.get("Prod");
                            String baselineVal = (String)metricObj.get("Baseline Value ");
                            String transStatus = (String)metricObj.get("Transaction Status");
                            String transactionTool = (String)metricObj.get("Transaction Tooltip");
                            String transactionBG = (String)metricObj.get("Transaction BGcolor");
                            String Val = (String)metricObj.get("Value");
                            String links = (String)metricObj.get("link");
                            String sla = (String)metricObj.get("SLA");
                            String initialVal = (String)metricObj.get("Initial Value ");
                            String stress = (String)metricObj.get("Stress");
                            String trendLink = (String)metricObj.get("Trend Link");
                            transValue.setOperator(Oper);
                            transValue.setPrevTestValue(prevTest);
                            transValue.setProd(Production);
                            transValue.setBaselineValue(baselineVal);
                            transValue.setTransactionStatus(transStatus);
                            transValue.setTransactionTooltip(transactionTool);
                            transValue.setTransactionBGcolor(transactionBG);
                            transValue.setValue(Val);
                            transValue.setLink(links);
                            transValue.setSLA(sla);
                            transValue.setInitialValue(initialVal);
                            transValue.setStress(stress);
                            transValue.setMetricName(metricNameTranss);
                            transValue.setVectorName(vectorNameTrans);
                            transValue.setTrendLink(trendLink);
                        }
                    }
                    transArr.add(transValue);
                }
                MetricLinkInfo linkInfo = new MetricLinkInfo();
                linkInfo.setVectorName(vectorNameTrans);
                String link = (String)linkObj.get(vectorNameTrans);
                linkInfo.setLink(link);
                merticLink.add(linkInfo);
            }
            testReport.setTransactionStats(transArr);
            testReport.setTransMetricLink(merticLink);
            ArrayList<MetricVal> metricArrFinal = new ArrayList<MetricVal>();
            String vectorAny = vectorForTrans.get(0);
            for (int i = 0; i < metricNamesForTrans.size(); ++i) {
                String metrcNames = (String)metricNamesForTrans.get(i);
                int count = 0;
                MetricVal metrVal = new MetricVal();
                JSONArray metricArrSec = (JSONArray)metricInfoForTrans.get(vectorAny);
                for (int j = 0; j < metricArrSec.size(); ++j) {
                    String transactionStatus;
                    String stress;
                    metricObj = (JSONObject)metricArrSec.get(j);
                    if (!metricObj.containsKey((Object)metrcNames)) continue;
                    JSONObject finalMetric = (JSONObject)metricObj.get(metrcNames);
                    ArrayList<String> transHeader = new ArrayList<String>();
                    transHeader.add("SLA");
                    String prod = (String)finalMetric.get("Prod");
                    if (!prod.equals("0.0") && !prod.equals("-")) {
                        ++count;
                        transHeader.add("Prod");
                        metrVal.setProd(true);
                    }
                    if (!(stress = (String)finalMetric.get("Stress")).equals("0.0") && !stress.equals("-")) {
                        ++count;
                        transHeader.add("Stress");
                        metrVal.setStress(true);
                    }
                    if (!baseLineTestRun.equals("-1")) {
                        ++count;
                        transHeader.add("Baseline TR");
                    }
                    if (!initialTestRun.equals("-1")) {
                        ++count;
                        transHeader.add("Initial TR");
                    }
                    if (!previousTestRun.equals("-1")) {
                        ++count;
                        transHeader.add("Previous TR");
                    }
                    if (!(transactionStatus = (String)finalMetric.get("Transaction Status")).equals("-1")) {
                        ++count;
                        transHeader.add("Success (%)");
                        metrVal.setTrans(true);
                    }
                    metrVal.setCountForBenchmark(++count);
                    int countForMetrices = count + 2;
                    metrVal.setCountForMetrices(countForMetrices);
                    metrVal.setHeadersForTrans(transHeader);
                    metrVal.setNameOfMetric(metrcNames);
                }
                metricArrFinal.add(metrVal);
            }
            testReport.setMetricValues(metricArrFinal);
            return testReport;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error in getting metric data");
            this.logger.log(Level.SEVERE, "Metric Data:" + e);
            this.logger.log(Level.SEVERE, "---" + e.getMessage());
            return null;
        }
    }

    private TestReport metricDataForScalar(JSONObject scalarGroups, TestReport testReport, JSONObject jsonTestReport) {
        try {
            this.logger.log(Level.INFO, "metricDataForScalar() called.");
            String previousTestRun = jsonTestReport.getString("Previous Test Run");
            String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
            String initialTestRun = jsonTestReport.getString("Initial Test Run");
            JSONArray metricNames = (JSONArray)scalarGroups.get("MetricName");
            JSONObject metricGrp = (JSONObject)scalarGroups.get("Metric Info");
            JSONObject metricLink = (JSONObject)scalarGroups.get("link");
            ArrayList<ScalarVal> scalarArr = new ArrayList<ScalarVal>();
            int countForProd = 0;
            int countForStress = 0;
            int countForTrans = 0;
            ArrayList<String> scalarHeader = new ArrayList<String>();
            for (int i = 0; i < metricNames.size(); ++i) {
                String name = (String)metricNames.get(i);
                if (!metricGrp.containsKey((Object)name)) continue;
                JSONObject scalarVal = (JSONObject)metricGrp.get(name);
                String Operator = (String)scalarVal.get("Operator");
                String preValue = (String)scalarVal.get("Prev Test Value ");
                String Prod = (String)scalarVal.get("Prod");
                String baselineValue = (String)scalarVal.get("Baseline Value ");
                String transactionStatus = (String)scalarVal.get("Transaction Status");
                String transactionTooltip = (String)scalarVal.get("Transaction Tooltip");
                String transactionBGcolor = (String)scalarVal.get("Transaction BGcolor");
                String Value = (String)scalarVal.get("Value");
                String link = (String)metricLink.get(name);
                String trendLink = (String)scalarVal.get("Trend Link");
                String SLA = (String)scalarVal.get("SLA");
                String initialValue = (String)scalarVal.get("Initial Value ");
                String Stress = (String)scalarVal.get("Stress");
                this.logger.log(Level.INFO, "Prev Test Value------ " + preValue);
                if (!Prod.equals("0.0") && !Prod.equals("-1")) {
                    ++countForProd;
                }
                if (!Stress.equals("0.0") && !Stress.equals("-1")) {
                    ++countForStress;
                }
                if (!transactionStatus.equals("-1")) {
                    ++countForTrans;
                }
                ScalarVal scalarValue = new ScalarVal();
                scalarValue.setOperator(Operator);
                scalarValue.setPrevTestValue(preValue);
                scalarValue.setProd(Prod);
                scalarValue.setBaselineValue(baselineValue);
                scalarValue.setTransactionStatus(transactionStatus);
                scalarValue.setTransactionTooltip(transactionTooltip);
                scalarValue.setTransactionBGcolor(transactionBGcolor);
                scalarValue.setValue(Value);
                scalarValue.setLink(link);
                scalarValue.setSLA(SLA);
                scalarValue.setInitialValue(initialValue);
                scalarValue.setStress(Stress);
                scalarValue.setMetricName(name);
                scalarValue.setTrendLink(trendLink);
                scalarArr.add(scalarValue);
            }
            testReport.setScalarGroups(scalarArr);
            scalarHeader.add("SLA");
            if (countForProd != 0) {
                scalarHeader.add("Prod");
            }
            if (countForStress != 0) {
                scalarHeader.add("Stress");
            }
            if (!baseLineTestRun.equals("-1")) {
                scalarHeader.add("Baseline TR");
            }
            if (!initialTestRun.equals("-1")) {
                scalarHeader.add("Initial TR");
            }
            if (!previousTestRun.equals("-1")) {
                scalarHeader.add("Previous TR");
            }
            if (countForTrans != 0) {
                scalarHeader.add("Success(%)");
            }
            scalarHeader.add("Current");
            scalarHeader.add("Trend");
            scalarHeader.add("Action");
            testReport.setScalarHeaders(scalarHeader);
            return testReport;
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error in parsing previous or baseline metrics stats");
            this.logger.log(Level.SEVERE, "---" + ex.getMessage());
            return null;
        }
    }

    private ArrayList<MetricData> parsePreviousAndBaseLineData(JSONObject jsonGraphData, int freq, String type) {
        try {
            this.logger.log(Level.INFO, "parsePreviousAndBaseLineData method in Integration  called for type = " + type);
            ArrayList<MetricData> listData = new ArrayList<MetricData>();
            Set keySet = jsonGraphData.keySet();
            if (keySet.size() < 1) {
                this.logger.log(Level.INFO, "Graph Metrics is not available in integration for " + type);
                return null;
            }
            for (Object keyValue : keySet) {
                if (jsonGraphData.get(keyValue) == null) {
                    return null;
                }
                JSONObject graphWithDataJson = (JSONObject)jsonGraphData.get(keyValue);
                Set keys = graphWithDataJson.keySet();
                for (String key : keys) {
                    MetricData metricData = new MetricData();
                    JSONObject graphJsonObj = (JSONObject)graphWithDataJson.get(key);
                    String graphName = (String)graphJsonObj.get("graphMetricPath");
                    metricData.setMetricPath(graphName.substring(graphName.indexOf("|") + 1));
                    metricData.setFrequency(String.valueOf(freq));
                    JSONArray jsonArray = (JSONArray)graphJsonObj.get("graphMetricValues");
                    ArrayList<MetricValues> list = new ArrayList<MetricValues>();
                    for (Object jsonArray1 : jsonArray) {
                        MetricValues values = new MetricValues();
                        JSONObject graphValues = (JSONObject)jsonArray1;
                        String currVal = String.valueOf(graphValues.get("currentValue"));
                        String maxVal = String.valueOf(graphValues.get("maxValue"));
                        String minVal = String.valueOf(graphValues.get("minValue"));
                        String avg = String.valueOf(graphValues.get("avgValue"));
                        long timeStamp = (Long)graphValues.get("timeStamp");
                        values.setValue((Double)graphValues.get("currentValue"));
                        values.setMax((Double)graphValues.get("maxValue"));
                        values.setMin(this.getMinForMetric((Double)graphValues.get("minValue")));
                        values.setStartTimeInMillis(timeStamp);
                        list.add(values);
                    }
                    metricData.setMetricValues(list);
                    listData.add(metricData);
                }
            }
            return listData;
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "NSNDIntegration  - Error in parsing previous or baseline metrics stats");
            this.logger.log(Level.SEVERE, "NSNDIntegration ---" + ex.getMessage());
            return null;
        }
    }

    private double getMinForMetric(double metricValue) {
        if (metricValue == Double.MAX_VALUE) {
            return 0.0;
        }
        return metricValue;
    }

    public JSONObject makeRequestObject(String type) {
        JSONObject jsonRequest = new JSONObject();
        if (type.equals("GET_DATA")) {
            jsonRequest.put(JSONKeys.USERNAME.getValue(), (Object)this.nsUsername);
            jsonRequest.put(JSONKeys.PASSWORD.getValue(), (Object)this.nsPassword.getPlainText());
            jsonRequest.put(JSONKeys.OPERATION_TYPE.getValue(), (Object)OperationType.GETDATA.toString());
            jsonRequest.put(JSONKeys.STATUS.getValue(), (Object)Boolean.FALSE);
        }
        return jsonRequest;
    }

    static {
        NSNDIntegrationConnectionManager.disableSslVerification();
    }

    private static enum OperationType {
        START_TEST,
        AUTHENTICATE_USER,
        GETDATA,
        GETPROJECT,
        GETSUBPROJECT,
        GETSCENARIOS;

    }

    private static enum JSONKeys {
        URLCONNECTION("URLConnectionString"),
        USERNAME("username"),
        PASSWORD("password"),
        PROJECT("project"),
        SUBPROJECT("subproject"),
        OPERATION_TYPE("Operation"),
        SCENARIO("scenario"),
        STATUS("Status"),
        TEST_RUN("TESTRUN"),
        TESTMODE("testmode"),
        GETPROJECT("PROJECTLIST"),
        GETSUBPROJECT("SUBPROJECTLIST"),
        GETSCENARIOS("SCENARIOLIST"),
        BASELINE_TR("baselineTR"),
        REPORT_STATUS("reportStatus");

        private final String value;

        private JSONKeys(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

