/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import hudson.util.FormValidation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class FieldValidator {
    FieldValidator() {
    }

    public static FormValidation validateURLConnectionString(String URLConnectionString) {
        FormValidation validationResult = FieldValidator.isEmptyField(URLConnectionString) ? FormValidation.error((String)"URL connection string cannot be empty and should start with http:// or https://") : (!URLConnectionString.startsWith("http://") && !URLConnectionString.startsWith("https://") ? FormValidation.error((String)"URL connection should start with http:// or https://") : FormValidation.ok());
        return validationResult;
    }

    public static FormValidation validateUsername(String username) {
        FormValidation validationResult = FieldValidator.isEmptyField(username) ? FormValidation.error((String)"Username shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateThresholdValues(String thresholdValue) {
        String regex = "^[0-9]{2}$";
        FormValidation validationResult = FieldValidator.isEmptyField(thresholdValue) ? FormValidation.error((String)"Threshold value shouldn't be empty") : (!thresholdValue.matches(regex) ? FormValidation.error((String)"Please enter correct value.") : FormValidation.ok());
        return validationResult;
    }

    public static FormValidation validateDateTime(String dateTime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Date testDate = null;
        if (dateTime != null && !dateTime.equals("")) {
            testDate = sdf.parse(dateTime);
        }
        if (FieldValidator.isEmptyField(dateTime)) {
            FormValidation formValidation = FormValidation.error((String)"Baseline date time shouldn't be empty");
        }
        FormValidation validationResult = !FieldValidator.isEmptyField(dateTime) && !sdf.format(testDate).equals(dateTime) ? FormValidation.error((String)"Please enter correct format i.e. MM/dd/yyyy HH:mm:ss") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validatePassword(String password) {
        FormValidation validationResult = FieldValidator.isEmptyField(password) ? FormValidation.error((String)"Password shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateProject(String projectName) {
        FormValidation validationResult = FieldValidator.isEmptyField(projectName) ? FormValidation.error((String)"Project name shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateSubProjectName(String subprojectName) {
        FormValidation validationResult = FieldValidator.isEmptyField(subprojectName) ? FormValidation.error((String)"Sub Project name shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateScenario(String scenario) {
        FormValidation validationResult = FieldValidator.isEmptyField(scenario) ? FormValidation.error((String)"Scenario shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateHtmlTablePath(String htmlTablePath) {
        FormValidation validationResult = FieldValidator.isEmptyField(htmlTablePath) ? FormValidation.error((String)"Report path shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateProtocol(String protocol) {
        FormValidation validationResult = FieldValidator.isEmptyField(protocol) ? FormValidation.error((String)"Protocol shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateRepoIp(String repoIp) {
        FormValidation validationResult = FieldValidator.isEmptyField(repoIp) ? FormValidation.error((String)"Repository IP shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateRepoPort(String repoPort) {
        FormValidation validationResult = FieldValidator.isEmptyField(repoPort) ? FormValidation.error((String)"Repository Port shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateRepoPath(String repoPath) {
        FormValidation validationResult = FieldValidator.isEmptyField(repoPath) ? FormValidation.error((String)"Repository Path shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateRepoUsername(String repoUsername) {
        FormValidation validationResult = FieldValidator.isEmptyField(repoUsername) ? FormValidation.error((String)"Repository username shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static FormValidation validateRepoPassword(String repoPassword) {
        FormValidation validationResult = FieldValidator.isEmptyField(repoPassword) ? FormValidation.error((String)"Repository password shouldn't be empty") : FormValidation.ok();
        return validationResult;
    }

    public static boolean isEmptyField(String field) {
        return field == null || field.trim().length() <= 0;
    }
}

