/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.NetStormStopThread;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class BuildActionStopThread
implements ModelObject {
    private static final transient Logger logger = Logger.getLogger(BuildActionStopThread.class.getName());
    private transient NetStormStopThread buildAction;
    private static Run<?, ?> currentBuild = null;
    private static String job_id = "";
    public static String username = "";
    public static String portStr = "";

    BuildActionStopThread(NetStormStopThread buildAction, TaskListener listener) throws IOException {
        this.buildAction = buildAction;
        this.addPreviousBuildReportToExistingReport();
    }

    public BuildActionStopThread(String job_id, String userName, String portStr) {
        logger.log(Level.INFO, "NetStormStopThread: job_id = " + job_id + ", username = " + userName + ", portStr = " + portStr);
        BuildActionStopThread.job_id = job_id;
        username = userName;
        BuildActionStopThread.portStr = portStr;
        logger.log(Level.INFO, "NetStormStopAction: after testRun = " + BuildActionStopThread.job_id + ", username = " + username + ", portStr = " + BuildActionStopThread.portStr);
    }

    public String getDisplayName() {
        return "Stop";
    }

    public Run<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    private void addPreviousBuildReportToExistingReport() {
        if (currentBuild == null) {
            currentBuild = this.getBuild();
        } else if (currentBuild != this.getBuild()) {
            currentBuild = null;
            return;
        }
        Run previousBuild = this.getBuild().getPreviousBuild();
        if (previousBuild == null) {
            return;
        }
        NetStormStopThread previousPerformanceAction = (NetStormStopThread)previousBuild.getAction(NetStormStopThread.class);
        if (previousPerformanceAction == null) {
            return;
        }
        BuildActionStopThread previousBuildActionResults = previousPerformanceAction.getBuildActionResultsDisplay();
        if (previousBuildActionResults == null) {
            return;
        }
    }

    @JavaScriptMethod
    public String stopRunningTest(String jobid, String username, String url) {
        try {
            logger.log(Level.INFO, "stopRunningTest: after job id = " + job_id + ", username = " + BuildActionStopThread.username + ", portStr = " + portStr);
            logger.log(Level.INFO, "stopRunningTest: going to wait");
            logger.log(Level.INFO, "stopRunningTest: get result = " + this.getBuild().getResult());
            logger.log(Level.INFO, "stopRunningTest: wait is over");
            String str = "";
            URL urll = new URL(url + "/ProductUI/productSummary/jenkinsService/stopMultipleTest?username=" + username + "&Job_Id=" + jobid);
            try {
                HttpURLConnection connectt = (HttpURLConnection)urll.openConnection();
                connectt.setRequestMethod("GET");
                connectt.setRequestProperty("Accept", "application/json");
                if (connectt.getResponseCode() != 200) {
                    logger.log(Level.INFO, "stopRunningTest: Getting Error  = " + connectt.getResponseCode());
                }
                BufferedReader brr = new BufferedReader(new InputStreamReader(connectt.getInputStream()));
                String res = brr.readLine();
                logger.log(Level.INFO, "stopRunningTest res = " + res);
                str = res;
                logger.log(Level.INFO, "stopRunningTest: build status = " + connectt.getResponseCode());
                this.getBuild().setResult(Result.ABORTED);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unknown exception in stopping test -", ex);
                return null;
            }
            return str;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception: Unable to stop running test. Error -" + e);
            return null;
        }
    }
}

